/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @exports nmodule/webEditors/rc/wb/profile/selectionModeSettings
 */

define([], function () {
  'use strict';

  var TOGGLE_MODE = 'toggle';
  var SELECT_MODE = 'select';
  var SWATH_MODE = 'swath';
  var currentMode = SELECT_MODE;
  var exports = {
    /**
     * Gets the current selection mode of this session.
     *
     * @returns {String} `toggle` or `select', defaults to `select`
     */
    getSelectionMode: function getSelectionMode() {
      return currentMode;
    },
    /**
     * Sets the current selection mode of this session.
     *
     * @param {String} mode `toggle` or `select`
     */
    setSelectionMode: function setSelectionMode(mode) {
      currentMode = mode;
    },
    /**
     * Determine the current selection mode based upon the current selection mode setting and the
     * provided event.
     *
     * If ctrlKey or shiftKey are detected on the event, this will override the current selection mode.
     *
     * @param {Event|JQuery.Event} e
     * @param {Boolean} [isSwathSupported=true] determines whether or not swatch is considered a valid selection mode
     * in respect to the given event
     * @returns {String} `select`, `toggle`, or `swath`
     */
    getSelectionModeFromEvent: function getSelectionModeFromEvent(e) {
      var isSwathSupported = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      if (isSwathSupported && e.shiftKey) {
        return 'swath';
      }
      if (e.ctrlKey) {
        return 'toggle';
      }
      return exports.getSelectionMode();
    },
    TOGGLE_MODE: TOGGLE_MODE,
    SELECT_MODE: SELECT_MODE,
    SWATH_MODE: SWATH_MODE
  };
  return exports;
});
