function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

define(['baja!', 'bajaux/commands/UndoManager', 'bajaux/Widget', 'jquery', 'log!nmodule.webEditors.rc.wb.profile.profileUtils', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/servlets/views', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/commands/SelectionModeCommand', 'nmodule/webEditors/rc/wb/commands/RedoCommand', 'nmodule/webEditors/rc/wb/commands/UndoCommand'], function (baja, UndoManager, Widget, $, log, Promise, _, asyncUtils, views, ExportCommand, SelectionModeCommand, RedoCommand, UndoCommand) {
  'use strict';

  var doRequire = asyncUtils.doRequire;
  var findWhere = _.findWhere,
    first = _.first,
    isFunction = _.isFunction,
    once = _.once;
  var logSevere = log.severe.bind(log);

  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/wb/profile/profileUtils
   */
  var exports = {};
  var getUndoCommands = once(function () {
    return UndoManager.$installGlobal().then(function (mgr) {
      return [new UndoCommand(mgr), new RedoCommand(mgr)];
    });
  });
  var resolveBrandTitle = once(function () {
    return baja.rpc({
      typeSpec: "workbench:WorkbenchRpc",
      method: "getBrandTitle"
    });
  });

  /**
   * @returns {baja.Ord} the ORD currently being viewed in the profile. This ORD
   * will correspond to the current ORD in Workbench, even if used in the
   * browser (i.e. it may contain `fox:` or similar schemes). Call
   * `.relativizeToSession()` if needed.
   */
  exports.getCurrentOrd = function () {
    return exports.uriToOrd(location.href);
  };

  /**
   * If there is a view query, get the ord without it.
   * @param {baja.Ord} [ord] if the ord is not present, the `getCurrentOrd()` will be used.
   * @returns {baja.Ord} the ORD without the View Query
   */
  exports.getOrdWithoutViewQuery = function (ord) {
    var ordStr = getOrdStrFromParam(ord);
    var viewIndex = getViewIndex(ordStr);
    if (viewIndex > -1) {
      return baja.Ord.make(ordStr.substring(0, viewIndex - 1));
    }
    return baja.Ord.make(ordStr);
  };

  /**
   * @param {string|undefined} uri
   * @param {object} [params]
   * @param {string} [params.host] specify the desired host in the generated
   * ORD. If omitted, will be parsed out of the URI, or omitted if the URI is
   * relative.
   * @param {number} [params.port] specify the desired port in the generated
   * ORD.
   * @param {string} [params.protocol] specify the desired protocol in the
   * generated ORD. If omitted, will be `fox` for an `http` URI, `foxs` for an
   * `https` URI, or omitted if the URI is relative.
   * @returns {baja.Ord} an ORD parsed from the given URI. Will be
   * `baja.Ord.DEFAULT` if the URI did not match the expected format or if the URI is falsy.
   */
  exports.uriToOrd = function (uri) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (!uri) {
      return baja.Ord.DEFAULT;
    }
    var match = uri.match(/^(https?)?(:\/\/)?([^:/]+)?(:(\d+))?(\/ord[/?])(.*)$/);
    if (!match) {
      return baja.Ord.DEFAULT;
    }
    var _match = _slicedToArray(match, 8),
      protocol = _match[1],
      host = _match[3],
      port = _match[5],
      ord = _match[7];
    var path = decodeURIComponent(ord);
    host = params.host || host;
    port = params.port || port;
    if (host) {
      var targetProtocol = params.protocol || (protocol === 'https' ? 'foxs' : 'fox');
      if (port) {
        host = host + ':' + port;
      }
      return baja.Ord.make("ip:".concat(host, "|").concat(targetProtocol, ":|").concat(path));
    } else {
      return baja.Ord.make(path);
    }
  };

  /**
   *
   * @param {module:bajaux/Widget} widget
   * @returns {Promise.<Array.<module:bajaux/commands/Command>>}
   */
  exports.resolveProfileCommands = function (widget) {
    return Promise.all([resolveMediaCommands(widget), getUndoCommands()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        mediaCommands = _ref2[0],
        undoCommands = _ref2[1];
      return [].concat(_toConsumableArray(mediaCommands), _toConsumableArray(undoCommands), [new SelectionModeCommand(), new ExportCommand(widget)]);
    });
  };

  /**
   * Resolve to the current View item if it is available. This function will return undefined if there is no `profileInfo`.
   * @return {Promise.<module:profileInfo~ViewInfo|undefined>}
   */
  exports.resolveCurrentViewItem = function () {
    return exports.$resolveViewInfo().then(function (viewInfo) {
      if (viewInfo) {
        var list = viewInfo.list;
        return findWhere(list, {
          def: true
        }) || first(list);
      }
    });
  };

  /**
   * Resolve to the current View List for the currentOrd.
   * @return {Promise.<BajaViewInfo[]>}
   */
  exports.resolveCurrentViewList = function () {
    return exports.$resolveViewInfo().then(function (viewInfo) {
      if (viewInfo) {
        return viewInfo.list;
      }
      return views.listViews(exports.getCurrentOrd().relativizeToSession());
    });
  };

  /**
   * This returns a viewList for the ord without the `def=true` information attribute on each `BajaViewInfo`.
   * This is because this method is optimized to return the `currentViewList` if the ord matches `currentOrd`
   * without comparing the viewIds.
   *
   * @param {baja.Ord} ord
   * @return {Promise.<String[]>}
   * @throws if the user does not have access to the ord
   */
  exports.resolveAvailableViewIds = function (ord) {
    return exports.$resolveViewListForViewIds(ord).then(function (list) {
      return _.map(list, function (viewInfo) {
        return exports.getViewQuery(viewInfo.ord).getViewId();
      });
    });
  };

  /**
   *
   * This method utilizes the available `BajaViewInfo` to determine whether the ViewId in the Ord will hyperlink them
   * directly to the desired ViewId. Note that any Ord for a ViewId that not in the ViewList will return false even though
   * the ord.
   * If there is no ViewId in the ord, this will resolve to true if the ord is accessible and there is at least one view.
   * Resolves to false if the ord is inaccessible.
   * @param {baja.Ord} ord
   * @returns {Promise<boolean>}
   */
  exports.isDirectViewIdAvailable = function (ord) {
    var viewQuery = exports.getViewQuery(ord);
    var viewId = viewQuery && viewQuery.getViewId();
    return exports.$resolveViewListForViewIds(ord).then(function (list) {
      if (!viewId) {
        return list.length > 0;
      }
      return _.filter(list, function (viewInfo) {
        return exports.getViewQuery(viewInfo.ord).getViewId() === viewId;
      }).length > 0;
    })["catch"](function () {
      return false;
    });
  };

  /**
   *
   * @private
   * @param {baja.Ord} ord
   * @returns {Promise<BajaViewInfo[]>}
   */
  exports.$resolveViewListForViewIds = function (ord) {
    var ordWithViewQuery = exports.getOrdWithoutViewQuery(ord).relativizeToSession();
    var currentOrd = exports.getCurrentOrd();
    var currentOrdWithoutViewQuery = exports.getOrdWithoutViewQuery(currentOrd).relativizeToSession();
    if (currentOrdWithoutViewQuery.equivalent(ordWithViewQuery)) {
      return exports.resolveCurrentViewList();
    } else {
      return views.listViews(ord);
    }
  };

  /**
   * Return the current ViewId. This information is available from `hx`
   * even if the 'profileInfo' is not defined.
   * @return {Promise.<String|undefined>}
   */
  exports.resolveCurrentViewId = function () {
    return exports.resolveCurrentViewItem().then(function (viewItem) {
      if (viewItem) {
        var viewQuery = exports.getViewQuery(baja.Ord.make(viewItem.ord));
        if (viewQuery) {
          return viewQuery.getViewId();
        }
      }
      var hx = window.hx;
      if (hx && isFunction(hx.getProfileInfo)) {
        var profileInfo = hx.getProfileInfo();
        return profileInfo && profileInfo.viewId;
      }
    });
  };

  /**
   * Resolve the Brand Title. This should not so the answer is cached.
   *
   * @return {Promise.<String>}
   */
  exports.resolveBrandTitle = function () {
    return resolveBrandTitle();
  };

  /**
   * Get the ViewQuery for an ord.
   * @param {baja.Ord} [ord] if the ord is not present, the `getCurrentOrd()` will be used.
   * @return {baja.ViewQuery|undefined}
   */
  exports.getViewQuery = function (ord) {
    var ordStr = getOrdStrFromParam(ord),
      viewIndex = getViewIndex(ordStr);
    if (viewIndex > -1) {
      var viewQueryBody = ordStr.substring(viewIndex + 5);
      return new baja.ViewQuery(viewQueryBody);
    }
  };

  /**
   * If the given URI is not compatible with the current state of the web
   * profile, then it must be loaded with a full page refresh so that the
   * profile chrome can be updated. This typically happens when the fullScreen
   * query parameter is changing.
   *
   * @param {string} uri
   * @returns {boolean} true if the given URI must be loaded with a full page
   * refresh.
   */
  exports.requiresRefresh = function (uri) {
    var currentOrd = exports.getCurrentOrd();
    var newOrd = exports.uriToOrd(uri);
    return hasFullScreen(currentOrd) !== hasFullScreen(newOrd);
  };
  function hasFullScreen(ord) {
    var viewQuery = exports.getViewQuery(ord);
    if (!viewQuery) {
      return false;
    }
    return String(viewQuery.getParameters().fullScreen).toLowerCase() === 'true';
  }

  /**
   * Get a View Parameter from the current `window.location.href`
   * @param {String} name
   * @return {String|undefined}
   */
  exports.getViewParameter = function (name) {
    var viewQuery = exports.getViewQuery();
    if (viewQuery) {
      var params = viewQuery.getParameters();
      return params[name];
    }
  };

  /**
   * Get the custom message provided by jetty from JQuery error handler
   * @param {JQuery.jqXHR} jqXHR
   * @param {String} textStatus
   * @param {Error} errorThrown
   * @return {Error}
   */
  exports.getServletError = function (jqXHR, textStatus, errorThrown) {
    var responseText = jqXHR.responseText;
    //jetty provides HTML to get to local error message so we must generate an HTML page and parse it from there.
    var message = $(responseText).find('tr:nth-child(3) td').text();
    if (!message && errorThrown) {
      message = String(errorThrown);
    }
    if (!message) {
      message = textStatus;
    }
    return new Error(message);
  };

  /**
   * Get the browser's `window.location.href`.
   * @private
   * @return {String}
   */
  exports.$getLocation = function () {
    return window.location.href;
  };

  /**
   * If `profileInfo` is not defined, this will resolve to an `undefined` value,
   * This will happen for profile's other than the Html5HxProfile and it will
   * happen within the Html5HxProfile when the page was loaded as a popup.
   * @return {Promise}
   * @private
   */
  exports.$requireProfileInfo = function () {
    if (require.specified('profileInfo')) {
      return doRequire('profileInfo');
    }
    return Promise.resolve();
  };

  /**
   * @return {Promise}
   * @private
   */
  exports.$resolveViewInfo = function () {
    return exports.$requireProfileInfo().then(function (profileInfo) {
      if (profileInfo) {
        return profileInfo.getViewInfo();
      }
    });
  };

  /**
   * @param {module:bajaux/Widget} widget
   * @return {Promise}
   */
  function resolveMediaCommands(widget) {
    return Promise.all([exports.resolveCurrentViewItem(), exports.$requireProfileInfo()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        item = _ref4[0],
        profileInfo = _ref4[1];
      if (profileInfo && profileInfo.isMediaCommandAvailable() && (item.px || item.moduleName === 'hx' && item.typeName === 'HxPxView')) {
        return doRequire('nmodule/webEditors/rc/wb/profile/media/MediaSettingsWidget').then(function (MediaSettingsWidget) {
          return MediaSettingsWidget.makeCommands(widget.getOrd());
        });
      }
      return [];
    });
  }

  /**
   *
   * @param {baja.Ord} [ord] if the ord is not present, the `getCurrentOrd()` will be used.
   * @return {String}
   */
  function getOrdStrFromParam(ord) {
    if (!ord) {
      ord = exports.getCurrentOrd();
    }
    ord = ord.normalize(); //ensure there is only one view query

    return String(ord);
  }

  /**
   * @param {String} ordStr
   * @return {Number}
   */
  function getViewIndex(ordStr) {
    return ordStr.indexOf('view:');
  }

  /**
   * Get the main Title Pane's command group which can contain not visible
   * commands that are available for profile level accelerators.
   * @returns {module:bajaux/commands/CommandGroup|null}
   * @since Niagara 4.15
   */
  exports.getTitlePaneCommandGroup = function () {
    var mainTitlePane = Widget["in"]($('.WebShell-content-container .TitlePane').first());
    if (mainTitlePane) {
      return mainTitlePane.getCommandGroup();
    }
    return null;
  };

  /**
   * Get the main Title Pane's visible command group which contains the profile commands
   * that users can see at the top of the profile.
   * @returns {module:bajaux/commands/CommandGroup|null}
   * @since Niagara 4.15
   */
  exports.getMainCommandGroup = function () {
    var mainTitlePane = Widget["in"]($('.WebShell-content-container .TitlePane').first());
    if (mainTitlePane && mainTitlePane.$getCommandsElement().length > 0) {
      return Widget["in"](mainTitlePane.$getCommandsElement()).value();
    }
    return null;
  };

  /**
   * Register a keydown handler to look for a key events that bubble all the way up to the body.
   * In this keydown handler, fire any commands which match the accelerator that is used.
   * When a command is found, return false to prevent that key from also firing off the browser
   * level accelerators.
   * @since Niagara 4.15
   */
  exports.registerForProfileAccelerators = function () {
    var body = $('body');
    body.on('keydown', function (event) {
      if (event.target !== body[0] && !allowAcceleratorOnInput(event)) {
        return;
      }
      var found = exports.invokeProfileCommandMatchingAccelerator(event.originalEvent);
      if (found) {
        //if an accelerator is found, return false so that we don't overlap with Browser accelerators
        //(like with Ctrl+D, bookmark/ and Niagara Duplicate)
        return false;
      }
    });
  };

  /**
   * Invoke a profile level command if the accelerator matches the event.
   * @param {Event} event
   * @returns {boolean} returns true if a command is found.
   * @since Niagara 4.15
   */
  exports.invokeProfileCommandMatchingAccelerator = function (event) {
    var commands = [];
    var mainCommandGroup = exports.getMainCommandGroup();
    if (mainCommandGroup) {
      commands.push.apply(commands, _toConsumableArray(mainCommandGroup.flatten({
        recurse: true
      })));
    }
    var titleCommandGroup = exports.getTitlePaneCommandGroup();
    if (titleCommandGroup) {
      commands.push.apply(commands, _toConsumableArray(titleCommandGroup.flatten({
        recurse: true
      })));
    }
    var _loop = function _loop() {
        var cmd = commands[j];
        if (cmd.isAcceleratorMatch(event)) {
          cmd.invoke()["catch"](function (err) {
            logSevere(err);
            return cmd.defaultNotifyUser(err);
          });
          return {
            v: true
          };
        }
      },
      _ret;
    for (var j = 0; j < commands.length; j++) {
      _ret = _loop();
      if (_ret) return _ret.v;
    }
    return false;
  };

  /**
   * There are certain default accelerators which are allowed on inputs to help with things like closing dialogs and
   * saving even while the cursor is within a html input.
   * @returns {boolean}
   */
  function allowAcceleratorOnInput(event) {
    var keyCode = event.keyCode,
      ctrlKey = event.ctrlKey;
    return keyCode === 27 ||
    //Escape for dialog closure
    keyCode === 83 && ctrlKey; //Saving
  }
  return exports;
});
