/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson.
 */

/*eslint-env browser */ /*jshint browser: true */

/**
 * API Status: **Private**
 *
 * Used to manage a Servlet View when it's run full screen in the Shell Profile. This JavaScript
 * will only work when run in an iframe. It's designed purely for the rendering
 * of a Servlet View in an iframe.
 *
 * The script attempts to capture all hyperlinks and redirect them to the top window.
 *
 * @module nmodule/webEditors/rc/wb/profile/fullScreen
 */
define(["baja!", "jquery"], function (baja, $) {
  "use strict";

  function doHyperlink(href, assign) {
    var win = baja.topWindow();
    if (win.niagara && win.niagara.env && win.niagara.env.hyperlink) {
      win.niagara.env.hyperlink(href, assign);
    } else {
      window.location.assign(href);
    }
  }
  function findAnchor(target) {
    if (!target) {
      return null;
    }
    return target.localName === "a" ? target : findAnchor(target.parentElement);
  }
  $(function domReady() {
    $(document.body).click(function (ev) {
      if (ev.originalEvent && ev.originalEvent.defaultPrevented) {
        return;
      }
      var href,
        win,
        a = findAnchor(ev.target);
      if (a) {
        href = $(a).attr("href");
        if (href && !/^javascript:/.test(href)) {
          ev.preventDefault();
          if (ev.ctrlKey || ev.which === 2) {
            win = baja.topWindow().open(href, '_blank');
            win.focus();
          } else {
            doHyperlink(href);
          }
        }
      }
    });
  });

  // Hx is optional.
  if (require.specified("hx")) {
    require(["hx"], function (hx) {
      hx.hyperlink = doHyperlink;
    });
  }
});
