function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Christopher Zelaya.
 */

/**
 * API Status: **Private**
 *
 * Loads the SyncTreeCommand
 *
 * @module nmodule/webEditors/rc/wb/profile/SyncTreeCommand
 */
define(["baja!", 'bajaux/commands/Command', "Promise", "nmodule/webEditors/rc/wb/profile/profileUtils", "nmodule/webEditors/rc/wb/tree/stationTree", "nmodule/js/rc/asyncUtils/asyncUtils", "nmodule/webEditors/rc/fe/baja/util/spaceUtils"], function (baja, Command, Promise, profileUtils, stationTree, asyncUtils, spaceUtils) {
  "use strict";

  var doRequire = asyncUtils.doRequire,
    resolveService = spaceUtils.resolveService;

  /**
   * Implementation of SyncTreeCommand
   * @since Niagara 4.14
   * @class
   * @extends {module:bajaux/commands/Command}
   */
  var SyncTreeCommand = /*#__PURE__*/function (_Command) {
    function SyncTreeCommand(navTree) {
      _classCallCheck(this, SyncTreeCommand);
      return _callSuper(this, SyncTreeCommand, [{
        module: 'bajaui',
        lex: 'tree.sync',
        func: function func() {
          return SyncTreeCommand.syncNavTree(profileUtils.getCurrentOrd(), navTree);
        }
      }]);
    }

    /**
     * Function that syncs the nav tree
     *
     * @param {String} ord
     * @param {module:nmodule/webEditors/rc/wb/tree/NavTree} navTree
     * @param [selectPathParams] Object literal for the parameters to pass to the `setSelectedPath` function on
     * the navTree.
     * @return {Promise}
     */
    _inherits(SyncTreeCommand, _Command);
    return _createClass(SyncTreeCommand, null, [{
      key: "syncNavTree",
      value: function syncNavTree(ord, navTree) {
        var selectPathParams = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        return doRequire("profileInfo").then(function (profileInfo) {
          return SyncTreeCommand.parsePath(ord, profileInfo.getStationName());
        }).then(function (path) {
          return navTree.setSelectedPath(path, selectPathParams);
        });
      }

      /**
       * Parse the current ORD into a path that can be loaded into a Nav Tree.
       *
       * @static
       *
       * @returns {Promise.<Array.<string>>|Array.<string>} an array of strings that
       * map to a path to load into the Nav Tree, or a promise that resolves to
       * same
       * @throws {Error} if the ORD could not be parsed
       */
    }, {
      key: "parsePath",
      value: function parsePath(ord, stationName) {
        ord = baja.Ord.make(ord).relativizeToSession();
        var navFileNode = baja.nav.navfile.lookup('local:|' + ord),
          query = ord.parse(),
          slotPath = query.get("slot"),
          historyPath = query.get("history"),
          hierarchyPath = query.get("hierarchy"),
          servicePath = query.get("service"),
          filePath = query.get("file"),
          handlePath = query.get("h"),
          virtualPath = query.get("virtual"),
          nspacePath = query.get("nspace"),
          body = "";
        if (navFileNode) {
          return ['local'].concat(parseNavFilePath(navFileNode));
        }
        if (servicePath || handlePath) {
          return ord.get().then(function (obj) {
            body = "local/station" + obj.toPathString();
            return body.split('/');
          });
        } else if (filePath) {
          body = "local/file/" + filePath.getBody().replace(/^\^/, '');
          if (slotPath) {
            body += slotPath.getBody();
          }
        } else if (slotPath) {
          body = "local/station" + slotPath.getBody();
          if (virtualPath) {
            body = body + virtualPath.getBody();
          } else if (nspacePath && nspacePath.getBody() && nspacePath.getBody() !== stationName) {
            return getRemoteStationVirtualPath(nspacePath.getBody()).then(function (virtualPath) {
              body = "local/station" + virtualPath + slotPath.getBody();
              return body.split('/');
            });
          }
        } else if (historyPath) {
          body = historyPath.getBody();
          body = body.replace("^", "/" + stationName + "/");
          body = "local/history" + body;
        } else if (hierarchyPath) {
          body = hierarchyPath.getBody();

          // Inject a prefix to ensure that hierarchies have a unique name. This will
          // help stop issues when the hierarchy has the same name as one of the
          // other sibling tree nodes.
          if (body && body.charAt(0) === '/') {
            body = '/' + stationTree.HIERARCHY_NODE_PREFIX + body.substring(1, body.length);
          }
          body = "local" + body;

          // Need to escape each name individually instead of the entire hierarchy path at once.  The
          // hierarchy path needs to be split on the forward slashes that exist before escaping because
          // individual names may have forward slashes after escaping that need to stay together.  For
          // example, /myHierarchy/grouping1/grouping2/nspace:remoteStation|slot:/A/B/C should be
          // transformed into [local, hierarchy-node-myHierarchy, grouping1, grouping2,
          // nspace:remoteStation|slot:/A/B/C] and not [local, hierarchy-node-myHierarchy, grouping1,
          // grouping2, nspace:remoteStation|slot:, A, B, C]
          return body.split('/').map(baja.SlotPath.unescape);
        } else if (nspacePath) {
          body = "local/station";
          if (nspacePath.getBody() && nspacePath.getBody() !== stationName) {
            return getRemoteStationVirtualPath(nspacePath.getBody()).then(function (virtualPath) {
              body += virtualPath;
              if (slotPath) {
                body += slotPath.getBody();
              }
              return body.split('/');
            });
          }
        } else {
          throw new Error('unrecognized ORD ' + ord);
        }
        return body.split('/');
      }
    }]);
  }(Command);
  /**
   * Get the path of nav names down through the nav file for this node, starting
   * with the root.
   *
   * @inner
   *
   * @param {baja.NavContainer} node
   * @returns {Array.<String>}
   */
  function parseNavFilePath(node) {
    return node ? parseNavFilePath(node.getNavParent()).concat([node.getNavName()]) : [];
  }

  /**
   *
   * @private
   * @param {String} stationName the remote station name
   * @returns {Promise} Resolves to path that helps resolve to the virtual component space
   */
  function getRemoteStationVirtualPath(stationName) {
    return resolveService("niagaraDriver:NiagaraNetwork").then(function (nNetwork) {
      return nNetwork.getSlotPath().getBody() + "/" + stationName + "/virtual";
    });
  }
  return SyncTreeCommand;
});
