function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*eslint-env browser */ /*jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/textEditorMixIn
 */
define(['baja!', 'lex!webEditors', 'log!nmodule.webEditors.rc.wb.mixin.textEditorMixIn', 'ace/ace', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/mixin/mixinUtils', 'bajaux/util/CommandButtonGroup', 'bajaux/util/SaveCommand', 'dialogs', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, lexs, log, ace, Widget, Command, mixinUtils, CommandButtonGroup, SaveCommand, dialogs, $, Promise, feDialogs) {
  "use strict";

  var applyMixin = mixinUtils.applyMixin;
  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var logSevere = log.severe.bind(log);
  var MIXIN_NAME = 'textEditor';
  var lastLoadedOrd = baja.Ord.DEFAULT;
  var contentTemplate = function contentTemplate() {
    return "\n    <div style=\"display: flex; flex-flow: column nowrap;\"'>\n      <div class='bajaux-toolbar' style=\"flex: 0 0 auto;\"'></div>\n      <div class='bajaux-widget' style=\"flex: 1 1 100%;\"'></div>\n    </div>";
  };

  ////////////////////////////////////////////////////////////////
  // Text Editor Mix-In
  ////////////////////////////////////////////////////////////////

  /**
   * A Mix-In for a Widget that shows a text editor.
   * @alias module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
   */
  var exports = function exports(target) {
    if (!applyMixin(target, MIXIN_NAME)) {
      return;
    }
    var superInitialize = target.initialize,
      superDestroy = target.destroy,
      superLayout = target.layout;

    /**
     * Injects the editor into the Widget.
     *
     * @param dom The DOM element to initialize into.
     *
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     * @returns {Promise}
     */
    target.initialize = function (dom) {
      var that = this;
      return superInitialize.apply(that, arguments).then(function () {
        var ed = that.$editorDom = $("<div></div>");
        dom.append(ed);
        that.$editor = ace.edit(ed.get(0));
      });
    };

    /**
     * Destroys the Widget.
     *
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     * @returns {Promise}
     */
    target.destroy = function () {
      var that = this;
      return superDestroy.apply(that, arguments).then(function () {
        if (that.$editor) {
          that.$editor.destroy();
          that.$editor = null;
        }
        that.$editorDom = null;
      });
    };

    /**
     * Layout the Widget.
     *
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     * @returns {Promise}
     */
    target.layout = function () {
      var that = this,
        jq = that.jq();
      return superLayout.apply(that, arguments).then(function () {
        var parent = jq.parent();
        jq.css({
          width: parent.width(),
          height: parent.height()
        });
        if (that.$editorDom) {
          that.$editorDom.css({
            width: parent.width(),
            height: parent.height()
          });
        }
        if (that.$editor && that.$editor.env && typeof that.$editor.env.onResize === "function") {
          that.$editor.env.onResize();
        }
      });
    };

    // noinspection JSUnusedLocalSymbols
    /**
     * Evaluates the text as JS. Override to perform any special processing/transpilation before
     * evaluation.
     *
     * @private
     * @function module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn#$eval
     * @param {string} text the JavaScript text to evaluate
     * @param {function} define a mocked-up define function for the JS to use when defining an AMD
     * module. If overriding, this parameter *must* appear in the function's parameter list and it
     * *must* be named `define`!
     * @returns {Promise}
     */
    target.$eval = target.$eval || function (text, define) {
      // noinspection DynamicallyGeneratedCodeJS
      return Promise["try"](function () {
        return eval(text);
      }); // eslint-disable-line no-eval
    };

    /**
     * Adds a run command to the widget.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     */
    target.$addRunCmd = function () {
      var that = this,
        cmd;
      cmd = new Command({
        module: "webEditors",
        lex: "commands.runJs",
        func: function func() {
          var id = "dummyDefineFromTextEditor";
          function undef() {
            // Once the widget has run, deregister it from RequireJS.
            require.undef(id);
          }
          undef();
          var dummyDefineCalled;

          // If it's a define then capture it with a dummy id. If it defines a widget the
          // attempt to launch it in a dialog.
          var mockDefine = function mockDefine() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }
            dummyDefineCalled = true;
            if (typeof args[0] !== 'string') {
              // no id
              args = [id].concat(_toConsumableArray(args));
            }
            return define.apply(void 0, _toConsumableArray(args));
          };
          mockDefine.amd = true;
          return that.$eval(that.$editor.session.getValue(), mockDefine).then(function () {
            if (!dummyDefineCalled) {
              return;
            }
            // Ask the user if they want to load a value into the widget. If so then select
            // the value.
            return dialogs.showYesNo({
              title: webEditorsLex.get("commands.runJs.displayName"),
              text: webEditorsLex.get("commands.runJs.loadValueQuestion")
            }).promise().then(function (_ref) {
              var _ref2 = _slicedToArray(_ref, 2),
                clickId = _ref2[1];
              if (clickId === "yes") {
                return feDialogs.showFor({
                  value: lastLoadedOrd,
                  title: webEditorsLex.get("commands.runJs.selectValue"),
                  formFactor: Widget.formfactor.compact
                }).then(function (ord) {
                  if (ord) {
                    lastLoadedOrd = ord;
                  }
                  return ord;
                });
              }
            }).then(function (ord) {
              return ord && ord.toString() ? ord.get() : null;
            }).then(function (val) {
              // Now attempt to initialize the Widget. If the user has selected
              // a value then load it.
              require([id], function (NewWidget) {
                var widget = makeWidget(NewWidget);
                if (!widget) {
                  return undef();
                }
                var commandButtonGroup = new CommandButtonGroup({
                  properties: {
                    toolbar: true
                  }
                });
                $(window).one("jsdialog:show", function () {
                  if (widget) {
                    widget.layout()["catch"](logSevere);
                  }
                });
                var dlg = dialogs.showOk({
                  content: function content(dlg, jq) {
                    jq.css({
                      height: 600,
                      overflowY: 'auto'
                    });

                    // Hack the dialog so it fills the screen. This was added to help with the
                    // responsive layout mixin example in js playground.
                    dlg.jq().children('.js-dialog').css({
                      width: "100%"
                    });
                    jq.html(contentTemplate());
                    var widgetDom = jq.find(".bajaux-widget");
                    var toolbarDom = jq.find(".bajaux-toolbar");
                    return widget.initialize(widgetDom).then(function () {
                      // If the user has selected a value to load then load it.
                      if (val !== undefined && val !== null) {
                        return widget.load(val).then(function () {
                          return widget.layout();
                        });
                      }
                    }).then(function () {
                      return commandButtonGroup.initialize(toolbarDom).then(function () {
                        return commandButtonGroup.load(widget.getCommandGroup());
                      });
                    })["catch"](function (err) {
                      feDialogs.error(err);
                    });
                  },
                  layout: function layout() {
                    widget.layout();
                  }
                });
                dlg.on('ok', function () {
                  return Promise.all([widget.destroy(), commandButtonGroup.destroy()]);
                });
                return dlg.promise()["catch"](function (err) {
                  feDialogs.error(err);
                  undef();
                });
              }, undef);
            });
          })["catch"](function (err) {
            feDialogs.error(err);
            undef();
          });
        }
      });
      cmd.$runCmd = true;
      that.getCommandGroup().add(cmd);
    };

    /**
     * Adds a save command to the Widget.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     */
    target.$addSaveCmd = function () {
      var that = this,
        foundSaveCmd;

      // Detect to see if a save command has already been added (i.e. from Dashboards).
      that.getCommandGroup().visit(function (cmd) {
        if (cmd.$saveCmd) {
          foundSaveCmd = true;
        }
      });
      if (!foundSaveCmd) {
        that.getCommandGroup().add(new SaveCommand());
      }
    };

    /**
     * Initializes the editor. This should be called just before the editor is loaded.
     *
     * @param {String} mode The editor's mode. This can be 'javascript', 'css', 'html',
     * 'xml', 'java', 'json', 'less', 'handlebars' or 'velocity'.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     */
    target.$initEditor = function (mode) {
      var that = this,
        editor = that.$editor;
      mode = that.$mode = "ace/mode/" + (mode || "text");
      editor.setTheme("ace/theme/chrome");
      editor.getSession().setMode(mode);
      editor.getSession().setTabSize(2);
      that.getCommandGroup().add(new Command({
        module: "webEditors",
        lex: "commands.find",
        func: function func() {
          editor.execCommand("find");
        }
      }));
      that.$replaceCmd = new Command({
        module: "webEditors",
        lex: "commands.replace",
        func: function func() {
          editor.execCommand("replace");
        }
      });
    };

    /**
     * Sets the editor as readonly or not.
     *
     * @param {Boolean} readonly If true, the editor is set to readonly.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     */
    target.$setEditorReadOnly = function (readonly) {
      var that = this,
        cg = that.getCommandGroup(),
        foundReplaceCmd = !!cg.findCommand(that.$replaceCmd.getId());
      that.$editor.setReadOnly(readonly);
      if (readonly && foundReplaceCmd) {
        cg.remove(that.$replaceCmd);
      } else if (!readonly && !foundReplaceCmd) {
        cg.add(that.$replaceCmd);
      }
    };

    /**
     * Register a function to be invoked when the editor's text is changed
     * by a user.
     *
     * @param  {Function} func The function to be called when the editor is changed.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     */
    target.$onEditorChange = function (func) {
      this.$editor.session.on("change", func);
    };

    /**
     * Return the text currently being displayed by the editor.
     *
     * @returns {String} The text the editor is current displaying.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     */
    target.$getEditorText = function () {
      return this.$editor.session.getValue();
    };

    /**
     * Set the text to be displayed in the editor.
     *
     * @param {String} text The text to be displayed in the editor.
     *
     * @private
     * @memberOf module:nmodule/webEditors/rc/wb/mixin/textEditorMixIn
     */
    target.$setEditorText = function (text) {
      this.$editor.session.setValue(text);
    };
  };

  /**
   * @param {function} Ctor widget constructor
   * @returns {module:bajaux/Widget|undefined} widget instance or undefined if one cannot be constructed
   */
  function makeWidget(Ctor) {
    if (typeof Ctor !== 'function') {
      return;
    }
    var widget = new Ctor();
    if (!(widget instanceof Widget)) {
      return;
    }
    return widget;
  }
  return exports;
});
