/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author E542627
 */

/*eslint-env browser */ /*jshint browser: true */

define(['bajaux/mixin/mixinUtils', 'jquery', 'Promise', 'underscore'], function (mixinUtils, $, Promise, _) {
  'use strict';

  var isSmoothScrollSupported = 'scrollBehavior' in document.documentElement.style,
    applyMixin = mixinUtils.applyMixin,
    MIXIN_NAME = 'stalkerSupport';
  function scroll(elem, options) {
    if (isSmoothScrollSupported) {
      elem.scrollBy(options);
    } else {
      elem.scrollTop += options.top;
    }
  }

  /**
   * API Status: **Private**
   *
   * When applied to a `PropertySheet`, adds a stalker showing the parent slot
   * of the row you are currently scrolled to.
   *
   * @exports nmodule/webEditors/rc/wb/mixin/PropertySheetStalkerSupport
   * @mixin
   */
  var exports = {
    $getTableStalker: function $getTableStalker() {
      return this.jq().children('.PropertySheet-table-stalker-container').children('.PropertySheet-table-stalker');
    },
    $getCurrentParentRow: function $getCurrentParentRow() {
      var tableContainer = this.$getTableContainer();
      var scrollTop = tableContainer.scrollTop() + this.$getTableStalker().outerHeight();
      var topRow = _.find(tableContainer.find('.PropertySheetRow'), function (el) {
        return $(el).is(':visible') && offsetTopRelativeTo(el, tableContainer[0]) + el.offsetHeight >= scrollTop;
      });
      if (topRow && tableContainer.scrollTop()) {
        var expansion = $(topRow).closest('.PropertySheetRow-inline-expansion');
        if (expansion.is(':visible')) {
          return expansion.prev();
        }
      }
      return $();
    },
    $getOffsetTop: function $getOffsetTop(el) {
      return offsetTopRelativeTo(el, this.$getTableContainer()[0]);
    },
    $updateStalker: function $updateStalker() {
      if (this.isDestroyed()) {
        return;
      }
      var parentRow = this.$getCurrentParentRow(),
        stalker = this.$getTableStalker().empty();
      while (parentRow.length) {
        var crumb = $('<span/>').text(parentRow.attr('title')).attr('data-y', this.$getOffsetTop(parentRow[0]));
        stalker.append(crumb);
        parentRow = parentRow.closest('.PropertySheetRow-inline-expansion').prev();
      }
      stalker.toggle(!!stalker.children().length);
    }
  };
  var addStalkerSupport = function addStalkerSupport(target) {
    if (!applyMixin(target, MIXIN_NAME, exports)) {
      return;
    }
    var doDestroy = target.doDestroy,
      doInitialize = target.doInitialize,
      doLayout = target.doLayout;
    target.doInitialize = function (dom) {
      var _this = this;
      var that = this,
        containerScrollHandler = that.$containerScrollHandler = _.throttle(function () {
          that.$updateStalker();
        }, 150, {
          leading: false
        });
      dom.on('click', '.PropertySheet-table-stalker span', function (e) {
        var tableContainer = _this.$getTableContainer()[0];
        var y = $(e.target).data('y');
        scroll(tableContainer, {
          top: y - that.$getTableStalker().outerHeight() - tableContainer.scrollTop,
          behavior: 'smooth'
        });
      });
      return Promise.resolve(doInitialize.apply(that, arguments)).then(function () {
        that.$getTableContainer().on('scroll', containerScrollHandler);
      });
    };
    target.doLayout = function () {
      var that = this;
      return doLayout.apply(that, arguments).then(function () {
        that.$updateStalker();
      });
    };
    target.doDestroy = function () {
      this.$getTableContainer().off('scroll', this.$containerScrollHandler);
      return doDestroy.apply(this, arguments);
    };
  };
  function offsetTopRelativeTo(el, offsetParent) {
    var top = 0;
    while (el && el !== offsetParent) {
      top += el.offsetTop;
      el = el.offsetParent;
    }
    return top;
  }
  return addStalkerSupport;
});
