function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*eslint-env browser */ /*jshint browser: true */

define(['baja!', 'log!nmodule.webEditors.rc.wb.mixin.PropertySheetDragSupport', 'bajaux/dragdrop/dragDropUtils', 'bajaux/mixin/mixinUtils', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/PropertySheetRow', 'css!nmodule/webEditors/rc/wb/mixin/PropertySheetDragSupport'], function (baja, log, dragDropUtils, mixinUtils, $, Promise, _, feDialogs, PropertySheetRow) {
  'use strict';

  var fromClipboard = dragDropUtils.fromClipboard,
    toClipboard = dragDropUtils.toClipboard,
    applyMixin = mixinUtils.applyMixin,
    logError = log.severe.bind(log),
    TOP_OF_SHEET_SELECTOR = '.PropertySheet-table-container > .ux-table, ' + '.PropertySheet-controls',
    MIXIN_NAME = 'dragSupport';

  /**
   * Check to see if the element is at the top of the sheet (controls div, or
   * table header).
   *
   * @inner
   * @param {JQuery} el
   * @returns {boolean}
   */
  function isTopOfSheet(el) {
    return el.closest(TOP_OF_SHEET_SELECTOR).length > 0;
  }

  /**
   * Mark the row as being above the drop (a dropped node will be inserted
   * immediately after this row's slot).
   *
   * @inner
   * @param row
   */
  function markAboveDrop(row) {
    if (row) {
      return {
        doIt: function doIt() {
          row.jq().addClass('above drop');
        },
        changes: function changes() {
          return !row.jq().hasClass('above');
        }
      };
    }
  }

  /**
   * Mark the row as being below the drop (a dropped node will be inserted
   * immediately before this row's slot).
   *
   * @inner
   * @param row
   */
  function markBelowDrop(row) {
    if (row) {
      return {
        doIt: function doIt() {
          row.jq().addClass('below drop');
        },
        changes: function changes() {
          return !row.jq().hasClass('below');
        }
      };
    }
  }

  /**
   * Get the outermost property sheet DOM.
   *
   * @inner
   * @param {JQuery} dom
   * @returns {JQuery}
   */
  function getRootSheet(dom) {
    var result = dom.parents('.PropertySheet').last();
    return result.length ? result : dom;
  }

  /**
   * Remove all CSS visual drop cues by climbing up to the root property sheet
   * (if we are nested) and wiping all drag/drop associated CSS classes.
   *
   * @inner
   * @param {JQuery} dom
   */
  function clearAllDrops(dom) {
    getRootSheet(dom).find('.PropertySheetRow.drop').removeClass('above').removeClass('below').removeClass('drop');
  }

  /**
   * Check to see if this event is a direct drop onto a `PropertySheetRow` and
   * thus not to be processed by the `PropertySheet` itself. (We're only
   * concerned with in-between-row drops.)
   *
   * @inner
   * @param {JQuery.Event} e
   * @returns {Boolean}
   */
  function isDirectRowDrop(e) {
    return !!$(e.target).closest('.link').length;
  }

  /**
   * Get the first visible row in the property sheet that corresponds to
   * a slot in the given array.
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/wb/PropertySheet} propSheet
   * @param {Array.<baja.Slot>} slots
   * @returns {module:nmodule/webEditors/rc/wb/PropertySheetRow} first visible
   * row, or undefined if not found
   */
  function getFirstVisibleRow(propSheet, slots) {
    for (var i = 0; i < slots.length; i++) {
      var row = propSheet.$getRowForKey(slots[i]);
      if (row instanceof PropertySheetRow) {
        return row;
      }
    }
  }

  /**
   * Return the last visible row for a frozen slot in the property sheet.
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/wb/PropertySheet} propSheet
   * @returns {module:nmodule/webEditors/rc/wb/PropertySheetRow}
   */
  function getLastFrozenRow(propSheet) {
    var frozenSlots = propSheet.value().getSlots().frozen().toArray();
    frozenSlots.reverse();
    return getFirstVisibleRow(propSheet, frozenSlots);
  }

  /**
   * Return the first visible row for a dynamic slot in the property sheet.
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/wb/PropertySheet} propSheet
   * @returns {module:nmodule/webEditors/rc/wb/PropertySheetRow}
   */
  function getFirstDynamicRow(propSheet) {
    var dynamicSlots = propSheet.value().getSlots().dynamic().toArray();
    return getFirstVisibleRow(propSheet, dynamicSlots);
  }

  /**
   * API Status: **Private**
   *
   * When applied to a `PropertySheet`, allows adding slots by dropping them
   * in between the rows in the sheet.
   *
   * @exports nmodule/webEditors/rc/wb/mixin/PropertySheetDragSupport
   * @mixin
   */
  var exports = {
    /**
     * Check to see if the `PropertySheet` can successfully receive drop events
     * (i.e. is it ok to add a new slot?).
     *
     * @private
     * @returns {Boolean}
     */
    $isDroppable: function $isDroppable() {
      return this.$getAddSlotCommand().isEnabled();
    },
    /**
     * When a `dragover` event is received, respond to it by marking the closest
     * rows in the `PropertySheet` with the appropriate CSS classes so that the
     * in-between-row drop marker appears.
     *
     * @private
     * @param {JQuery.Event} e
     */
    $handleDragoverEvent: function $handleDragoverEvent(e) {
      var that = this,
        target = $(e.target);
      if (isDirectRowDrop(e)) {
        clearAllDrops(that.jq());
        return;
      }
      var dropRow = target.closest('.PropertySheetRow').data('widget'),
        kidRows,
        op;
      if (dropRow) {
        if (dropRow.getSlot().isFrozen()) {
          //can't drop in between frozen slots
          op = markAboveDrop(getLastFrozenRow(that));
        } else {
          //firefox has no offsetY for dragover,
          //and workbench has no pageY
          var rowDom = dropRow.jq(),
            offsetY = e.originalEvent.offsetY || e.originalEvent.clientY - (rowDom.offset().top - $(window).scrollTop());
          if (offsetY > rowDom.height() / 2) {
            op = markAboveDrop(dropRow);
          } else {
            op = markBelowDrop(dropRow);
          }
        }
      } else if (isTopOfSheet(target)) {
        //we're dropping above the top row
        dropRow = getFirstDynamicRow(that);
        if (dropRow) {
          op = markBelowDrop(dropRow);
        } else {
          dropRow = getLastFrozenRow(that);
          if (dropRow) {
            op = markAboveDrop(dropRow);
          }
        }
      } else {
        kidRows = that.$getKidRows();
        if (kidRows.length) {
          op = markAboveDrop(kidRows[kidRows.length - 1]);
        }
      }
      if (op && op.changes()) {
        clearAllDrops(that.jq());
        op.doIt();
      }
    },
    /**
     * Get the property sheet row that is currently marked as a drop target.
     *
     * @private
     * @returns {module:nmodule/webEditors/rc/wb/PropertySheetRow}
     * @throws {Error} if no, or more than one, rows are marked as a drop
     * target
     */
    $getDropKid: function $getDropKid() {
      var kidRows = this.$getKidRows(),
        droppableKids = _.filter(kidRows, function (kid) {
          var kidDom = kid.jq();
          return kidDom.is('.above.drop') || kidDom.is('.below.drop');
        });
      if (kidRows.length && droppableKids.length !== 1) {
        throw new Error('exactly one row should have been a drop target');
      }
      return droppableKids[0];
    },
    /**
     * Perform a slot insertion (we're dragging from the palette in between
     * slots on the property sheet).
     *
     * @private
     * @param {Array} navNodes `niagara/navnodes` data set by the dragstart
     * event
     * @param {Array.<String>} names
     * @return {Promise} promise to be resolved after slot is inserted
     */
    $doInsert: function $doInsert(navNodes, names) {
      var that = this,
        dropKid = that.$getDropKid(),
        params = {
          bulkValues: navNodes,
          names: names
        };
      if (dropKid) {
        var kidDom = dropKid.jq(),
          slot = String(dropKid.getSlot());
        if (kidDom.is('.above.drop')) {
          params.after = slot;
        } else if (kidDom.is('.below.drop')) {
          params.before = slot;
        }
      }
      return that.$getAddSlotCommand().invoke(params)["finally"](function () {
        clearAllDrops(that.jq());
      });
    },
    /**
     * Perform a reorder operation (we're dragging slots around while in Slot
     * Details mode).
     *
     * @param {String} reorderSlot the name of the slot that is currently
     * being moved
     * @returns {Promise} promise to be resolved when the reorder is done
     */
    $doReorder: function $doReorder(reorderSlot) {
      var that = this,
        dropKid = that.$getDropKid(),
        cmd = that.$getReorderSlotsCommand(),
        slots;
      if (dropKid) {
        var kidDom = dropKid.jq(),
          slot = String(dropKid.getSlot());
        if (kidDom.is('.above.drop')) {
          slots = cmd.moveAfter(reorderSlot, slot);
        } else if (kidDom.is('.below.drop')) {
          slots = cmd.moveBefore(reorderSlot, slot);
        }
      }
      return Promise.resolve(slots && cmd.invoke({
        dynamicSlots: slots
      }))["finally"](function () {
        clearAllDrops(that.jq());
      });
    },
    /**
     * When initializing the `PropertySheet`, arm event handlers to respond to
     * drag/drop events by showing the visual drop cues, and adding or
     * reordering slots when the drop occurs.
     *
     * @private
     * @param {JQuery} dom
     */
    $initializeDrag: function $initializeDrag(dom) {
      var that = this,
        handleDragoverEvent = baja.throttle(function (e) {
          return that.$handleDragoverEvent(e);
        }, 25),
        dragoverTicket;
      dom.on('dragstart', '.PropertySheetRow', function (e) {
        var row = $(e.target).data('widget');
        if (row) {
          //TODO: doesn't work in WB. NCCB-9399
          toClipboard(e.originalEvent.dataTransfer, 'niagara/strings', [row.getSlot()])["catch"](logError);
        }
      });
      dom.on('dragover', function (e) {
        //dragover fires continuously. if we stop getting the event, we've
        //dragged outside the dom.
        //TODO: or it should: NCCB-9330
        clearTimeout(dragoverTicket);
        dragoverTicket = setTimeout(function () {
          clearAllDrops(dom);
        }, 750); //whatwg 6.7.5 sez 350. in practice, longer.

        if (that.$isDroppable() && !e.originalEvent.propSheetHandled) {
          handleDragoverEvent(e);
          e.preventDefault();
        }

        //we can't just return false because if the event doesn't bubble all
        //the way up, the browser won't support the drag. so we futz it instead.
        e.originalEvent.propSheetHandled = true;
      });
      dom.on('drop', function (e) {
        fromClipboard(e.originalEvent.dataTransfer).then(function (envelope) {
          switch (envelope.getMimeType()) {
            case 'niagara/navnodes':
              return Promise.all([envelope.toJson(), envelope.toValues()]).then(function (_ref) {
                var _ref2 = _slicedToArray(_ref, 2),
                  json = _ref2[0],
                  values = _ref2[1];
                var names = _.map(json, 'name');
                return that.$doInsert(values, names)["catch"](function (ignore) {/* AddSlotCommand will show own dialog */});
              });
            case 'niagara/strings':
              return envelope.toValues().then(function (slots) {
                return that.$doReorder(slots[0]);
              });
          }
        })["catch"](feDialogs.error)["finally"](function () {
          clearAllDrops(dom);
        });
        return false; // don't bubble up to parent sheets
      });
    }
  };
  var addDragSupport = function addDragSupport(target) {
    if (!applyMixin(target, MIXIN_NAME, exports)) {
      return;
    }
    var _doInitialize = target.doInitialize,
      _doDestroy = target.doDestroy,
      _setSlotMode = target.setSlotMode;
    target.doInitialize = function (dom) {
      var that = this;
      return Promise.resolve(_doInitialize.apply(that, arguments)).then(function () {
        dom.addClass('dragSupport');
        that.$initializeDrag(dom);
      });
    };
    target.doDestroy = function () {
      var jq = this.jq();
      return Promise.resolve(_doDestroy.apply(this, arguments)).then(function () {
        jq.removeClass('dragSupport');
      });
    };
    target.setSlotMode = function (slotMode) {
      _setSlotMode.apply(this, arguments);
      _.each(this.$getKidRows(), function (row) {
        var slot = row.getSlot(),
          draggable = slotMode && slot && !slot.isFrozen();
        row.jq().prop('draggable', draggable);
      });
    };
  };
  return addDragSupport;
});
