/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mixin/NavMonitorSupport
 */
define(['bajaux/mixin/mixinUtils'], function (mixinUtils) {
  'use strict';

  var applyMixin = mixinUtils.applyMixin,
    MIXIN_NAME = 'navMonitor';

  /**
   * Identifies a widget as being able to participate in the NavMonitor/touch
   * mechanism. The widget must implement a function `getTouchableOrds()` that
   * returns/resolves an `Array` of ORDs that should be touched station-side to
   * keep them alive.
   *
   * @alias module:nmodule/webEditors/rc/wb/mixin/NavMonitorSupport
   * @param {module:bajaux/Widget} target
   */
  var addNavMonitorSupport = function addNavMonitorSupport(target) {
    if (typeof target.getTouchableOrds !== 'function') {
      throw new Error('getTouchableOrds() not implemented');
    }
    applyMixin(target, MIXIN_NAME);
  };
  return addNavMonitorSupport;
});
