function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/webEditors/rc/wb/mgr/model/columns/MixinPropMgrColumn
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn'], function (baja, Promise, _, switchboard, typeUtils, MgrColumn, PropertyPathMgrColumn) {
  'use strict';

  var getPropValueFromPath = PropertyPathMgrColumn.getPropValueFromPath;
  var isComplex = typeUtils.isComplex;
  var _require = require('bajaScript/baja/comp/compUtil'),
    getComplexAndSlotFromPath = _require.getComplexAndSlotFromPath;

  /**
   * commitToNewInstance uses switchboard to ensure that a MixinPropMgrColumn won't attempt to add the
   * same mixin instance more than once when there is more than one `MixinPropMgrColumn`
   * registered on the same type.
   * @type {Function}
   */
  var ensureMixinInstanceExists = switchboard(function (column, row) {
    return column.$ensureMixinInstanceExists(row);
  }, {
    allow: 'oneAtATime',
    keyedOn: function keyedOn(column) {
      return column.$mixinType;
    }
  });
  function toSlotName(type) {
    return String(type).replace(':', '_');
  }
  function toColumnName(type, path) {
    return toSlotName(type) + '_' + path.join('_');
  }
  function defaultDisplayName(type, slotPath) {
    var _getComplexAndSlotFro = getComplexAndSlotFromPath(baja.$(type), slotPath),
      complex = _getComplexAndSlotFro.complex,
      slot = _getComplexAndSlotFro.slot;
    return complex ? complex.getDisplayName(slot) : slot;
  }

  /**
   * Create a slash delimited path string from the array of path elements.
   */
  function toPathString(path) {
    return '/' + path.join('/');
  }

  /**
   * API Status: **Development**
   *
   * MgrColumn that allows you to edit a property on a `baja:IMixIn` installed
   * on a component.
   *
   * The property may also be several levels deep relative to the row's subject
   * component's mixin.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/mgr/model/columns/MixinPropMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   * @param {string} name column name (if omitted, one will be generated). This
   * was added in Niagara 4.13, but may be omitted (you may still use mixinType
   * as the first parameter).
   * @param {Type} mixinType the `BIMixIn` Type whose property you wish to edit
   * @param {String|baja.Slot} path the property or property path (as a
   * '/'-delimited string) you wish to edit.
   * @param {Object} [params]
   * @param {String} [params.displayName] the display name for the column;
   * if omitted, will use the slot display name from the Type
   * @throws {Error} if Type or prop are missing
   */
  var MixinPropMgrColumn = /*#__PURE__*/function (_PropertyPathMgrColum) {
    function MixinPropMgrColumn(name, mixinType, path, params) {
      var _this;
      _classCallCheck(this, MixinPropMgrColumn);
      if (typeof name !== 'string') {
        var _arguments = Array.prototype.slice.call(arguments);
        mixinType = _arguments[0];
        path = _arguments[1];
        params = _arguments[2];
        path = path.toString().split('/');
        name = toColumnName(mixinType, path);
      } else {
        path = path.toString().split('/');
      }
      if (!mixinType || !_.isFunction(mixinType.is) || !mixinType.is('baja:IMixIn')) {
        throw new Error('mixinType parameter must be a baja:IMixIn');
      }
      _this = _callSuper(this, MixinPropMgrColumn, [name, path.join('/'), _.extend({
        displayName: defaultDisplayName(mixinType, path),
        type: mixinType
      }, params)]);
      _this.$mixinType = mixinType;
      var commit = _this.commit;
      _this.commit = function (value, row) {
        var _arguments2 = arguments,
          _this2 = this;
        return ensureMixinInstanceExists(this, row).then(function () {
          return commit.apply(_this2, _arguments2);
        });
      };
      return _this;
    }

    /**
     * @private
     * @return {String}
     */
    _inherits(MixinPropMgrColumn, _PropertyPathMgrColum);
    return _createClass(MixinPropMgrColumn, [{
      key: "$getMixInSlotName",
      value: function $getMixInSlotName() {
        return toSlotName(this.$mixinType);
      }

      /**
       * Get the existing mixin instance that already belongs to the component
       * loaded into the row. If called from `commit()`, the instance is
       * guaranteed to have been added if it did not already exist.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {baja.Value|null}
       */
    }, {
      key: "getMixinInstance",
      value: function getMixinInstance(row) {
        return this.getMixinContainer(row).get(this.$getMixInSlotName());
      }

      /**
       * Get the container where the mixin is located or will be located once it is added.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {baja.Complex}
       * @since Niagara 4.13
       */
    }, {
      key: "getMixinContainer",
      value: function getMixinContainer(row) {
        return row.getSubject();
      }

      /**
       * Get the mixin instance belonging to the component loaded into the row,
       * or create a new instance to work with.
       *
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {baja.Value}
       */
    }, {
      key: "$getOrMakeMixinInstance",
      value: function $getOrMakeMixinInstance(row) {
        return this.getMixinInstance(row) || baja.$(this.$mixinType);
      }

      /**
       * Get the complex this property is on. Utilize the existing mixin instance or
       * create a new instance of the mixIn if it does not exist yet.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {baja.Complex}
       */
    }, {
      key: "getComplexFromPath",
      value: function getComplexFromPath(row) {
        var _getComplexAndSlotFro2 = getComplexAndSlotFromPath(this.$getOrMakeMixinInstance(row), this.$path),
          complex = _getComplexAndSlotFro2.complex;
        return complex;
      }

      /**
       * Get the property from the mixin instance on this row's component. If
       * the component does not have an instance of that mixin (e.g. it is an
       * unmounted component created browser-side), the default value from an
       * instance of that mixin will be returned.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {baja.Value}
       */
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var instance = this.$getOrMakeMixinInstance(row);
        if (!isComplex(instance)) {
          throw new Error('Complex required');
        }
        var prop = getPropValueFromPath(instance, this.$path);
        if (prop !== null) {
          return prop;
        }
        throw new Error('Could not get slot value for path: ' + toPathString(this.$path));
      }

      /**
       * Sets the value to the mixin instance on the row's component. If the
       * component does not have an instance of the mixin, a new one will be
       * created.
       *
       * This method may be safely overridden while maintaining the assurance that
       * the mixin instance exists.
       *
       * @param {baja.Value} value
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {Object} params
       * @returns {Promise}
       */
    }, {
      key: "commit",
      value: function commit(value, row, params) {
        // mixin behavior is patched in in the constructor.
        return _superPropGet(MixinPropMgrColumn, "commit", this, 3)(arguments);
      }

      /**
       * Sets the value to a new mixin instance for the row.
       *
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {Promise}
       */
    }, {
      key: "$ensureMixinInstanceExists",
      value: function $ensureMixinInstanceExists(row) {
        if (this.getMixinInstance(row)) {
          return Promise.resolve();
        }
        var slot = this.$getMixInSlotName();
        var comp = this.getMixinContainer(row);
        var mixin = baja.$(this.$mixinType);
        return comp.add({
          slot: slot,
          value: mixin
        });
      }
    }]);
  }(PropertyPathMgrColumn);
  return MixinPropMgrColumn;
});
