/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/NewFolderCommand
 */
define(['lex!webEditors', 'bajaux/commands/Command', 'bajaux/mixin/mixinUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand'], function (lexs, Command, mixinUtils, feDialogs, MgrCommand) {
  'use strict';

  var ALL_BARS = MgrCommand.flags.ALL_BARS;

  ////////////////////////////////////////////////////////////////
  // NewFolderCommand
  ////////////////////////////////////////////////////////////////

  var webEditorsLex = lexs[0];

  /**
   * Command for adding new folders to a driver manager view.
   * The type of folder to be created is defined by the manager
   * model, specified in the constructor. This command requires
   * the manager's model to have the `folderMgrModelMixin` applied.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/NewFolderCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager
   */
  var NewFolderCommand = function NewFolderCommand(manager) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.mgr.newFolder',
      flags: ALL_BARS,
      /**
       * Prompt the user with a dialog for a new folder name, then add a new folder
       * to the root subject component.
       *
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/NewFolderCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var mgrModel = manager.getModel();
        if (!mixinUtils.hasMixin(mgrModel, 'FOLDER_MGR_MODEL')) {
          throw new Error('Manager model type must have the folderMgrModelMixin applied.');
        }
        return feDialogs.showFor({
          value: webEditorsLex.get('newFolder.dlg.defVal'),
          title: webEditorsLex.get('newFolder.dlg.title'),
          formFactor: 'mini'
        }).then(function (name) {
          if (name !== null) {
            return mgrModel.createFolder(name);
          }
        });
      }
    });
  };
  NewFolderCommand.prototype = Object.create(Command.prototype);
  NewFolderCommand.prototype.constructor = NewFolderCommand;
  return NewFolderCommand;
});
