/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * @module nmodule/webEditors/rc/wb/mgr/commands/MgrCommand
 */
define(['bajaux/commands/Command', 'bajaux/mixin/mixinUtils'], function (Command, mixinUtils) {
  'use strict';

  var _Command$flags = Command.flags,
    USER_DEFINED_1 = _Command$flags.USER_DEFINED_1,
    USER_DEFINED_2 = _Command$flags.USER_DEFINED_2,
    USER_DEFINED_3 = _Command$flags.USER_DEFINED_3;
  var applyMixin = mixinUtils.applyMixin;
  var MIXIN_NAME = 'MGR_COMMAND';

  /**
   * API Status: **Development**
   *
   * As of Niagara 4.14, applying MgrCommand as a mixin on a regular Command is deprecated. The only
   * functionality used is the `MgrCommand.flags` values, which can be set or unset on a regular
   * Command instance.
   *
   * Optional mixin type used to extend a bajaux `Command` with extra functionality used by
   * a `Manager` view. Commands don't need to apply this mixin to be functional in a bajaux
   * `Manager`, this can just provide additional behavior to any `Command` that requires it.
   *
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand
   *
   * @mixin
   * @param {module:bajaux/commands/Command} target the `Command` to have the
   * mixin functionality applied to it.
   * @see module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand.flags
   */
  var MgrCommand = function MgrCommand(target) {
    if (!(target instanceof Command)) {
      throw new Error('MgrCommand mixin must be applied to a Command type');
    }
    if (!applyMixin(target, MIXIN_NAME)) {
      return;
    }

    /**
     * Returns a Boolean indicating whether this `Command` should be shown in the 'action bar'
     * at the bottom of the manager view. Defaults to `true`.
     *
     * @function module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand#isShownInActionBar
     * @deprecated use {@link module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand~flags|flags} instead
     * @returns {Boolean}
     */
    target.isShownInActionBar = function () {
      return this.$showInActionBar;
    };

    /**
     * Set whether this `Command` should be shown in the 'action bar' at the bottom of the
     * manager view. The default behavior is to show all commands in the manager's command
     * group at the bottom of the view. If called, it will typically be with a `false` argument
     * show the command in the tool bar, but not in the main view.
     *
     * @function module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand#setShowInActionBar
     * @deprecated use {@link module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand~flags|flags} instead
     * @param {Boolean} show true if this instance should be shown in the manager's action bar.
     */
    target.setShowInActionBar = function (show) {
      this.$showInActionBar = !!show;
    };
    target.$showInActionBar = true;
  };

  /**
   * @since Niagara 4.14
   */
  MgrCommand.flags = Object.assign({}, Command.flags);

  /**
   * Enables the command in the action bar at the bottom of the Manager.
   * @type {number}
   */
  MgrCommand.flags.ACTION_BAR = USER_DEFINED_1;

  /**
   * Enables the command in a context menu triggered from the main database table.
   * @type {number}
   */
  MgrCommand.flags.MAIN_CONTEXT_MENU = USER_DEFINED_2;

  /**
   * Enables the command in a context menu triggered from the learn table.
   * @type {number}
   */
  MgrCommand.flags.LEARN_CONTEXT_MENU = USER_DEFINED_3;

  /**
   * Enables the command in all "bars": the action bar at the bottom of the manager,
   * the toolbar buttons at the top, and the menu bar (in Workbench, through bajaux interop).
   * @type {number}
   */
  MgrCommand.flags.ALL_BARS = MgrCommand.flags.ACTION_BAR | MgrCommand.flags.MENU_BAR | MgrCommand.flags.TOOL_BAR;
  return MgrCommand;
});
