/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/LearnModeCommand
 */
define(['bajaux/commands/ToggleCommand', 'bajaux/mixin/mixinUtils', 'Promise', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand'], function (ToggleCommand, mixinUtils, Promise, MgrCommand) {
  'use strict';

  var _MgrCommand$flags = MgrCommand.flags,
    MENU_BAR = _MgrCommand$flags.MENU_BAR,
    TOOL_BAR = _MgrCommand$flags.TOOL_BAR;

  /**
   * Toggle command for showing or hiding the learn mode on the manager view.
   * Starting a discovery will automatically set this command to the 'on'
   * state. This command will not be shown in the manager's action bar, only
   * on the tool bar.
   *
   * For this command to function correctly, the manager must have the `MgrLearn`
   * functionality mixed in.
   *
   * @class
   * @extends module:bajaux/commands/ToggleCommand
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/LearnModeCommand
   * @mixes module:nmodule/webEditors/rc/wb/mgr/commands/MgrCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrLearn} mgr
   */
  var LearnModeCommand = function LearnModeCommand(mgr) {
    var that = this;
    ToggleCommand.call(that, {
      module: 'webEditors',
      lex: 'commands.mgr.learnMode',
      selected: mgr ? mgr.isLearnModeEnabled() : false,
      enabled: true,
      flags: MENU_BAR | TOOL_BAR,
      /**
       * Function called when the Command is toggled. This will hide or show
       * the discovery pane in the manager view.
       *
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/LearnModeCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        this.toggle();
        if (mixinUtils.hasMixin(mgr, 'MGR_LEARN')) {
          mgr.setLearnModeEnabled(that.isSelected());
          return Promise.resolve();
        } else {
          return Promise.reject(new Error('manager does not have learn support'));
        }
      }
    });
  };
  LearnModeCommand.prototype = Object.create(ToggleCommand.prototype);
  LearnModeCommand.prototype.constructor = LearnModeCommand;
  return LearnModeCommand;
});
