function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/* jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/AddCommand
 */
define(['baja!', 'lex!webEditors', 'jquery', 'Promise', 'underscore', 'dialogs', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/webEditors/rc/wb/mgr/BatchComponentEditor', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn'], function (baja, lexs, $, Promise, _, dialogs, Command, fe, feDialogs, MgrCommand, BatchComponentEditor, mgrUtils, MgrModel, TypeMgrColumn) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var getLearnTableSelectedSubjects = mgrUtils.getLearnTableSelectedSubjects,
    getProposedValue = mgrUtils.getProposedValue,
    setProposedDiscoveryValues = mgrUtils.setProposedDiscoveryValues,
    toMgrTypeInfos = mgrUtils.toMgrTypeInfos;
  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    LEARN_CONTEXT_MENU = _MgrCommand$flags.LEARN_CONTEXT_MENU;
  function getComponentNames(comps) {
    return _.invoke(comps, 'getName');
  }
  function getRowSubjects(rows) {
    return _.invoke(rows, 'getSubject');
  }

  /**
   * From the available types stored against the row, find the MgrTypeInfo
   * that corresponds to the type of the row's subject.
   */
  function getTypeInfoForRow(row) {
    var comp = row.getSubject(),
      type = comp.getType(),
      typeInfos = TypeMgrColumn.getAvailableTypes(row);
    return _.find(typeInfos, function (t) {
      return type.equals(t.getType());
    });
  }

  /**
   * Creates an array of slot names for the given rows, based on the type of
   * the row's subject component.
   *
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
   * @param {baja.Component} origContainer
   * @returns {Array.<String>}
   */
  function generateSlotNamesForRows(rows, origContainer) {
    var slotNames = [];
    _.each(rows, function (row) {
      var typeInfo = getTypeInfoForRow(row),
        discoveryName = getProposedValue(row, '__name'),
        escapedDiscoveryName = discoveryName && baja.SlotPath.escape(discoveryName),
        uniqueName = origContainer.getUniqueName(escapedDiscoveryName || typeInfo.toSlotName()),
        slotName,
        slotNum = uniqueName.match(/\d*$/)[0] || 0;
      uniqueName = uniqueName.replace(/\d*$/, '');
      while (origContainer.has(slotName = uniqueName + (slotNum || '')) || _.contains(slotNames, slotName)) {
        slotNum++;
      }
      slotNames.push(slotName);
    });
    return slotNames;
  }

  /**
   * Returns a new `MgrModel` containing rows representing the items
   * to be added from the discovery table to the database table. This will
   * be used to present the batch component editor before the rows
   * are added to the main model's component source.
   */
  function makeModelForNewRows(mgr, rows) {
    var mgrModel = mgr.getModel(),
      source = baja.$('baja:Folder'),
      origContainer = mgr.value(),
      slotNames = generateSlotNamesForRows(rows, origContainer),
      addModel = new MgrModel({
        componentSource: source,
        columns: mgrModel.getEditableColumns()
      }),
      nameCol = mgrModel.getColumn('__name');
    _.each(rows, function (row, index) {
      source.add({
        slot: slotNames[index],
        value: row.getSubject()
      });
      if (nameCol) {
        nameCol.propose(baja.SlotPath.unescape(slotNames[index]), row);
      }
    });
    return addModel.insertRows(rows, 0).then(_.constant(addModel));
  }

  /**
   * Shows the `BatchComponentEditor` in a dialog with the `Rows`
   * created from the discovery nodes dragged or selected in the
   * learn table. Once the edit is confirmed, the newly dropped
   * components are added to the station.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} mgr the manager instance
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
   * @param {boolean} quick
   */
  function addNewInstances(mgr, rows, quick) {
    var dbModel = mgr.getModel(),
      baseComponent;
    return Promise.all([mgr.getOrdBase(), makeModelForNewRows(mgr, rows)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        ordBase = _ref2[0],
        editorModel = _ref2[1];
      if (editorModel.getRows().length === 0) {
        dialogs.showOk({
          text: webEditorsLex.get("commands.mgr.add.noneToAdd")
        });
        return;
      }
      baseComponent = ordBase;
      var params = {
        value: editorModel,
        properties: {
          ordBase: baseComponent
        },
        type: BatchComponentEditor
      };
      if (quick) {
        params.dom = $('<div></div>');
        return fe.buildFor(params).then(function (editor) {
          return editor.save().then(function () {
            return editor.read();
          });
        });
      }
      return feDialogs.showFor(params);
    }).then(function (addModel) {
      var newRows, newInstances, existingInstances, duplicate;
      if (addModel) {
        // Look at the names of the components we are being asked to add.
        // If any of the names match existing component names, we'll go
        // back and present the add dialog again, to let the user change
        // the name to a non-clashing one.

        newRows = addModel.getRows();
        newInstances = getRowSubjects(newRows);
        existingInstances = getRowSubjects(dbModel.getRows());
        duplicate = findDuplicateSlotName(existingInstances, newInstances);
        if (!duplicate) {
          return dbModel.addInstances(newInstances);
        } else {
          return feDialogs.error(webEditorsLex.get('mgr.duplicateName', duplicate)).then(function () {
            return addNewInstances(mgr, addModel.getRows());
          });
        }
      }
    })["catch"](feDialogs.error);
  }

  /**
   * Search through the two arrays of existing components and new components
   * to be added, looking for any duplicates between the name names and the
   * existing ones. If we find a clash, return the name of the first duplicate
   * so we can show it in an error message.
   *
   * @param {Array.<baja.Component>} existingComps
   * @param {Array.<baja.Component>} newComps
   * @returns {String} the first duplicate name, or null if there were no duplicates found.
   */
  function findDuplicateSlotName(existingComps, newComps) {
    var existingNames = getComponentNames(existingComps),
      newNames = getComponentNames(newComps),
      duplicates = _.intersection(existingNames, newNames);
    return duplicates.length ? _.first(duplicates) : null;
  }

  /**
   * Command for adding discovered items to the station database. The command action can be
   * invoked directly by clicking on the button, or can be invoked by a drag and drop from
   * the discovery table to the main table.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/AddCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrLearn} mgr
   * @param {Object} [params] optional parameter object.
   * @param {boolean} [params.quick] set to true to skip the add dialog.
   */
  var AddCommand = function AddCommand(mgr) {
    var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref3$module = _ref3.module,
      module = _ref3$module === void 0 ? 'webEditors' : _ref3$module,
      lex = _ref3.lex,
      _ref3$flags = _ref3.flags,
      flags = _ref3$flags === void 0 ? ALL_BARS | LEARN_CONTEXT_MENU : _ref3$flags,
      _ref3$enabled = _ref3.enabled,
      enabled = _ref3$enabled === void 0 ? false : _ref3$enabled,
      _ref3$quick = _ref3.quick,
      quick = _ref3$quick === void 0 ? false : _ref3$quick;
    if (quick) {
      lex = lex || 'commands.mgr.quickAdd';
    } else {
      lex = lex || 'commands.mgr.add';
    }
    Command.call(this, {
      module: module,
      lex: lex,
      enabled: enabled,
      flags: flags,
      /**
       * When this command is invoked, we should take the selected components in the discovery
       * table and present a dialog for editing them, before adding them to the station.
       *
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/AddCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var selection,
          dbModel = mgr.getModel();

        // Obtain the current selection from the discovery table - these
        // are the items that were dragged or selected. We then map those items to
        // new Rows for the main manager table, and show the editor dialog
        // to configure them before they are added to the station.

        selection = getLearnTableSelectedSubjects(mgr);
        if (!selection.length) {
          return Promise.resolve();
        }
        return mgr.newInstancesFromDiscoverySubjects(selection).then(function (comps) {
          return Promise.all(selection.map(function (discovery, i) {
            var row;
            return Promise.resolve(mgr.getTypesForDiscoverySubject(discovery)).then(function (typeInfo) {
              if (typeInfo && !_.isEmpty(typeInfo)) {
                return toMgrTypeInfos(typeInfo).then(function (typeInfos) {
                  row = dbModel.makeRow(comps[i]);
                  TypeMgrColumn.setAvailableTypes(row, typeInfos);
                  TypeMgrColumn.setDiscoveryData(row, discovery);
                  return setProposedDiscoveryValues(mgr, dbModel, discovery, row);
                }).then(function () {
                  return row;
                });
              }
            });
          })).then(function (rows) {
            //Remove undefined/null rows
            rows = rows.filter(function (row) {
              return row;
            });
            return addNewInstances(mgr, rows, quick);
          });
        });
      }
    });
  };
  AddCommand.prototype = Object.create(Command.prototype);
  AddCommand.prototype.constructor = AddCommand;
  return AddCommand;
});
