/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/userMenuAgent
 */
define(['baja!', 'nmodule/webEditors/rc/wb/menu/componentMenuAgent', 'nmodule/webEditors/rc/wb/menu/GetUserLoginHistoryCommand', 'nmodule/webEditors/rc/wb/menu/Separator'], function (baja, componentMenuAgent, GetUserLoginHistoryCommand, Separator) {
  'use strict';

  /**
   * @alias module:nmodule/webEditors/rc/wb/menu/userMenuAgent
   * @param {*} owner if the owner has the `TransferSupport` mixin, then
   * transfer commands will be included
   * @param {baja.Component} user a `baja:User`
   * @returns {Promise} promise to be resolved with a `CommandGroup`
   * for the given user.
   * @since Niagara 4.15
   */
  return function userMenuAgent(owner, user) {
    return componentMenuAgent(owner, user).then(function (cmdGroup) {
      if (baja.hasType(user.getParent(), 'baja:UserService') && !baja.isOffline()) {
        cmdGroup.add(new Separator());
        cmdGroup.add(new GetUserLoginHistoryCommand(user));
      }
      return cmdGroup;
    });
  };
});
