function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/NewViewEditor
 */

define(['baja!', 'lex!webEditors', 'Promise', 'bajaux/spandrel', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/RadioButtonGroup', 'nmodule/webEditors/rc/fe/ValueWithCheckbox', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget', 'nmodule/webEditors/rc/servlets/registry', 'nmodule/webEditors/rc/util/fileUtils', 'nmodule/webEditors/rc/wb/table/EditTable'], function (baja, lexs, Promise, spandrel, Widget, RadioButtonGroup, ValueWithCheckbox, ValueWithPopoutWidget, registry, fileUtils, EditTable) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var isValidName = fileUtils.isValidName;
  var CELL_MODIFIED_EVENT = EditTable.CELL_MODIFIED_EVENT,
    where = EditTable.where;
  var _EditTable$columns = EditTable.columns,
    display = _EditTable$columns.display,
    edit = _EditTable$columns.edit;
  var NAME_STRING = webEditorsLex.get('commands.newView.viewName');
  var PX_FILE_STRING = webEditorsLex.get('commands.newView.pxFile');
  var VIEW_ICON_STRING = webEditorsLex.get('commands.newView.viewIcon');
  var SOURCE_STRING = webEditorsLex.get('commands.newView.source');
  var DYNAMIC_STRING = webEditorsLex.get('commands.newView.dynamic');
  var targetType = 'baja:DynamicPxView';
  var columns = [display('name'), edit('value')];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'webEditors',
      keyName: 'NewViewEditor',
      properties: {
        rootCssClass: '-t-NewViewEditor'
      }
    };
  };

  /**
   * Widget for editing within the NewViewCommand
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/menu/NewViewEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.15
   */
  var NewViewEditor = /*#__PURE__*/function (_spandrel) {
    function NewViewEditor(params) {
      _classCallCheck(this, NewViewEditor);
      return _callSuper(this, NewViewEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(NewViewEditor, _spandrel);
    return _createClass(NewViewEditor, [{
      key: "doSave",
      value: function doSave() {
        return this.$getEditTable().save();
      }

      /**
       * for the row with the given name in the left cell, return the editor in the right cell
       * @private
       * @param {string} name
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$cellEditorForName",
      value: function $cellEditorForName(name) {
        return this.$getEditTable().findEditor('value', where('name', name));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getViewNameEditor",
      value: function $getViewNameEditor() {
        return this.$cellEditorForName(NAME_STRING);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPxFileEditor",
      value: function $getPxFileEditor() {
        return this.$cellEditorForName(SOURCE_STRING).queryWidget("**/pxFile");
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSourceEditor",
      value: function $getSourceEditor() {
        return this.$cellEditorForName(SOURCE_STRING);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getIconEditor",
      value: function $getIconEditor() {
        return this.$cellEditorForName(VIEW_ICON_STRING);
      }

      /**
       * @private
       * @param {string} newName
       * @returns {Promise}
       */
    }, {
      key: "$applyNewNameToPxFile",
      value: function $applyNewNameToPxFile(newName) {
        var _this = this;
        return this.$getPxFileEditor().read().then(function (currentPxFile) {
          var generatedPxFile = _this.$getPxFile(newName, currentPxFile);
          if (generatedPxFile) {
            return _this.$getPxFileEditor().loadAndModify(generatedPxFile);
          }
        });
      }

      /**
       * @param {module:nmodule/webEditors/rc/wb/menu/NewViewEditor~NewViewParams} params
       * @returns {object}
       */
    }, {
      key: "toState",
      value: function toState(params) {
        return {
          editTableRows: toEditTableRows(params)
        };
      }

      /**
       * @param state
       * @returns {module:nmodule/webEditors/rc/wb/menu/NewViewEditor~NewViewParams}
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var editTableRows = _ref.editTableRows;
        return fromEditTableRows(editTableRows);
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/EditTable}
       */
    }, {
      key: "$getEditTable",
      value: function $getEditTable() {
        return this.queryWidget('editTableRows');
      }

      /**
       * Based on the ViewName, return the pxFile.
       * @private
       * @param {String} viewName
       * @param {baja.Ord} pxFile
       * @returns {baja.Ord|undefined} return undefined if the viewName is not a valid file name.
       */
    }, {
      key: "$getPxFile",
      value: function $getPxFile(viewName, pxFile) {
        if (!isValidName(viewName)) {
          return;
        }
        var split = pxFile.toString().split("/");
        split.pop();
        var path = split.join("/");
        return baja.Ord.make(path + "/" + viewName + ".px");
      }
    }]);
  }(spandrel(function (values, _ref2) {
    var editTableRows = _ref2.editTableRows,
      self = _ref2.self;
    return spandrel.jsx(EditTable, {
      bind: true,
      spandrelKey: "editTableRows",
      value: editTableRows,
      on: _defineProperty({}, CELL_MODIFIED_EVENT, function (e, ed, _ref3) {
        var row = _ref3.row;
        if (row.name.value === NAME_STRING) {
          var newName = row.value.value;
          return self.$applyNewNameToPxFile(newName);
        }
      }),
      properties: {
        columns: columns,
        fixedHeaders: false
      }
    });
  }, {
    strategy: 'niagara'
  }));
  function toEditTableRows(_ref5) {
    var viewName = _ref5.viewName,
      source = _ref5.source,
      icon = _ref5.icon;
    return [{
      name: {
        value: NAME_STRING
      },
      value: {
        value: viewName,
        properties: {
          mruName: 'NewViewCommand_viewName'
        }
      }
    }, {
      name: {
        value: VIEW_ICON_STRING
      },
      value: {
        value: icon,
        properties: {
          mruName: 'NewViewCommand_view'
        }
      }
    }, {
      name: {
        value: SOURCE_STRING
      },
      value: {
        value: source,
        type: SourceEditor,
        properties: {
          allowHyperlink: false,
          mruName: 'NewViewCommand_source',
          popoutCssClass: 'ux-btn-tb'
        }
      }
    }];
  }
  function fromEditTableRows(editTableRows) {
    return {
      viewName: editTableRows[0].value.value,
      icon: editTableRows[1].value.value,
      source: editTableRows[2].value.value
    };
  }
  var widgetDefaultsForSourceEditor = function widgetDefaultsForSourceEditor() {
    return {
      properties: {
        rootCssClass: '-t-SourceEditor -t-ValueWithCheckbox-root'
      }
    };
  };

  /**
   * @class
   * @private
   * @extends module:bajaux/spandrel/SpandrelWidget
   */
  var SourceEditor = /*#__PURE__*/function (_spandrel2) {
    function SourceEditor(params) {
      _classCallCheck(this, SourceEditor);
      return _callSuper(this, SourceEditor, [{
        params: params,
        defaults: widgetDefaultsForSourceEditor()
      }]);
    }
    _inherits(SourceEditor, _spandrel2);
    return _createClass(SourceEditor, [{
      key: "toState",
      value: function toState(value) {
        var isPxFile = baja.hasType(value, 'baja:Ord');
        var pxFile = baja.Ord.DEFAULT;
        var dynamicPxView = baja.$('baja:TypeSpec');
        if (isPxFile) {
          pxFile = value;
        } else {
          dynamicPxView = value;
        }
        return Promise.resolve().then(function () {
          if (dynamicPxView.encodeToString() === 'null') {
            return registry.getTypes({
              targetType: targetType
            }).then(function (types) {
              if (types.length > 0) {
                dynamicPxView = baja.$('baja:TypeSpec', types[0].type);
              }
            });
          }
        }).then(function () {
          return {
            pxFile: pxFile,
            dynamicPxView: dynamicPxView,
            pxFileChecked: isPxFile
          };
        });
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        var pxFileChecked = state.pxFileChecked,
          pxFile = state.pxFile,
          dynamicPxView = state.dynamicPxView;
        return pxFileChecked ? pxFile : dynamicPxView;
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPxFileWidget",
      value: function $getPxFileWidget() {
        return this.queryWidget('pxFile');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDynamicPxViewWidget",
      value: function $getDynamicPxViewWidget() {
        return this.queryWidget('dynamicPxView');
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var _this$$getPxFileWidge, _this$$getDynamicPxVi;
        return Promise.all([(_this$$getPxFileWidge = this.$getPxFileWidget()).save.apply(_this$$getPxFileWidge, arguments), (_this$$getDynamicPxVi = this.$getDynamicPxViewWidget()).save.apply(_this$$getDynamicPxVi, arguments)]);
      }
    }]);
  }(spandrel(function (value, _ref6) {
    var self = _ref6.self,
      pxFile = _ref6.pxFile,
      dynamicPxView = _ref6.dynamicPxView,
      pxFileChecked = _ref6.pxFileChecked;
    var isPxFile = pxFileChecked;
    return [spandrel.jsx(ValueWithCheckbox, {
      spandrelKey: "pxFile",
      bind: true,
      lax: true,
      value: pxFile,
      "class": "-t-NewViewEditor-pxFile",
      properties: {
        mruName: '-t-NewViewEditor-pxFile',
        label: PX_FILE_STRING,
        checked: isPxFile,
        displayType: 'radio',
        name: '-t-NewViewEditor-source',
        getConfig: function getConfig() {
          return {
            properties: {
              allowHyperlink: false,
              popoutCssClass: 'ux-btn-tb'
            }
          };
        }
      },
      onUxPropertyChanged: function onUxPropertyChanged(e, ed, name, checked) {
        if (name === "checked") {
          return self.state({
            pxFileChecked: checked
          }).then(function () {
            return self.setModified(true);
          });
        }
      }
    }), spandrel.jsx(ValueWithCheckbox, {
      spandrelKey: "dynamicPxView",
      bind: true,
      lax: true,
      value: dynamicPxView,
      "class": "-t-NewViewEditor-dynamicPxView",
      properties: {
        mruName: '-t-NewViewEditor-dynamicPxView',
        label: DYNAMIC_STRING,
        checked: !isPxFile,
        displayType: 'radio',
        name: '-t-NewViewEditor-source',
        getConfig: function getConfig() {
          return {
            properties: {
              targetType: targetType,
              showMru: false
            }
          };
        }
      },
      onUxPropertyChanged: function onUxPropertyChanged(e, ed, name, checked) {
        if (name === "checked") {
          return self.state({
            pxFileChecked: !checked
          }).then(function () {
            return self.setModified(true);
          });
        }
      }
    })];
  }, {
    strategy: 'niagara'
  }));
  NewViewEditor.$SourceEditor = SourceEditor;
  return NewViewEditor;
});

/**
 * @typedef {Object} module:nmodule/webEditors/rc/wb/menu/NewViewEditor~NewViewParams
 * @property {string} viewName
 * @property {baja.Icon} icon
 * @property {baja.Ord|baja.DefaultSimple} source either an Ord for a PxView or a `baja:TypeSpec` for a DynamicPxView.
 */
