function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/NewViewCommand
 */
define(['baja!', 'baja!baja:PxView', 'lex!webEditors', 'jquery', 'Promise', 'bajaux/commands/Command', 'bajaux/widgets/ToStringWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/util/fileUtils', 'nmodule/webEditors/rc/wb/menu/NewViewEditor', 'nmodule/webEditors/rc/wb/options/MruOptions'], function (baja, types, lexs, $, Promise, Command, ToStringWidget, feDialogs, compUtils, fileUtils, NewViewEditor, MruOptions) {
  'use strict';

  var getUniqueName = compUtils.getUniqueName;
  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var UX_MEDIA = baja.$('baja:TypeSpec', 'uxBuilder:UxMedia');

  /**
   * NewViewCommand is used for creating a new PxView from the browser.
   *
   * @class
   * @extends {module:bajaux/commands/Command}
   * @alias module:nmodule/webEditors/rc/wb/menu/NewViewCommand
   */
  var NewViewCommand = /*#__PURE__*/function (_Command) {
    function NewViewCommand(ord) {
      var _this;
      _classCallCheck(this, NewViewCommand);
      return _this = _callSuper(this, NewViewCommand, [{
        module: 'webEditors',
        lex: 'commands.newView',
        func: function func() {
          return Promise.all([ord.get(), MruOptions.make('NewViewCommand_viewName')]).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              comp = _ref2[0],
              mruOptions = _ref2[1];
            var lastViewName = mruOptions.getHistory()[0] || webEditorsLex.get('commands.newView.defaultViewName');
            var uniqueName = baja.SlotPath.unescape(getUniqueName(comp, baja.SlotPath.escape(lastViewName)));
            var values = _this.$makeEditTableValue(uniqueName);
            return feDialogs.showFor({
              title: webEditorsLex.get('commands.newView.title'),
              summary: webEditorsLex.get('commands.newView.summary'),
              type: NewViewEditor,
              value: values
            }).then(function (values) {
              if (!values) {
                return;
              }
              return _this.$valueReady(values, comp, ord);
            });
          });
        }
      }]);
    }

    /**
     * @private
     * @param {String} viewName
     * @returns {module:nmodule/webEditors/rc/wb/menu/NewViewEditor~NewViewParams}
     */
    _inherits(NewViewCommand, _Command);
    return _createClass(NewViewCommand, [{
      key: "$makeEditTableValue",
      value: function $makeEditTableValue(viewName) {
        return {
          viewName: viewName,
          icon: baja.Icon.make('module://icons/x16/views/view.png'),
          source: baja.Ord.make("file:^px/".concat(viewName, ".px"))
        };
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/menu/NewViewEditor~NewViewParams} values
       * @param {baja.Component} comp
       * @param {baja.Ord} ord
       * @returns {Promise}
       * @throws {Error} if the component is already using the generated slotName for the new view.
       */
    }, {
      key: "$valueReady",
      value: function $valueReady(_ref3, comp, ord) {
        var _this2 = this;
        var viewName = _ref3.viewName,
          source = _ref3.source,
          icon = _ref3.icon;
        var slotName = baja.SlotPath.escape(viewName);
        baja.SlotPath.verifyValidName(slotName);
        if (comp.has(slotName)) {
          throw new Error(webEditorsLex.get('commands.newView.slotAlreadyExists', slotName));
        }
        if (baja.hasType(source, 'baja:TypeSpec')) {
          return baja.importTypes([source]).then(function () {
            var dynamicPxView = baja.$(source);
            return _this2.$completeValueReady(comp, slotName, dynamicPxView, ord);
          });
        }
        var pxFile = source;
        return fileUtils.exists(source).then(function (fileExists) {
          if (fileExists) {
            return feDialogs.showFor({
              type: ToStringWidget,
              title: webEditorsLex.get('commands.newView.fileAlreadyExists'),
              value: webEditorsLex.get('commands.newView.reuseOrOverwrite', pxFile.parse().get(0).getBody()),
              buttons: [{
                name: 'reuse',
                displayName: webEditorsLex.get('commands.newView.reuse'),
                handler: function handler() {
                  return 'reuse';
                }
              }, {
                name: 'overwrite',
                displayName: webEditorsLex.get('commands.newView.overwrite'),
                handler: function handler() {
                  return 'overwrite';
                }
              }, {
                name: 'cancel'
              }]
            }).then(function (answer) {
              if (answer === 'overwrite') {
                return fileUtils.upload(pxFile, defaultPxFile).then(function () {
                  return true;
                });
              }
              return answer;
            });
          } else {
            return fileUtils.upload(pxFile, defaultPxFile).then(function () {
              return true;
            });
          }
        }).then(function (confirmed) {
          if (!confirmed) {
            return _this2.invoke();
          }
          var pxView = baja.$('baja:PxView', {
            pxFile: pxFile,
            icon: icon,
            media: UX_MEDIA
          });
          return _this2.$completeValueReady(comp, slotName, pxView, ord);
        });
      }

      /**
       * @private
       * @param {baja.Component} comp
       * @param {String} slotName
       * @param {baja.Struct} pxView
       * @param {baja.Ord} base
       * @returns {Promise}
       */
    }, {
      key: "$completeValueReady",
      value: function $completeValueReady(comp, slotName, pxView, base) {
        return comp.add({
          slot: slotName,
          value: pxView,
          flags: baja.Flags.OPERATOR
        }).then(function () {
          var hyperlinkOrd = baja.Ord.make({
            base: base,
            child: "view:" + slotName + "/uxBuilder"
          }).normalize();
          return window.niagara.env.hyperlink(hyperlinkOrd);
        });
      }

      /**
       * This is the default contents for a new Px File.
       * @return {String}
       */
    }], [{
      key: "getDefaultPxFileContents",
      value: function getDefaultPxFileContents() {
        return defaultPxFile;
      }
    }]);
  }(Command);
  var defaultPxFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Niagara Presentation XML -->\n<px version=\"1.0\" media=\"uxBuilder:UxMedia\">\n\n<import>\n  <module name='gx'/>\n  <module name='bajaui'/>\n</import>\n\n<content>\n  <ScrollPane>\n    <CanvasPane name=\"content\" viewSize=\"1000.0,800.0\" scale=\"fitRatio\" minScaleFactor=\"0.5\" maxScaleFactor=\"1.0\"/>\n  </ScrollPane>\n</content>\n\n</px>";
  return NewViewCommand;
});
