function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/GetUserLoginHistoryCommand
 */
define(['baja!', 'lex!baja,workbench', 'Promise', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/widgets/ToStringWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/wb/table/ExportOnlyTable', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/wb/table/tree/impl/JSONTreeTableModel'], function (baja, lexs, Promise, spandrel, Command, ToStringWidget, feDialogs, IconEditor, ExportOnlyTable, JsonObjectPropertyColumn, JSONTreeTableModel) {
  'use strict';

  var FRIENDLY_ARGUMENT_FOR_RPC = true;
  var _lexs = _slicedToArray(lexs, 2),
    bajaLex = _lexs[0],
    workbenchLex = _lexs[1];
  var HEADER_ICON = baja.Icon.make([bajaLex.get('session.info.login.history.icon')]);

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/menu/GetUserLoginHistoryCommand
   * @extends module:bajaux/commands/Command
   * @since Niagara 4.15
   */
  var GetUserLoginHistoryCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {baja.Component} [user] a `baja:User`. If user is not provided, the login info for the
     * current session's user will be provided.
     */
    function GetUserLoginHistoryCommand(user) {
      var _this;
      _classCallCheck(this, GetUserLoginHistoryCommand);
      _this = _callSuper(this, GetUserLoginHistoryCommand, [{
        module: 'workbench',
        lex: 'user.loginHistory',
        func: function func() {
          return _this.$showDialog();
        }
      }]);
      _this.$user = user;
      return _this;
    }

    /**
     * @returns {Promise}
     */
    _inherits(GetUserLoginHistoryCommand, _Command);
    return _createClass(GetUserLoginHistoryCommand, [{
      key: "$resolveLoginHistory",
      value: function $resolveLoginHistory() {
        var user = this.$user;
        if (user) {
          return baja.rpc({
            ord: user.getNavOrd(),
            method: 'getLoginHistory',
            args: [FRIENDLY_ARGUMENT_FOR_RPC]
          });
        } else {
          return baja.rpc({
            typeSpec: 'baja:User',
            method: 'getLoginHistoryForCurrentAuthenticatedUser',
            args: [FRIENDLY_ARGUMENT_FOR_RPC]
          });
        }
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showDialog",
      value: function $showDialog() {
        var _this2 = this;
        return this.$resolveLoginHistory().then(function (json) {
          var user = _this2.$user;
          var username = user && baja.SlotPath.unescape(user.getName()) || baja.getUserName();
          var title = workbenchLex.get("userLoginHistoryDialog.title", username);
          var buttons = {
            ok: function ok() {}
          };
          if (!json.history) {
            return feDialogs.showFor({
              title: title,
              value: workbenchLex.get('userLoginHistoryDialog.noHistory', username),
              type: ToStringWidget,
              buttons: buttons
            });
          }
          return feDialogs.showFor({
            title: title,
            value: json,
            type: LoginHistoryWidget,
            properties: {
              showSessionInfo: !user,
              username: username
            },
            buttons: buttons
          });
        });
      }
    }]);
  }(Command);
  /**
   * @class
   * @inner
   * @extends module:nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn
   */
  var JsonToAbsTimeColumn = /*#__PURE__*/function (_JsonObjectPropertyCo) {
    function JsonToAbsTimeColumn() {
      _classCallCheck(this, JsonToAbsTimeColumn);
      return _callSuper(this, JsonToAbsTimeColumn, arguments);
    }
    _inherits(JsonToAbsTimeColumn, _JsonObjectPropertyCo);
    return _createClass(JsonToAbsTimeColumn, [{
      key: "getValueFor",
      value:
      /**
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {baja.AbsTime}
       */
      function getValueFor(row) {
        var date = _superPropGet(JsonToAbsTimeColumn, "getValueFor", this, 3)([row]);
        return baja.AbsTime.make({
          jsDate: new Date(date)
        });
      }
    }, {
      key: "buildCell",
      value: function buildCell(row, dom) {
        var value = this.getValueFor(row);
        return value.toString({
          showSeconds: true
        }).then(function (str) {
          return dom.text(str);
        });
      }
    }]);
  }(JsonObjectPropertyColumn);
  /**
   * @class
   * @inner
   * @extends {module:bajaux/Widget}
   */
  var LoginHistoryWidget = /*#__PURE__*/function (_spandrel) {
    function LoginHistoryWidget(params) {
      _classCallCheck(this, LoginHistoryWidget);
      return _callSuper(this, LoginHistoryWidget, [{
        params: params
      }]);
    }
    _inherits(LoginHistoryWidget, _spandrel);
    return _createClass(LoginHistoryWidget);
  }(spandrel(function (json, _ref) {
    var properties = _ref.properties;
    var previousAbsTime = "";
    var showSessionInfo = properties.showSessionInfo,
      username = properties.username;
    if (json.previousLoginEntry) {
      previousAbsTime = baja.AbsTime.make({
        jsDate: new Date(json.previousLoginEntry.timestamp)
      });
    }
    var timestamp = new JsonToAbsTimeColumn('timestamp', {
      displayName: workbenchLex.get('userLoginHistoryDialog.history.time')
    });
    var location = new JsonObjectPropertyColumn('location', {
      displayName: workbenchLex.get('userLoginHistoryDialog.history.location')
    });
    var success = new JsonObjectPropertyColumn('success', {
      displayName: workbenchLex.get('userLoginHistoryDialog.history.success')
    });
    var secure = new JsonObjectPropertyColumn('secure', {
      displayName: workbenchLex.get('userLoginHistoryDialog.history.secure')
    });
    var client = new JsonObjectPropertyColumn('client', {
      displayName: workbenchLex.get('userLoginHistoryDialog.history.client')
    });
    return Promise.all([JSONTreeTableModel.make({
      data: json.history,
      columns: [timestamp, location, success, secure, client]
    }), previousAbsTime && previousAbsTime.toString({})]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        model = _ref3[0],
        previousAbsTimeToString = _ref3[1];
      var header = json.previousLoginEntry && bajaLex.get('session.info.previousLogin', previousAbsTimeToString, json.previousLoginEntry.location, json.previousLoginEntry.client) || "";
      var connectedAs = bajaLex.get('session.info.connectedAs', username);
      return [showSessionInfo && spandrel.jsx("div", {
        "class": "-t-LoginHistoryWidget-header"
      }, spandrel.jsx(IconEditor, {
        tagName: "span",
        value: HEADER_ICON
      }), spandrel.jsx("span", null, spandrel.jsx("div", null, header), spandrel.jsx("div", null, connectedAs))), spandrel.jsx(ExportOnlyTable, {
        value: model
      })];
    });
  }, {
    strategy: 'niagara'
  }));
  return GetUserLoginHistoryCommand;
});
