function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*eslint-env browser */ /*jshint browser: true */
/*global niagara: false */

require.config({
  shim: {
    'nmodule/js/rc/jquery/contextMenu/jquery.contextMenu': {
      deps: ['jquery']
    },
    'nmodule/js/rc/jquery/contextMenu/jquery.ui.position': {
      deps: ['jquery']
    }
  }
});

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.menu.CommandGroupContextMenu', 'bajaux/events', 'bajaux/Widget', 'bajaux/commands/Command', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/jquery/contextMenu/jquery.contextMenu', 'nmodule/js/rc/jquery/contextMenu/jquery.ui.position', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/wb/menu/Separator', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'css!nmodule/js/rc/jquery/contextMenu/jquery.contextMenu'], function (baja, log, events, Widget, Command, $, Promise, _, asyncUtils, $cm, $ui, switchboard, fe, IconEditor, Separator, ContextMenuSupport) {
  'use strict';

  var any = _.any,
    find = _.find,
    once = _.once,
    pluck = _.pluck;
  var doRequire = asyncUtils.doRequire,
    waitForTrue = asyncUtils.waitForTrue;
  var DATA_KEY = 'contextMenuConfig';
  var _events$command = events.command,
    CHANGE_EVENT = _events$command.CHANGE_EVENT,
    GROUP_CHANGE_EVENT = _events$command.GROUP_CHANGE_EVENT;
  var logSevere = log.severe.bind(log);
  var UPDATE_CONTEXT_MENU = ContextMenuSupport.events.UPDATE_CONTEXT_MENU;

  // avoid circular dependency
  var requireProfileUtils = once(function () {
    return doRequire('nmodule/webEditors/rc/wb/profile/profileUtils');
  });

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  //TODO: can we stipulate that an editor add the contextMenu class to anything it wants right clickable? or let editor choose?
  /**
   * Get the CSS selector appropriate for the loaded editor.
   *
   * @inner
   * @param {module:bajaux/Widget} ed
   * @returns {string}
   */
  function getSelector(ed) {
    return ed.getContextMenuSelector ? ed.getContextMenuSelector() : '.contextMenu';
  }

  /**
   * See if the editor supports Command Accelerators.
   *
   * @inner
   * @param {module:bajaux/Widget} ed
   * @returns {boolean}
   */
  function supportsContextMenuAccelerators(ed) {
    return ed.supportsContextMenuAccelerators ? ed.supportsContextMenuAccelerators() : false;
  }

  /**
   * If the Context Menu Commands are not ready to be inspected on a mousedown to look for accelerators (in case they are enabled asynchronously after a click), then override this method
   * to return false. When the context menu commands are ready for a call to `toContextMenu`, fire a `updateContextMenu` event on the context menu DOM element (see `getSelector()`).
   *
   * @inner
   * @param {module:bajaux/Widget} ed
   * @returns {boolean}
   */
  function contextMenuReadyOnMouseDown(ed) {
    return ed.contextMenuReadyOnMouseDown ? ed.contextMenuReadyOnMouseDown() : true;
  }

  //TODO: just use pageX/pageY if Workbench ever supports it
  function getPageX(e) {
    if (e.touches && e.touches.length > 0) {
      return e.touches[0].pageX;
    } else {
      return e.pageX || e.clientX + $(window).scrollLeft();
    }
  }
  function getPageY(e) {
    if (e.touches && e.touches.length > 0) {
      return e.touches[0].pageY;
    } else {
      return e.pageY || e.clientY + $(window).scrollTop();
    }
  }

  //TODO: disable a second right click while toItems is working

  /**
   * Get the command from the items object with the specified key.
   *
   * @inner
   * @param {Object} items items object from `toItems()`
   * @param {String} key
   * @returns {module:bajaux/commands/Command}
   */
  function getCommand(items, key) {
    var result = items,
      keys = key.split('|').slice(0, -1);
    keys.forEach(function (key) {
      result = result[key].items;
    });
    return result[key].cmd;
  }
  var idCounter = 0;
  function generateIconHtml(cmd, elem) {
    var existing = Widget["in"](elem);
    return Promise.resolve(existing && existing.destroy()).then(function () {
      return cmd.loading();
    }).then(function () {
      return fe.buildFor({
        value: baja.Icon.make(cmd.getIcon()),
        type: IconEditor,
        dom: elem
      });
    });
  }

  /**
   * Convert a command to an item object that `jQuery-contextMenu` can handle.
   *
   * @inner
   * @param {module:bajaux/commands/Command} cmd
   * @param {String} key the key string to be assigned to this command
   * @param {Object} [params] the object literal for the general parameters
   * @param {boolean} [params.supportsAccelerators=false] does this Context Menu Support Accelerators
   * @returns {Promise} promise to be resolved with the object literal
   */
  function commandToItem(cmd, key) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
      _ref$supportsAccelera = _ref.supportsAccelerators,
      supportsAccelerators = _ref$supportsAccelera === void 0 ? false : _ref$supportsAccelera;
    var div = $('<div/>'),
      iconId = 'CommandGroupContextMenu_Item_' + ++idCounter,
      safeToHideIcon = typeof cmd.safeToHideIcon !== 'function' || !!cmd.safeToHideIcon(),
      iconSpan = $('<span class="icon"/>').attr('id', iconId).toggleClass('safe-to-hide', safeToHideIcon).appendTo(div),
      displaySpan = $('<span class="display" />').appendTo(div);
    var isSeparator = cmd instanceof Separator;
    var className = isSeparator ? 'context-menu-divider' : '';
    cmd.on(CHANGE_EVENT, function () {
      var iconEl = $('#' + iconId);
      if (iconEl.length) {
        generateIconHtml(cmd, iconEl)["catch"](logSevere);
      }
    });
    return Promise.all([cmd.toDisplayName(), generateIconHtml(cmd, iconSpan)]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 1),
        displayName = _ref3[0];
      displaySpan.text(displayName);
      if (supportsAccelerators) {
        if (cmd.getAccelerator()) {
          className += " context-menu-item-with-accelerator";
          var acceleratorSpan = $('<span class="accelerator-spacer"></span><span class="accelerator" />').appendTo(div);
          acceleratorSpan.eq(1).text(cmd.getAccelerator().toString());
        }
      }
      var commandName = isSeparator ? '' : div.html();
      //TODO: jQuery-contextMenu expects icons to use .icon-iconName CSS format. so should we
      return {
        cmd: cmd,
        className: className,
        key: key,
        disabled: !cmd.isEnabled(),
        hasForcedIcon: !safeToHideIcon,
        name: commandName,
        isHtmlName: true
      };
    });
  }

  /**
   * @inner
   * @param {*} item
   * @returns {boolean}
   */
  function isSeparator(item) {
    return !!(item.className && typeof item.className === 'string' && item.className.indexOf("context-menu-divider") > -1);
  }

  /**
   * @inner
   * @param {Array<*>} items
   */
  function removeStartingSeparator(items) {
    removeSeparatorAtIndex(items, 0);
  }

  /**
   * @inner
   * @param {Array<*>} items
   */
  function removeEndingSeparator(items) {
    removeSeparatorAtIndex(items, items.length - 1);
  }

  /**
   * @inner
   * @param {Array<*>} items
   * @param {int} index
   */
  function removeSeparatorAtIndex(items, index) {
    if (items.length > index && items.length > 0 && isSeparator(items[index])) {
      items.splice(index, 1);
    }
  }

  /**
   * @inner
   * @param {Array<*>} items
   */
  function removeConsecutiveSeparators(items) {
    var i = 0;
    while (i < items.length - 1) {
      if (isSeparator(items[i]) && isSeparator(items[i + 1])) {
        items.splice(i + 1, 1);
      } else {
        i++;
      }
    }
  }

  /**
   * @inner
   * @param {Array<*>} items
   */
  function coalesceSeparators(items) {
    removeStartingSeparator(items);
    removeEndingSeparator(items);
    removeConsecutiveSeparators(items);
  }

  /**
   * Convert a child `CommandGroup` to an object literal that
   * `jQuery-contextMenu` can handle, with child objects for child command
   * groups and commands.
   *
   * @inner
   * @param {module:bajaux/commands/CommandGroup} group
   * @param {String} key the string key to be assigned to this group
   * @param {Object} params the object literal for the general parameters
   * @returns {Promise} promise to be resolved with the object literal
   */
  function groupToItems(group, key, params) {
    return Promise.all(group.getChildren().map(function (kid, i) {
      if (kid instanceof Command) {
        return commandToItem(kid, (key ? key + '|' : '') + 'cmd' + i, params);
      }
      return groupToItems(kid, (key ? key + '|' : '') + 'grp' + i, params);
    })).then(function (items) {
      coalesceSeparators(items);
      var itemsObj = {};
      items.forEach(function (item) {
        itemsObj[item.key] = item;
      });
      var div = $('<div/>'),
        iconId = 'CommandGroupContextMenu_Item_' + ++idCounter,
        safeToHideIcon = typeof group.safeToHideIcon !== 'function' || !!group.safeToHideIcon(),
        iconSpan = $('<span class="icon"/>').attr('id', iconId).toggleClass('safe-to-hide', safeToHideIcon).appendTo(div),
        displaySpan = $('<span class="display" />').appendTo(div);
      group.on(GROUP_CHANGE_EVENT, function () {
        var iconEl = $('#' + iconId);
        if (iconEl.length) {
          generateIconHtml(group, iconEl)["catch"](logSevere);
        }
      });
      return Promise.all([group.toDisplayName(), generateIconHtml(group, iconSpan)]).then(function (_ref4) {
        var _ref5 = _slicedToArray(_ref4, 1),
          displayName = _ref5[0];
        displaySpan.text(displayName);
        var commandName = div.html();
        return {
          cmd: group,
          name: commandName,
          isHtmlName: true,
          disabled: !items.length,
          items: items.length && itemsObj,
          key: key,
          hasForcedIcon: !safeToHideIcon
        };
      });
    });
  }

  /**
   * Convert the root command group to an object literal to be fed directly to
   * the `$.contextMenu` call.
   *
   * @inner
   * @param {module:bajaux/commands/CommandGroup} group the root group - direct
   * output from `$toContextMenu()`
   * @param {Object} [params] the object literal for the general parameters
   * @returns {Promise} promise to be resolved with an object literal
   * to be used as the `items` parameter to `$.contextMenu`. See the
   * `jQuery-contextMenu` documentation for details.
   */
  function rootToItems(group, params) {
    return groupToItems(group, '', params).then(function (o) {
      return o.items;
    });
  }

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * An add-on that enables right-click menus on editors with the
   * `contextMenuSupport` mixin. The context menu `CommandGroup` will be
   * shown using the `jQuery-contextMenu` library.
   *
   * If the editor does not have the `contextMenuSupport` mixin, you should
   * subclass `CommandGroupContextMenu` and implement `toContextMenu` yourself.
   *
   * Some themes will hide the icons from the menu for cleanliness. But this can
   * sometimes mean that they become unusable (for instance, a command to show
   * or hide a visible column uses a checkmark icon to show whether the column
   * is shown). To ensure the icon is always shown regardless of theme, have
   * the Command implement a function `safeToHideIcon()` that returns false.
   *
   * Similarly, you might want the context menu to remain open after invoking a
   * command again, I might want to show or hide multiple columns without having
   * to re-open the menu in between each. To enable this, have the Command
   * implement a `hideAfterInvoke()` function that returns false.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
   * @param {module:nmodule/webEditors/rc/fe/baja/BaseEditor} editor an editor
   * that in most cases should have the `contextMenuSupport` mixin added
   * @see module:nmodule/webEditors/rc/wb/mixin/ContextMenuSupport
   */
  var CommandGroupContextMenu = function CommandGroupContextMenu(editor) {
    if (!editor) {
      throw new Error('Editor required');
    }
    this.$ed = editor;
  };

  /**
   * Perform a one-shot context menu operation.
   *
   * @param {object} params
   * @param {module:bajaux/commands/CommandGroup} params.group the commands to
   * present to the user in the context menu
   * @param {JQuery.TriggeredEvent} [params.event] pass an event directly to use
   * its x and y coordinates
   * @param {number} [params.x] or pass an x coordinate directly
   * @param {number} [params.y] or pass a y coordinate directly
   * @returns {Promise} to be resolved after the context menu is hidden
   */
  CommandGroupContextMenu.show = function (_ref6) {
    var group = _ref6.group,
      event = _ref6.event,
      x = _ref6.x,
      y = _ref6.y;
    var dom = $('<div></div>');
    var triggerDom = $('<div class="contextMenu"></div>').appendTo(dom);
    var menu = new CommandGroupContextMenu({
      jq: function jq() {
        return dom;
      }
    });
    menu.$armContextMenuAsync(dom, '.contextMenu');
    menu.$mjq = triggerDom;
    x = x || event && getPageX(event);
    y = y || event && getPageY(event);
    return rootToItems(group).then(function (items) {
      return items && doShow({
        triggerDom: triggerDom,
        menu: menu,
        items: items,
        x: x,
        y: y
      });
    })["finally"](function () {
      return menu.destroy();
    });
  };

  /**
   * Get the parameters which may affect how the items render.
   * @private
   * @returns {{supportsAccelerators: boolean}}
   */
  CommandGroupContextMenu.prototype.$getItemParams = function () {
    var supportsAccelerators = supportsContextMenuAccelerators(this.$ed);
    return {
      supportsAccelerators: supportsAccelerators
    };
  };

  /**
   * @param {object} params
   * @param {module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu} params.menu
   * @param {JQuery} params.triggerDom
   * @param {object} params.items
   * @param {number} params.x
   * @param {number} params.y
   * @returns {Promise} to be resolved after the context menu is hidden
   */
  function doShow(_ref7) {
    var menu = _ref7.menu,
      triggerDom = _ref7.triggerDom,
      items = _ref7.items,
      x = _ref7.x,
      y = _ref7.y;
    if (!items) {
      return Promise.resolve();
    }

    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve) {
      triggerDom.data(DATA_KEY, {
        callback: function callback(key) {
          var command = getCommand(items, key);
          command.invoke()["catch"](function (err) {
            logSevere(err);
            return command.defaultNotifyUser(err);
          });
          return typeof command.hideAfterInvoke !== 'function' || !!command.hideAfterInvoke();
        },
        events: {
          hide: resolve
        },
        className: menu.$getClassName(items),
        items: items,
        // This zIndex puts the context menu on the same level as the dialog, so if the context menu is opened last, it will be on top.
        zIndex: 9001
      });

      // This timeout resolves an issue with dragstart events not firing properly on mobile
      setTimeout(function () {
        triggerDom.contextMenu({
          //use 1 because if you wind up with 0, jQuery-contextMenu treats it as falsy
          x: x || 1,
          y: y || 1
        });
        menu.$menu = triggerDom.data('contextMenu');
      }, 0);
    });
  }

  /**
   * Set up `jQuery-contextMenu` on this element, but bypass the built-in
   * event handling as we need to do some async work before menu shows up.
   * The `mousedown` handler we arm ourselves will do some async work, sock away
   * the data on the DOM element itself, and then manually trigger the
   * `contextMenu` call. `contextMenu` will then grab that data and use it
   * to build the menu on demand.
   *
   * @private
   * @param {JQuery} jq
   * @param {string} selector
   */
  CommandGroupContextMenu.prototype.$armContextMenuAsync = function (jq, selector) {
    jq.contextMenu({
      selector: selector,
      trigger: 'none',
      reposition: false,
      build: function build($trigger) {
        var data = $trigger.data(DATA_KEY) || false;
        $trigger.removeData(DATA_KEY);
        return data;
      },
      $ref: this // hold onto this to reference in destroy()
    });
  };

  /**
   * Return a class name to apply to the menu root.
   *
   * @private
   * @param {object[]} items the config objects for each entry in the context menu
   * @returns {string}
   */
  CommandGroupContextMenu.prototype.$getClassName = function (items) {
    var className = 'hide-root-icons';
    if (any(pluck(items, 'hasForcedIcon'))) {
      //if any icons are forced to be shown, we can't use display: none to hide
      //other icons as this would break the layout. web/rc/theme/theme.css
      //caters for this.
      className += ' has-forced-icons';
    }
    return className;
  };

  /**
   * Asynchronously resolve the items to show in the context menu, then show it.
   *
   * @private
   * @param {JQuery.TriggeredEvent} e the right click event
   * @returns {boolean} false if the event needs to stop propagation
   */
  CommandGroupContextMenu.prototype.$doContextMenu = function (e) {
    var _this = this;
    var triggerDom = this.$mjq = $(e.currentTarget);
    var x = getPageX(e);
    var y = getPageY(e);
    this.toItems(e).then(function (items) {
      return doShow({
        triggerDom: triggerDom,
        menu: _this,
        items: items,
        x: x,
        y: y
      });
    })["catch"](logSevere);
    return false;
  };

  /**
   * Hides any currently shown context menu.
   * @private
   * @returns {Promise}
   */
  CommandGroupContextMenu.prototype.$hideContextMenu = function () {
    var menuJq = this.$mjq;
    var menu = this.$menu;
    if (menuJq) {
      menuJq.contextMenu('hide');
    }
    return waitForTrue(function () {
      return !(menu && menu.$menu && menu.$menu.parent().length);
    });
  };

  /**
   * Instantiates an items config object to be passed to the `$.contextMenu`
   * call. Config will be built up using the `CommandGroup` provided through
   * the `contextMenuSupport` mixin.
   *
   * @param {jQuery.Event} e the right-click event
   * @returns {Promise} promise to be resolved with an `items` config
   * object. See the `jQuery-contextMenu` documentation for details.
   */
  CommandGroupContextMenu.prototype.toItems = function (e) {
    var _this2 = this;
    return Promise.resolve(this.toContextMenu(e)).then(function (group) {
      return group && rootToItems(group, _this2.$getItemParams());
    });
  };
  CommandGroupContextMenu.prototype.toContextMenu = function (e) {
    return this.$ed.$toContextMenu(e);
  };

  /**
   * JavaFX doesn't fire `contextmenu` events unless actually showing the Swing
   * context menu, which we disable (see BWebBrowser constructor). So fake it -
   * a right click will trigger `contextmenu` as expected. Only if WB/JavaFX
   * browser is detected.
   *
   * @param {JQuery} jq
   * @param {string} selector
   */
  CommandGroupContextMenu.shimContextMenuForWorkbench = function (jq, selector) {
    if (CommandGroupContextMenu.$isWorkbench() && CommandGroupContextMenu.$isJavaFX()) {
      jq.on('mousedown', selector, function (e) {
        if (e.which === 3) {
          $(e.target).trigger($.Event('contextmenu', {
            which: 3,
            originalEvent: e.originalEvent,
            data: e.data,
            pageX: e.pageX,
            pageY: e.pageY,
            offsetX: e.offsetX,
            offsetY: e.offsetY
          }));
        }
      });
    }
  };

  /**
   * @private
   * @returns {boolean}
   */
  CommandGroupContextMenu.$isWorkbench = function () {
    return typeof niagara !== 'undefined' && niagara.env.type === 'wb';
  };

  /**
   * @private
   * @returns {boolean}
   */
  CommandGroupContextMenu.$isJavaFX = function () {
    return !!navigator.userAgent.match(/JavaFX/);
  };

  /**
   * Arm event handlers on the loaded editor's DOM element to show the
   * context menu on right-click.
   *
   * @param {Object} [params]
   * @param {string} [params.selector='.contextMenu'] the selector from which to
   * delegate contextmenu events. If not given,
   * `editor.getContextMenuSelector()` will be called, if present; otherwise
   * default selector will be used.
   */
  CommandGroupContextMenu.prototype.arm = function (params) {
    var that = this,
      ed = that.$ed,
      selector = params && params.selector || getSelector(ed),
      jq = ed.jq();
    requireProfileUtils().then(function (profileUtils) {
      that.$profileUtils = profileUtils;
    })["catch"](function (error) {
      logSevere(error);
    });
    function doContextMenu(e) {
      return that.$doContextMenu(e);
    }
    CommandGroupContextMenu.shimContextMenuForWorkbench(jq, selector);
    if (ed.armContextMenu) {
      ed.armContextMenu(doContextMenu);
    } else {
      jq.on('contextmenu', selector, function (e) {
        if (e.which === 3) {
          return doContextMenu(e);
        }
        return false;
      });
      if (supportsContextMenuAccelerators(ed)) {
        jq.find(selector).attr('tabIndex', -1);
        var readyOnMouseDown = contextMenuReadyOnMouseDown(ed);
        that.$jqMouseDownHandler = function (e) {
          that.$lastMouseDownPending = true;
          that.toItems(e).then(function (items) {
            if (that.$lastMouseDownPending) {
              that.$lastMouseDownTarget = e.target;
              that.$lastMouseDownItems = items;
            }
          })["catch"](function (error) {
            logSevere(error);
          })["finally"](function () {
            that.$lastMouseDownPending = false;
          });
        };
        switchboard(that, {
          $jqMouseDownHandler: {
            allow: 'oneAtATime',
            onRepeat: 'returnLast'
          }
        });
        if (readyOnMouseDown) {
          that.$documentMouseDownHandler = function () {
            that.$lastMouseDownTarget = null;
            that.$lastMouseDownPending = false;
          };
          document.addEventListener('mousedown', that.$documentMouseDownHandler, true);
          jq.on('mousedown', selector, function (e) {
            that.$jqMouseDownHandler(e);
          });
        }
        jq.on(UPDATE_CONTEXT_MENU, selector, function (e) {
          that.$jqMouseDownHandler(e);
        });
        jq.on('keydown', selector, function (e) {
          var element = e.target;
          if (acceptsKeyboardEvents(element.tagName.toLowerCase())) {
            return;
          }
          if (that.$lastMouseDownPending) {
            //after a click and before the commands have loaded, incase a key event
            return;
          }
          //ensure the selector is matched or else this could be further down (like from an input)
          if (that.$lastMouseDownTarget && $(that.$lastMouseDownTarget).closest(selector)) {
            var profileUtils = that.$profileUtils;
            if (profileUtils && profileUtils.invokeProfileCommandMatchingAccelerator(e.originalEvent)) {
              return false;
            }
            var items = that.$lastMouseDownItems;
            var command = findCommandForEvent(items, e.originalEvent);
            if (command) {
              //get a fresh set of items in case the arguments to those commands have changed since mousedown
              that.toItems(e).then(function (items) {
                var command = findCommandForEvent(items, e.originalEvent);
                if (command) {
                  return command.invoke();
                }
              })["catch"](function (err) {
                logSevere(err);
                return command.defaultNotifyUser(err);
              });
              return false;
            }
          }
        });
      }
    }
    that.$armContextMenuAsync(jq, selector);
  };

  /**
   * Return true for things that users should be typing into which don't check for accelerators.
   * This includes inputs, selects, and textareas.
   * @param {String} tagName
   * @returns {boolean}
   */
  function acceptsKeyboardEvents(tagName) {
    var tags = /^(?:input|select|textarea)/i;
    return tags.test(tagName);
  }

  /**
   * Destroy this context menu, releasing resources and event handlers.
   * @returns {Promise}
   */
  CommandGroupContextMenu.prototype.destroy = function () {
    var _this3 = this;
    if (this.$documentMouseDownHandler) {
      document.removeEventListener('mousedown', this.$documentMouseDownHandler);
      this.$documentMouseDownHandler = null;
    }
    var jq = this.$ed.jq();
    if (!jq) {
      return Promise.resolve();
    }
    var prom = this.$hideContextMenu();

    //HAXX: so due to swisnl/jQuery-contextMenu #447, you can't destroy "just
    // one" menu because it matches against an un-matchable selector. so we're
    // going to hack in the selector so it matches against just one element: me.
    var menu = find($.contextMenu.menus, function (menu) {
      return menu.$ref === _this3;
    });
    if (menu) {
      menu.selector = jq;
      $.contextMenu('destroy', {
        context: jq
      });
      delete menu.$ref;
    }
    return prom;
  };

  /**
   * $.contextMenu is kind enough to expose its event handlers to us, so we
   * override layerClick which is the event when we click the transparent
   * fullscreen div shown when a context menu is open.
   *
   * The default implementation of it includes a bunch of
   * repositioning/retriggering logic that works great during normal use when
   * $.contextMenu is used synchronously, but since we have to defer displaying
   * the context menu until after we've had a chance to do network calls for
   * a menu agent, it falls apart for our use case.
   *
   * So we reimplement and simplify it. When I mousedown the layer to close the
   * menu, two more events must occur. The actual context menu must be closed
   * (this happens async in the future, when $.contextMenu triggers it), and a
   * mouseup must occur. The mouseup can be on the layer (before the menu
   * closes) or on the actual click target (after the menu closes). Once both
   * happen, retrigger the events on the actual click target.
   */
  $.contextMenu.handle.layerClick = function (layerClickEvent) {
    var root = $(this).data('contextMenuRoot');
    var layer = root.$layer;
    var clickTarget = targetUnderLayerClick(layer, layerClickEvent);
    layerClickEvent.preventDefault();
    layerClickEvent.stopImmediatePropagation();
    if (!clickTarget) {
      // nothing to retrigger
      return hideContextMenu(root);
    }
    var eventsToRetrigger = ['mousedown', 'mouseup', clickName(layerClickEvent.button)];
    var mouseupOccurred = false;
    var menuHidden = false;
    var mouseup = function mouseup() {
      mouseupOccurred = true;
      tryRetriggerEvents();
      return false;
    };
    var contextMenuHidden = function contextMenuHidden() {
      menuHidden = true;
      tryRetriggerEvents();
    };
    var tryRetriggerEvents = function tryRetriggerEvents() {
      if (menuHidden && mouseupOccurred) {
        $(clickTarget).off('mouseup', mouseup);
        eventsToRetrigger.forEach(function (eventName) {
          retriggerMouseEvent(clickTarget, eventName, layerClickEvent);
        });
      }
    };
    $(clickTarget).one('mouseup', mouseup);
    layer.one('mouseup', mouseup);
    root.$trigger.one('contextmenu:hidden', contextMenuHidden);
    hideContextMenu(root);
  };
  function hideContextMenu(root) {
    root.$menu.trigger('contextmenu:hide');
  }
  function retriggerMouseEvent(target, name, originalEvent) {
    var button = originalEvent.button,
      ctrlKey = originalEvent.ctrlKey,
      clientX = originalEvent.clientX,
      clientY = originalEvent.clientY,
      screenX = originalEvent.screenX,
      screenY = originalEvent.screenY,
      shiftKey = originalEvent.shiftKey;
    var bubbles = true;
    var cancelable = true;
    var event = new MouseEvent(name, {
      bubbles: bubbles,
      button: button,
      cancelable: cancelable,
      clientX: clientX,
      clientY: clientY,
      ctrlKey: ctrlKey,
      screenX: screenX,
      screenY: screenY,
      shiftKey: shiftKey
    });
    target.dispatchEvent(event);
  }

  /**
   * @param {JQuery} layer fullscreen transparent layer behind context menu
   * @param {JQuery.Event} clickEvent
   * @returns {Element} element that wouldn't been clicked were the layer not in the way
   */
  function targetUnderLayerClick(layer, _ref8) {
    var clientX = _ref8.clientX,
      clientY = _ref8.clientY;
    var target;
    if (document.elementFromPoint) {
      layer.hide();
      target = document.elementFromPoint(clientX, clientY);
      layer.show();
    }
    return target;
  }
  function clickName(button) {
    return button === 2 ? 'contextmenu' : 'click';
  }
  function findCommandForEvent(items, event) {
    var keys = Object.keys(items);
    for (var i = 0; i < keys.length; i++) {
      var item = items[keys[i]];
      var cmd = item.cmd;
      if (cmd instanceof Command) {
        if (cmd.isAcceleratorMatch(event)) {
          return cmd;
        }
      }
      if (item.items) {
        var _cmd = findCommandForEvent(item.items, event);
        if (_cmd) {
          return _cmd;
        }
      }
    }
  }
  return CommandGroupContextMenu;
});
