function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/links/RelatePad
 */
define(['baja!', 'lex!webEditors', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/htmlUtils', 'css!nmodule/webEditors/rc/fe/webEditors-structure'], function (baja, lexs, spandrel, Widget, Command, CommandButton, feDialogs, htmlUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var SOURCES_TEXT = webEditorsLex.getSafe('RelatePad.sources');
  var TARGETS_TEXT = webEditorsLex.getSafe('RelatePad.targets');
  var escapeHtml = htmlUtils.escapeHtml;
  /**
   * Editor for selecting a relation between components
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/webEditors/rc/wb/links/RelatePad
   */
  var RelatePad = /*#__PURE__*/function (_spandrel) {
    function RelatePad() {
      var _this;
      _classCallCheck(this, RelatePad);
      _this = _callSuper(this, RelatePad, arguments);
      _this.$swapCommand = new Command({
        module: 'webEditors',
        lex: 'commands.linking.reverse',
        func: function func() {
          return _this.$handleSwapButton();
        }
      });
      _this.validators().add(function () {
        return _this.$getRelationIdEditor().validate();
      });
      return _this;
    }

    /**
     * @private
     * @returns {module:bajaux/Widget}
     */
    _inherits(RelatePad, _spandrel);
    return _createClass(RelatePad, [{
      key: "$getRelationIdEditor",
      value: function $getRelationIdEditor() {
        return this.queryWidget('pad/relationIdEditor');
      }
    }, {
      key: "$handleSwapButton",
      value: function $handleSwapButton() {
        var _this2 = this;
        return this.$getRelationIdEditor().read().then(function (relationId) {
          var _this2$value = _this2.value(),
            targets = _this2$value.targets,
            sources = _this2$value.sources;
          return _this2.load({
            targets: sources,
            sources: targets,
            relationId: relationId
          });
        });
      }

      /**
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/links/RelatePad~RelationParams>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this$value = this.value(),
          targets = _this$value.targets,
          sources = _this$value.sources;
        return this.$getRelationIdEditor().read().then(function (relationId) {
          return {
            sources: sources,
            targets: targets,
            relationId: relationId
          };
        });
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var _this3 = this;
        return this.$getRelationIdEditor().save().then(function () {
          return _superPropGet(RelatePad, "doSave", _this3, 3)([]);
        });
      }

      /**
       * @param {module:nmodule/webEditors/rc/wb/links/RelatePad~RelationParams} relateParams
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/links/RelatePad~RelationParams>}
       * resolves to the selection from the relate pad
       */
    }], [{
      key: "doDialog",
      value: function doDialog(relateParams) {
        return feDialogs.showFor({
          title: webEditorsLex.get('RelatePad.addRelation'),
          value: relateParams,
          type: RelatePad
        });
      }
    }]);
  }(spandrel(function (_ref, _ref2) {
    var _ref$relationId = _ref.relationId,
      relationId = _ref$relationId === void 0 ? '' : _ref$relationId,
      _ref$sources = _ref.sources,
      sources = _ref$sources === void 0 ? [] : _ref$sources,
      _ref$targets = _ref.targets,
      targets = _ref$targets === void 0 ? [] : _ref$targets;
    var rootElement = _ref2.rootElement;
    var widget = Widget["in"](rootElement);
    return baja.$requireFromJsBuild('nmodule/tagdictionary/rc/RelationIdEditor', 'tagdictionary:TagDictionaryJsBuild').then(function (RelationIdEditor) {
      return {
        pad: {
          dom: '<div class="RelatePad"></div>',
          kids: {
            relateInfo: {
              dom: '<div class="flex-container"></div>',
              kids: {
                hiddenForm: {
                  dom: "<div style=\"display: none;\"><input type=\"text\" /></div>"
                },
                source: {
                  dom: "<div class=\"sources displayBox\"><div>".concat(SOURCES_TEXT, "</div></div>"),
                  kids: getDisplayNames(sources)
                },
                swap: {
                  dom: "<button class=\"ux-btn-tb js-dialog-button-swap swap\"></button>",
                  value: widget.$swapCommand,
                  type: CommandButton
                },
                target: {
                  dom: "<div class=\"targets displayBox\"><div>".concat(TARGETS_TEXT, "</div></div>"),
                  kids: getDisplayNames(targets)
                }
              }
            },
            relationIdEditor: {
              dom: '<div class="relationIdEditor"></div>',
              value: relationId,
              type: RelationIdEditor
            }
          }
        }
      };
    });
  }));
  function getDisplayNames(list) {
    return list.map(function (val) {
      return "<div>".concat(escapeHtml(val.getDisplayName()), "</div>");
    });
  }

  /**
   * @typedef {Object} module:nmodule/webEditors/rc/wb/links/RelatePad~RelationParams
   * @property {Array.<baja.Component>} sources
   * @property {Array.<baja.Component>} targets
   * @property {String} relationId
   */

  return RelatePad;
});
