function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/composite/commands/CompositeCommand
 */
define(['baja!', 'baja!baja:CompositeAction,baja:CompositeTopic', 'jquery', 'lex!workbench', 'Promise', 'underscore', 'bajaux/commands/Command'], function (baja, types, $, lexs, Promise, _, Command) {
  'use strict';

  var IN = 0,
    OUT = 1,
    batchResolve = baja.BatchResolve.resolve;
  function mapAsync(arr, func) {
    return Promise.all(arr.map(function (v) {
      return Promise["try"](function () {
        return func(v);
      });
    }));
  }
  function createComposite(editor, params) {
    var composite = editor.value(),
      table = editor.$getTable(),
      model = table.value(),
      rows = model.getRows(),
      slotsToAdd = [],
      slotsToRename = [],
      slotsToReverse = [],
      slotsToRemove = editor.$removed || [];
    _(rows).each(function (row) {
      var slot = row.getSubject();
      if (!slot.backup) {
        slotsToAdd.push(slot);
      } else if (slot.dir === slot.backup.dir && slot.backup.name !== slot.name) {
        slotsToRename.push(slot);
      } else {
        slot.backup.backup = _.clone(slot.backup);
        slotsToReverse.push(slot);
      }
    });
    return Promise.all([addCompositeSlots(composite, slotsToAdd), renameCompositeSlots(composite, slotsToRename), reverseCompositeSlots(composite, slotsToReverse), removeCompositeSlots(composite, slotsToRemove)]).then(function () {
      return reorderCompositeSlots(composite, rows);
    });
  }

  /////////////////////////////////////////////////////////////////////////////
  //Additions
  ////////////////////////////////////////////////////////////////////////////
  function addCompositeSlots(composite, slots) {
    var ords = _.map(slots, function (slot) {
        return slot.ord;
      }),
      promise = batchResolve({
        ords: ords,
        base: composite,
        lease: true
      }).then(function (br) {
        var pairs = _.zip(br.getTargetObjects(), slots),
          linkPairs = _(pairs).filter(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              target = _ref2[0],
              slot = _ref2[1];
            return slot.dir === OUT;
          }),
          knobPairs = _(pairs).filter(function (_ref3) {
            var _ref4 = _slicedToArray(_ref3, 2),
              target = _ref4[0],
              slot = _ref4[1];
            return slot.dir === IN;
          }),
          knobTargets = _(knobPairs).map(_.first),
          additionBatch = new baja.comm.Batch(),
          additionPromise = mapAsync(pairs, function (_ref5) {
            var _ref6 = _slicedToArray(_ref5, 2),
              child = _ref6[0],
              slot = _ref6[1];
            return addCompositeSlot(composite, child, slot, additionBatch);
          }).then(function () {
            //make links and knobs for the composite
            var makeConnectionsBatch = new baja.comm.Batch(),
              makeLinksPromise = mapAsync(linkPairs, function (_ref7) {
                var _ref8 = _slicedToArray(_ref7, 2),
                  source = _ref8[0],
                  slot = _ref8[1];
                return makeCompositeLink(composite, source, slot, makeConnectionsBatch);
              }),
              makeKnobsPromise = mapAsync(knobPairs, function (_ref9) {
                var _ref10 = _slicedToArray(_ref9, 2),
                  target = _ref10[0],
                  slot = _ref10[1];
                return makeCompositeKnob(target, composite, slot, makeConnectionsBatch);
              });
            makeConnectionsBatch.commit();
            return Promise.all([makeLinksPromise, makeKnobsPromise]).then(function (_ref11) {
              var _ref12 = _slicedToArray(_ref11, 2),
                incomingLinks = _ref12[0],
                outgoingLinks = _ref12[1];
              //add links and knobs to the composite
              var addConnectionsBatch = new baja.comm.Batch(),
                targetLinkPairs = _.zip(knobTargets, outgoingLinks),
                addLinksPromise = mapAsync(incomingLinks, function (link) {
                  return addLink(composite, link, addConnectionsBatch);
                }),
                addKnobsPromise = mapAsync(targetLinkPairs, function (_ref13) {
                  var _ref14 = _slicedToArray(_ref13, 2),
                    target = _ref14[0],
                    link = _ref14[1];
                  return addLink(target, link, addConnectionsBatch);
                });
              addConnectionsBatch.commit();
              return Promise.all([addLinksPromise, addKnobsPromise]);
            });
          });
        additionBatch.commit();
        return additionPromise;
      });
    return promise;
  }
  function addCompositeSlot(composite, target, slot, batch) {
    var dir = slot.dir,
      name = slot.name,
      type = slot.type,
      targetSlot = target.getSlot(slot.slot),
      flags = dir === OUT ? slot.flags | baja.Flags.READONLY : slot.flags,
      facets = target.getFacets(targetSlot) || baja.Facets.NULL,
      value;
    if (targetSlot.isAction() || targetSlot.isTopic()) {
      value = dir === IN ? baja.$('baja:CompositeAction') : baja.$('baja:CompositeTopic');
    } else {
      value = type.getInstance();
    }

    //add the slot to the composite as part of a batch
    return composite.add({
      slot: name,
      value: value,
      flags: flags,
      facets: facets,
      batch: batch
    });
  }
  function makeCompositeLink(target, source, slot, batch) {
    return target.makeLink({
      source: source,
      sourceSlot: slot.slot,
      targetSlot: slot.name,
      batch: batch
    });
  }
  function makeCompositeKnob(target, source, slot, batch) {
    return target.makeLink({
      source: source,
      sourceSlot: slot.name,
      targetSlot: slot.slot,
      batch: batch
    });
  }
  function addLink(target, link, batch) {
    return target.add({
      value: link,
      facets: baja.Facets.NULL,
      flags: baja.Flags.COMPOSITE,
      batch: batch
    });
  }

  ////////////////////////////////////////////////////////////////////////////
  //Renames
  ////////////////////////////////////////////////////////////////////////////
  function renameCompositeSlots(composite, slots) {
    var ords = _(slots).map(function (slot) {
      return slot.ord;
    });
    return batchResolve({
      ords: ords,
      base: composite,
      lease: true
    }).then(function (br) {
      var targets = br.getTargetObjects(),
        targetLinks = _.flatten(_.map(targets, function (target) {
          return target.getLinks();
        })),
        renameBatch = new baja.comm.Batch(),
        renamePromise = mapAsync(slots, function (slot) {
          var oldName = slot.backup.name,
            newName = slot.name;
          return composite.rename({
            slot: oldName,
            newName: newName,
            batch: renameBatch
          }).then(function () {
            var updateBatch = new baja.comm.Batch(),
              links = _(composite.getLinks()).filter(function (link) {
                return link.getTargetSlotName() === oldName;
              }),
              knobs = _(targetLinks).filter(function (link) {
                return link.getSourceSlotName() === oldName;
              }),
              //update the link on the composite
              linksPromise = mapAsync(links, function (link) {
                return link.set({
                  slot: 'targetSlotName',
                  value: newName,
                  batch: updateBatch
                });
              }),
              //update the link corresponding to the composite knob
              knobsPromise = mapAsync(knobs, function (link) {
                return link.set({
                  slot: 'sourceSlotName',
                  value: newName,
                  batch: updateBatch
                });
              });
            updateBatch.commit();
            return Promise.all([linksPromise, knobsPromise]);
          });
        });
      renameBatch.commit();
      return renamePromise;
    });
  }

  ////////////////////////////////////////////////////////////////////////////
  //Removals
  ////////////////////////////////////////////////////////////////////////////
  function removeCompositeSlots(composite, slots) {
    var targetToLinks = {},
      //want to use Map here but PhantomJS doesn't support it without a polyfill
      ords = _(slots).map(function (slot) {
        return slot.ord;
      });
    return batchResolve({
      ords: ords,
      base: composite,
      lease: true
    }).then(function (br) {
      var targets = br.getTargetObjects(),
        removeBatch = new baja.comm.Batch(),
        removePromise = mapAsync(slots, function (slot) {
          if (slot.dir === OUT) {
            //remove links
            var removeLinksPromise = mapAsync(composite.getLinks(slot.name), function (link) {
              return composite.remove({
                slot: link.getPropertyInParent(),
                batch: removeBatch
              });
            });
            return Promise.all([removeLinksPromise, composite.remove({
              slot: slot.name,
              batch: removeBatch
            })]);
          } else {
            //remove knobs
            _(targets).each(function (target) {
              targetToLinks[target] = _(target.getLinks()).filter(function (link) {
                return link.getSourceSlotName() === slot.name;
              });
            });
            return mapAsync(targets, function (target) {
              var targetLinks = targetToLinks[target],
                removeTargetLinksPromise = mapAsync(targetLinks, function (link) {
                  return target.remove({
                    slot: link.getPropertyInParent(),
                    batch: removeBatch
                  });
                });
              return Promise.all([removeTargetLinksPromise, composite.remove({
                slot: slot.name,
                batch: removeBatch
              })]);
            });
          }
        });
      removeBatch.commit();
      return removePromise;
    });
  }
  function reverseCompositeSlots(composite, slots) {
    return removeCompositeSlots(composite, _(slots).map(function (slot) {
      return slot.backup;
    })).then(function () {
      return addCompositeSlots(composite, slots);
    });
  }
  function reorderCompositeSlots(composite, rows) {
    var list = _(rows).map(function (row) {
        return row.getSubject().name;
      }),
      slots = composite.getSlots().toArray();
    _(slots).each(function (slot) {
      var slotName = slot.getName();
      if (!(slot.isFrozen() || _(list).find(function (name) {
        return slotName === name;
      }))) {
        list.push(slotName);
      }
    });
    return composite.reorder(list);
  }

  /**
   * CompositeCommand
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/composite/commands/CompositeCommand
   */
  var CompositeCommand = /*#__PURE__*/function (_Command) {
    function CompositeCommand(editor) {
      _classCallCheck(this, CompositeCommand);
      return _callSuper(this, CompositeCommand, [{
        func: function func(params) {
          return createComposite(editor, params);
        }
      }]);
    }
    _inherits(CompositeCommand, _Command);
    return _createClass(CompositeCommand);
  }(Command);
  return CompositeCommand;
});
