function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/PasteSpecialCommand
 */
define(['baja!', 'lex!bajaui,webEditors', 'bajaux/commands/Command', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/util/TransferDataManager'], function (baja, lexs, Command, Promise, feDialogs, compUtils, TransferDataManager) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    bajauiLex = _lexs[0],
    webEditorsLex = _lexs[1];
  var formatDisplayNames = compUtils.formatDisplayNames,
    getDisplayName = compUtils.getDisplayName;

  /**
   * Command to paste with additional options.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/commands/PasteSpecialCommand
   * @extends module:bajaux/commands/Command
   */
  var PasteSpecialCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {baja.Component|baja.NavNode} subject the node to paste into
     */
    function PasteSpecialCommand(subject) {
      var _this;
      _classCallCheck(this, PasteSpecialCommand);
      _this = _callSuper(this, PasteSpecialCommand, [{
        module: 'webEditors',
        lex: 'commands.pasteSpecial',
        undoable: function undoable(params) {
          return _this.$makeUndoable(subject, params);
        }
      }]);
      _this.$subject = subject;
      return _this;
    }

    /**
     * @private
     * @param {baja.NavNode} subject
     * @param {object} params
     * @returns {Promise.<module:bajaux/commands/Command~Undoable>}
     */
    _inherits(PasteSpecialCommand, _Command);
    return _createClass(PasteSpecialCommand, [{
      key: "$makeUndoable",
      value: function $makeUndoable(subject, params) {
        return this.$getPasteSpecialParams(params).then(function (dialogParams) {
          if (!dialogParams) {
            return;
          }
          var transferParams = dialogParams.transferParams,
            displayNames = dialogParams.displayNames;
          var transferMgr = TransferDataManager.getInstance();
          var getText = function getText(key) {
            return webEditorsLex.get({
              key: key,
              args: [formatDisplayNames(displayNames), getDisplayName(subject)]
            });
          };
          var undoKey;
          return {
            redo: function redo() {
              return transferMgr.paste(subject, transferParams).then(function (pasteResults) {
                undoKey = pasteResults.undoKey;
              });
            },
            undo: function undo() {
              return baja.transfer.undo({
                undoKey: undoKey
              });
            },
            redoText: function redoText() {
              return getText('commands.paste.copy.redoText');
            },
            undoText: function undoText() {
              return getText('commands.paste.copy.undoText');
            }
          };
        });
      }

      /**
       * @private
       * @returns {Promise.<{ transferParams: PasteSpecialParams, displayNames: string[] }|undefined>}
       */
    }, {
      key: "$getPasteSpecialParams",
      value: function $getPasteSpecialParams() {
        var _this2 = this;
        var cmdParams = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var _cmdParams$origin = cmdParams.origin,
          origin = _cmdParams$origin === void 0 ? 'compute' : _cmdParams$origin;
        return this.$verifyClipboard().then(function (displayNames) {
          return _this2.$promptForParams().then(function (dialogParams) {
            if (!dialogParams) {
              return;
            }
            return {
              transferParams: Object.assign({
                origin: origin
              }, dialogParams),
              displayNames: displayNames
            };
          });
        });
      }

      /**
       * @private
       * @returns {Promise.<object|null>} to be resolved with user-entered params
       * for the paste
       */
    }, {
      key: "$promptForParams",
      value: function $promptForParams() {
        var comp = baja.$('baja:Component', {
          numCopies: baja.Integer.make(1),
          keepLinks: false,
          keepRelations: false
        });
        comp.add({
          slot: 'displayNames',
          value: baja.NameMap.make({
            numCopies: bajauiLex.get('pasteSpecial.numCopies'),
            keepLinks: bajauiLex.get('pasteSpecial.keepAllLinks'),
            keepRelations: bajauiLex.get('pasteSpecial.keepAllRelations')
          }),
          flags: baja.Flags.HIDDEN
        });
        return this.toDisplayName().then(function (displayName) {
          return feDialogs.showFor({
            title: displayName,
            type: 'nmodule/webEditors/rc/wb/PropertySheet',
            value: comp,
            properties: {
              showHeader: false
            }
          });
        }).then(function (result) {
          if (result === null) {
            return null;
          }
          return {
            numCopies: +comp.get('numCopies'),
            keepLinks: comp.get('keepLinks'),
            keepRelations: comp.get('keepRelations')
          };
        });
      }

      /**
       * @private
       * @returns {Promise.<string>} to be resolved with display names to be
       * pasted, if clipboard is valid
       */
    }, {
      key: "$verifyClipboard",
      value: function $verifyClipboard() {
        var transferMgr = TransferDataManager.getInstance();
        return Promise.all([transferMgr.getClipboard(), transferMgr.getClipboardOp()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            clipboard = _ref2[0],
            clipboardOp = _ref2[1];
          if (!clipboard) {
            throw new Error(bajauiLex.get('command.paste.emptyClipboard'));
          }
          if (clipboardOp === 'move') {
            throw new Error(bajauiLex.get('pasteSpecial.copyOnly'));
          }
          var nodes = JSON.parse(clipboard);
          return nodes.map(function (node) {
            return node.displayName;
          });
        });
      }
    }]);
  }(Command);
  /**
   * @private
   * @typedef {object} PasteSpecialParams
   * @property {number} numCopies
   * @property {boolean} keepLinks
   * @property {boolean} keepRelations
   * @property {string} [origin]
   */
  return PasteSpecialCommand;
});
