function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/PasteCommand
 */
define(['baja!', 'lex!bajaui,webEditors', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/util/TransferDataManager'], function (baja, lexs, Promise, _, Command, feDialogs, compUtils, TransferDataManager) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    bajauiLex = _lexs[0],
    webEditorsLex = _lexs[1];
  var extend = _.extend;
  var formatDisplayNames = compUtils.formatDisplayNames,
    getDisplayName = compUtils.getDisplayName,
    getUniqueName = compUtils.getUniqueName,
    promptForSlotName = compUtils.promptForSlotName;

  /**
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/PasteCommand
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {baja.NavNode|Array.<baja.NavNode>|Object|Array.<Object>} subject the object into
     * which we're pasting. If this is an array, only the *first* object will be pasted into.
     * @param {module:nmodule/webEditors/rc/wb/util/TransferWidget} [transferWidget]
     */
    function PasteCommand(subject, transferWidget) {
      var _this;
      _classCallCheck(this, PasteCommand);
      var params = {
        module: 'webEditors',
        lex: 'commands.paste'
      };
      if (transferWidget && transferWidget.insertTransferData) {
        params.func = function (params) {
          return _this.$funcWithInsertTransferData(params);
        };
      } else {
        params.undoable = function (params) {
          return _this.$makeUndoable(params);
        };
      }
      _this = _callSuper(this, PasteCommand, [params]);
      _this.$subject = Array.isArray(subject) ? subject[0] : subject;
      _this.$transferWidget = transferWidget;
      return _this;
    }

    /**
     * @private
     * @param {object} transferParams
     * @returns {Promise}
     */
    _inherits(PasteCommand, _Command);
    return _createClass(PasteCommand, [{
      key: "$funcWithInsertTransferData",
      value: function $funcWithInsertTransferData(transferParams) {
        var _this2 = this;
        return this.$getPasteParams(transferParams).then(function (pasteParams) {
          if (!pasteParams) {
            return;
          }
          var transferParams = pasteParams.transferParams,
            mark = pasteParams.mark;
          var subject = _this2.$subject;
          var transferWidget = _this2.$transferWidget;
          transferParams.transferWidget = transferWidget;
          return transferWidget.insertTransferData(subject, Object.assign(transferParams, {
            mark: mark
          }));
        });
      }

      /**
       * @private
       * @param {object} transferParams
       * @returns {Promise.<module:bajaux/commands/Command~Undoable>}
       */
    }, {
      key: "$makeUndoable",
      value: function $makeUndoable(transferParams) {
        var _this3 = this;
        return this.$getPasteParams(transferParams).then(function (pasteParams) {
          if (!pasteParams) {
            return;
          }
          var transferParams = pasteParams.transferParams,
            mark = pasteParams.mark;
          var op = mark.op,
            nodes = mark.nodes;
          var sourceNames = nodes.map(function (node) {
            return node.displayName;
          });
          var transferDataManager = TransferDataManager.getInstance();
          var subject = _this3.$subject;
          var getText = function getText(suffix) {
            return webEditorsLex.get({
              key: "commands.paste.".concat(op, ".").concat(suffix),
              args: [formatDisplayNames(sourceNames), getDisplayName(subject)]
            });
          };
          var undoKey;
          return {
            redo: function redo() {
              return transferDataManager.paste(subject, Object.assign(transferParams, {
                mark: mark
              })).then(function (pasteResult) {
                undoKey = pasteResult.undoKey;
              });
            },
            undo: function undo() {
              return baja.transfer.undo({
                undoKey: undoKey
              });
            },
            redoText: function redoText() {
              return getText('redoText');
            },
            undoText: function undoText() {
              return getText('undoText');
            }
          };
        });
      }

      /**
       * @private
       * @param {object} transferParams base transfer params
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/commands/PasteCommand~PasteParams>}
       */
    }, {
      key: "$getPasteParams",
      value: function $getPasteParams() {
        var _this4 = this;
        var transferParams = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var transferDataManager = TransferDataManager.getInstance();
        return transferDataManager.$getPasteMark().then(function (mark) {
          if (!mark) {
            throw new Error(bajauiLex.get('command.paste.emptyClipboard'));
          }
          var nodes = mark.nodes,
            op = mark.op;
          if (nodes.length > 1 || op === 'move') {
            return {
              transferParams: transferParams,
              mark: mark
            };
          } else {
            //If a transferWidget is provided, it is responsible for any prompts it may need
            var transferWidget = _this4.$transferWidget;
            if (transferWidget && transferWidget.insertTransferData) {
              return {
                transferParams: transferParams,
                mark: mark
              };
            }
            TransferDataManager.requireNavNodeJsonArray(nodes);
            return _this4.$promptForSlotName(_this4.$getUniqueName(nodes[0].name)).then(function (newName) {
              if (newName === null) {
                return;
              }
              return {
                transferParams: extend({
                  names: [newName]
                }, transferParams),
                mark: mark
              };
            });
          }
        });
      }

      /**
       * @param {string} defaultName initial name to show to the user
       * @returns {Promise.<string|null>} the slot name provided by the user, or
       * null if the user canceled the prompt
       */
    }, {
      key: "$promptForSlotName",
      value: function $promptForSlotName(defaultName) {
        return promptForSlotName(defaultName);
      }

      /**
       * @private
       * @param {String} slotName The valid slot name of the copied component
       * @returns {String}
       */
    }, {
      key: "$getUniqueName",
      value: function $getUniqueName(slotName) {
        return getUniqueName(this.$subject, slotName);
      }
    }]);
  }(Command);

  /**
   * @typedef {object} module:nmodule/webEditors/rc/wb/commands/PasteCommand~PasteParams
   * @property {module:nmodule/webEditors/rc/wb/util/TransferDataManager~PasteMark} mark
   * @property {object} transferParams to be passed to `baja.transfer`
   */
});
