/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/LogoutCommand
 */
define(['bajaux/commands/Command', 'lex!webEditors', 'dialogs', 'nmodule/js/rc/csrf/csrfUtil'], function (Command, lexs, dialogs, csrfUtil) {
  'use strict';

  var webEditorsLex = lexs[0];

  /**
   * A command for logging out
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/LogoutCommand
   */
  var LogoutCommand = function LogoutCommand() {
    var niagara = window.niagara;
    var user = niagara && niagara.env && niagara.env.user ? niagara.env.user : webEditorsLex.get("commands.logout.fallbackUser");
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.logout',
      description: webEditorsLex.get("commands.logout.description", user),
      /**
       * Asks the user to log off. If yes the user is logged off.
       *
       * @alias module:nmodule/webEditors/rc/wb/commands/LogoutCommand#invoke
       */
      func: function func(location) {
        return dialogs.showYesNo(webEditorsLex.get("logoff.question")).yes(function () {
          (location || window.location).assign("/logout?csrfToken=" + csrfUtil.getCsrfToken());
        }).promise();
      }
    });
  };
  LogoutCommand.prototype = Object.create(Command.prototype);
  LogoutCommand.prototype.constructor = LogoutCommand;
  return LogoutCommand;
});
