function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/UserManager
 */
define(['log!nmodule.webEditors.rc.wb.UserManager', 'bajaux/mixin/subscriberMixIn', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/registry/StationRegistry', 'nmodule/webEditors/rc/servlets/password', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/mgr/commands/NewCommand', 'nmodule/webEditors/rc/wb/util/user/UserManagerMgrModel'], function (log, subscribable, Promise, _, DepthSubscriber, typeUtils, StationRegistry, password, componentStatusUtils, Manager, NewCommand, UserManagerMgrModel) {
  'use strict';

  var once = _.once;
  var addComponentStatusCss = componentStatusUtils.addComponentStatusCss;
  var getSuperTypeChain = typeUtils.getSuperTypeChain;
  var TYPES_TO_PRELOAD = ['baja:PasswordAuthenticator', 'baja:UserPasswordConfiguration', 'web:WebProfileConfig', 'web:MobileWebProfileConfig', 'webEditors:AuthenticationSchemeEditor', 'webEditors:ExpirationEditor', 'webEditors:RolesEditor', 'webEditors:TimeFormatEditor', 'webEditors:UserFacetsEditor', 'webEditors:UserPasswordEditor', 'webEditors:UserPrototypeEditor'];
  var logError = log.severe.bind(log);

  //TODO: this should be more service-oriented in future.
  /**
   * As soon as the UserManager starts initializing, it will kick off a request
   * to import all the types its Edit dialog needs, then pre-populate the
   * StationRegistry with JS and agent registration info. This avoids multiple
   * hits to the registry servlets as the Edit property sheet loads, layer by
   * layer.
   *
   * @inner
   * @returns {Promise}
   */
  function preloadTypes() {
    return typeUtils.importTypes(TYPES_TO_PRELOAD).then(function (types) {
      var superTypes = _.flatten(_.map(types, getSuperTypeChain)),
        typeSpecs = _.unique(_.map(superTypes, String)),
        reg = StationRegistry.getInstance();
      return Promise.all(_.map(typeSpecs, function (typeSpec) {
        return reg.queryAll(typeSpec);
      }));
    });
  }

  ////////////////////////////////////////////////////////////////
  // UserManager
  ////////////////////////////////////////////////////////////////

  /**
   * User Manager.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/UserManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   * @param {Object} [params]
   */
  var UserManager = function UserManager(params) {
    var _this = this;
    Manager.call(this, _.extend({
      moduleName: 'webEditors',
      keyName: 'UserManager'
    }, params));
    this.$subscribeDefaultPrototype = once(function () {
      var sub = _this.$defaultPrototypeSubscriber = new DepthSubscriber(Number.MAX_VALUE);
      return sub.subscribe(_this.value().get('userPrototypes').get('defaultPrototype'));
    });
    this.$subscriber = new DepthSubscriber(3);
    subscribable(this);
  };
  UserManager.prototype = Object.create(Manager.prototype);
  UserManager.prototype.constructor = UserManager;

  ////////////////////////////////////////////////////////////
  //Context Menu Support
  ////////////////////////////////////////////////////////////

  /**
   * Trigger context menus specifically on table row right clicks
   * @override
   * @returns {string}
   */
  UserManager.prototype.getContextMenuSelector = function () {
    return 'tr';
  };

  /////////////////////////////////////////////////////////////////

  /**
   * Disable the New command if we can't safely send a new user's password to the station.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  UserManager.prototype.doInitialize = function (dom) {
    var that = this;
    preloadTypes()["catch"](logError); //kick off types we know we need
    return Manager.prototype.doInitialize.apply(that, arguments);
  };

  /**
   * @private
   * @returns {Promise.<boolean>}
   */
  UserManager.prototype.$secureToSendPasswords = function () {
    return password.$isSecure();
  };

  /**
   * Create a `UserManagerMgrModel` instance with the appropriate columns.
   *
   * @param {baja.Component} userService
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/util/user/UserManagerMgrModel>}
   */
  UserManager.prototype.makeModel = function (userService) {
    return UserManagerMgrModel.make(userService);
  };

  /**
   * @returns {Promise}
   */
  UserManager.prototype.makeCommands = function () {
    var that = this;
    return Promise.all([Manager.prototype.makeCommands.apply(this, arguments), this.$secureToSendPasswords()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        commands = _ref2[0],
        secure = _ref2[1];
      var newCommand = commands.find(function (cmd) {
        return cmd instanceof NewCommand;
      });
      var invoke = newCommand.invoke;
      newCommand.setEnabled(secure);
      newCommand.invoke = function () {
        var _arguments = arguments,
          _this2 = this;
        return that.$subscribeDefaultPrototype().then(function () {
          return invoke.apply(_this2, _arguments);
        });
      };
      return commands;
    });
  };

  /**
   * Unsubscribe from all Components under
   * UserService -> User Prototypes -> Default Prototype on destroy.
   *
   * @returns {Promise}
   */
  UserManager.prototype.doDestroy = function () {
    var dps = this.$defaultPrototypeSubscriber;
    return Promise.all([dps && dps.unsubscribeAll(), Manager.prototype.doDestroy.apply(this, arguments)]);
  };

  /**
   * Overrides the default onMainTableDblClicked logic and invokes the EditCommand
   * @inheritDoc
   */
  UserManager.prototype.onMainTableDblClicked = function (event, subjects) {
    return this.$getEditCommand().invoke();
  };

  /**
   * In addition to the standard logic, this enables/disables the EditCommand based on the selected
   *  rows
   * @inheritDoc
   */
  UserManager.prototype.onTableSelectionChanged = function (selectedSubjects) {
    var _this3 = this;
    return Manager.prototype.onTableSelectionChanged.call(this, arguments).then(function () {
      var mainTableSelection = selectedSubjects.mainTableSelection;
      var editCmd = _this3.$getEditCommand();
      editCmd.setEnabled(!(mainTableSelection.length === 0));
    });
  };

  /**
   * Overrides the basic manager `#finishMainTableRow` function with some extra css information
   * specified on the dom for the table row.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row a table row instance
   * @param {JQuery} dom
   * @returns {Promise<JQuery>}
   */
  UserManager.prototype.finishMainTableRow = function (row, dom) {
    var subject = row.getSubject();
    var status = subject.getStatus();
    addComponentStatusCss(status, dom);
    return Promise.resolve(dom);
  };
  return UserManager;
});
