function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/*eslint-env browser */ /*jshint browser: true */
/* global $interop_download */

define(['baja!', 'dialogs', 'lex!webEditors', 'log!nmodule.webEditors.rc.util.fileUtils', 'jquery', 'Promise', 'nmodule/js/rc/csrf/csrfUtil'], function (baja, dialogs, lexes, log, $, Promise, csrfUtil) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var _lexes = _slicedToArray(lexes, 1),
    webEditorsLex = _lexes[0];
  var CSRF_TOKEN_HEADER_KEY = csrfUtil.CSRF_TOKEN_HEADER_KEY,
    getCsrfToken = csrfUtil.getCsrfToken;

  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/util/fileUtils
   */
  var exports = {};

  /**
   * @private
   */
  exports.$getDownloadConfig = function (fileContents, fileName, mimeType) {
    var blob = exports.$createBlob([fileContents], {
      type: mimeType
    });
    return {
      blob: blob,
      link: exports.$getAnchor(URL.createObjectURL(blob), fileName)
    };
  };

  /**
   * @private
   */
  exports.$getAnchor = function (link, fileName) {
    return $("<a/>").attr('href', link).attr('download', fileName).attr('target', '_top');
  };

  /**
   * @param {string|baja.Ord} ord
   * @returns {Promise}
   * @since Niagara 4.15
   */
  exports.deleteFile = function (ord) {
    return baja.rpc('type:web:FileRpc', 'deleteFile', String(ord));
  };

  /**
   * Attempt to download the file with the given type, name, and contents in various browsers.
   *
   * @param {string} fileContents
   * @param {string} fileName
   * @param {string} mimeType
   */
  exports.download = function (fileContents, fileName, mimeType) {
    //This function is injected by Workbench when using JavaFx Browser.
    // eslint-disable-next-line camelcase
    if (typeof $interop_download === 'function') {
      $interop_download({
        type: 'blob',
        fileContents: fileContents,
        fileName: fileName
      });
    } else if (window.navigator && typeof window.navigator.msSaveBlob === 'function') {
      window.navigator.msSaveBlob(exports.$createBlob([fileContents]), fileName);
    } else {
      var _exports$$getDownload = exports.$getDownloadConfig(fileContents, fileName, mimeType),
        link = _exports$$getDownload.link,
        blob = _exports$$getDownload.blob;
      downloadClick(link);
      URL.revokeObjectURL(blob);
    }
  };

  /**
   * @param {string} url - Direct download url
   * @param {string} fileName
   */
  exports.directDownload = function (url, fileName) {
    //This function is injected by Workbench when using JavaFx Browser.
    // eslint-disable-next-line camelcase
    if (typeof $interop_download === 'function') {
      $interop_download({
        type: 'resolve',
        url: url,
        fileName: fileName
      });
    } else {
      var link = exports.$getAnchor(url, fileName);
      downloadClick(link);
    }
  };
  function downloadClick(a) {
    var clickEvent = window.document.createEvent("MouseEvent");
    clickEvent.initEvent("click", true, true);
    if (a.get(0)) {
      a.get(0).dispatchEvent(clickEvent);
    }
  }

  /**
   * Attempt to create a blob the normal way; fallback to BlobBuilder for Environments like PhantomJs.
   * @private
   * @param {Object} parts
   * @param {Object} [properties]
   * @returns {Blob}
   */
  exports.$createBlob = function (parts, properties) {
    parts = parts || [];
    properties = properties || {};
    try {
      return new Blob(parts, properties);
    } catch (e) {
      if (e.name !== "TypeError") {
        throw e;
      }
      var BlobBuilder = window.BlobBuilder || window.MSBlobBuilder || window.MozBlobBuilder || window.WebKitBlobBuilder;
      var builder = new BlobBuilder();
      for (var i = 0; i < parts.length; i++) {
        builder.append(parts[i]);
      }
      return builder.getBlob(properties.type);
    }
  };

  /**
   * Determines whether the file with the given ord exists on the station or not.
   * @param {String|baja.Ord} ord
   * @returns {Promise.<boolean>}
   */
  exports.exists = function (ord) {
    return baja.rpc({
      typeSpec: 'web:FileRpc',
      method: 'exists',
      args: [String(ord)]
    })["catch"](function (ignore) {
      return false;
    });
  };

  /**
   * Determines whether or not we are allowed to write to the given file on the
   * server. If the file does not exist or the user indicates they want to
   * overwrite the file, resolves true. Otherwise resolves false.
   *
   * @param {String} ord the ord pointing to the desired write location
   * @returns {Promise.<boolean>} resolves true if OK with the user to write to
   * this file.
   */
  exports.confirmServerFileWrite = function (ord) {
    return exports.exists(ord).then(function (fileExists) {
      // TODO: Distinguish between recoverable (user clicked no) and unrecoverable errors
      return !fileExists || exports.$userConfirmsOverwrite();
    });
  };

  /**
   * @private
   * @returns {Promise<boolean>} resolves to true if the user clicks yes
   * to the "overwrite?" dialog
   */
  exports.$userConfirmsOverwrite = function () {
    var result;
    return dialogs.showYesNo({
      title: webEditorsLex.get("export.duplicateFile.title"),
      text: webEditorsLex.get("export.duplicateFile.content"),
      yes: function yes() {
        result = true;
      },
      no: function no() {
        result = false;
      }
    }).promise().then(function () {
      return result;
    });
  };

  /**
   * @param {String} ord file ORD to write to
   * @returns {Promise.<boolean>} to be resolved with true, if the user has
   * permissions to write this file
   */
  exports.isWritable = function (ord) {
    return baja.rpc({
      typeSpec: 'web:FileRpc',
      method: 'isWritable',
      args: [ord]
    });
  };

  /**
   * Uploads the file to Station file space.
   * @param {string|baja.Ord} fileOrd the ORD to the file to write
   * @param {*} data the contents of the file
   * @returns {Promise}
   */
  exports.upload = function (fileOrd, data) {
    var formData = new FormData();
    formData.append('ord', fileOrd);
    formData.append('content', data);
    return Promise.resolve($.ajax({
      url: '/file',
      headers: _defineProperty({}, CSRF_TOKEN_HEADER_KEY, getCsrfToken()),
      data: formData,
      contentType: false,
      processData: false,
      method: 'POST'
    }));
  };

  /**
   * Makes a directory on the Station's file space
   * @param {Object} params the parameters necessary to make a new directory
   * @param {String} params.targetDirOrd the ord of the target directory for the new directory
   * @param {String} params.newDir the name of the new directory to be created
   * @returns {Promise}
   */
  exports.makeDir = function (params) {
    var targetDirOrd = params.targetDirOrd,
      newDir = params.newDir;
    return baja.rpc({
      typeSpec: 'web:FileRpc',
      method: 'makeDir',
      args: [targetDirOrd, newDir]
    });
  };

  /**
   * Get a unique directory/file name in a directory
   * @param {Object} params the parameters necessary to get an
   * @param {String} params.targetDirOrd the ord of the target directory for the new directory
   * @param {String} params.newDir the name of the new directory to be created
   * @returns {Promise<String>} the suggested unique file/directory name
   */
  exports.getUniqueFilename = function (params) {
    var targetDirOrd = params.targetDirOrd,
      suggestedName = params.suggestedName;
    return baja.rpc({
      typeSpec: 'web:FileRpc',
      method: 'getUniqueFilename',
      args: [targetDirOrd, suggestedName]
    });
  };

  /**
   * IsValidName is a carbon copy of java logic in baja:javax.baja.file.FilePath.isValidName()
   * @param {String} name
   * @returns {boolean}
   */
  exports.isValidName = function (name) {
    try {
      var len = name.length,
        i,
        ch;
      if (len === 0) {
        return false;
      }
      for (i = 0; i < len; ++i) {
        ch = name[i];
        if (!isName(ch) || ch === ':') {
          return false;
        }
      }
      return true;
    } catch (err) {
      logSevere(err);
      return false;
    }
  };

  /**
   * carbon copy of java logic in baja:javax.baja.file.FilePath.isName() except for additional
   * check needed for NCCB-11874: % not supported by FileServlet.
   * @param {String} c
   * @returns {boolean}
   * @private
   */
  function isName(c) {
    var code = c.charCodeAt(0);
    return !(code <= 31 ||
    // control characters
    code === 127 ||
    // del
    c === '"' || c === '\\' || c === '<' || c === '>' || c === '?' || c === '*' || c === '/' || c === '%' ||
    // TODO: NCCB-11874: % not supported by FileServlet
    c === '|');
  }
  return exports;
});
