/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

define(['baja!', 'Promise'], function (baja, Promise) {
  'use strict';

  /**
   * API Status: **Private**
   * @exports nmodule/webeditors/rc/servlets/valueDocEncodingUtil
   * @since Niagara 4.13
   */
  var exports = {};

  /**
   * Encodes a baja.Value into a XML string that represents that value
   *
   * @param {baja.Value} value the baja.Value to be encoded into XML
   * @returns {Promise.<String>} a XML string that represent the inputted value
   */
  exports.marshal = function (value) {
    var jsonObject = baja.bson.encodeValue(value);
    var bsonString = JSON.stringify(jsonObject);
    return baja.rpc({
      typeSpec: "webEditors:ValueDocEncodingUtilRpc",
      method: "marshal",
      args: [bsonString]
    });
  };

  /**
   * Decodes a XML string, converting it back into a baja.Value
   *
   * @param {String} xmlString a XML string that represents a baja.Value
   * @returns {Promise.<baja.Value>}
   */
  exports.unmarshal = function (xmlString) {
    return baja.rpc({
      typeSpec: "webEditors:ValueDocEncodingUtilRpc",
      method: "unmarshal",
      args: [xmlString]
    }).then(function (bsonString) {
      var jsonObject = JSON.parse(bsonString);
      return baja.bson.decodeAsync(jsonObject);
    });
  };
  return exports;
});
