function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara: false */

define(['baja!', 'lex!webEditors', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, lexs, $, Promise, _, TreeNode) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var PALETTE_ICON_URIS = baja.Icon.make('module://icons/x16/palette.png').getImageUris(),
    PALETTE_SERVLET_URI = '/webEditors/palette/';
  function PaletteNode(obj) {
    var kids = [];
    TreeNode.call(this, obj.n, obj.d, _.map(obj.k || [], function (kidObj) {
      var node = new PaletteNode(kidObj);
      kids.push(node.$json);
      return node;
    }));
    this.$json = {
      ord: obj.o,
      name: obj.n,
      displayName: obj.d,
      icon: obj.i,
      description: obj.e,
      typeSpec: obj.e,
      kids: kids
    };
    this.$icon = baja.Icon.make(obj.i).getImageUris();
  }
  PaletteNode.prototype = Object.create(TreeNode.prototype);
  PaletteNode.prototype.constructor = PaletteNode;
  PaletteNode.prototype.getIcon = function () {
    return this.$icon;
  };
  PaletteNode.prototype.value = function () {
    return this.$json;
  };
  PaletteNode.prototype.isDraggable = function () {
    return true;
  };

  //TODO: add java.awt.headless=true to unit tests

  function cacheBuster() {
    if (typeof niagara === 'undefined') {
      return '';
    }
    return '?regLastBuildTime=' + niagara.env.regLastBuildTime;
  }
  function getPaletteIcon() {
    return PALETTE_ICON_URIS;
  }
  function moduleNamesToUri(moduleNames) {
    return PALETTE_SERVLET_URI + 'get/' + moduleNames.join() + cacheBuster();
  }
  function doGetPalettes(moduleNames) {
    return Promise.resolve($.get(moduleNamesToUri(moduleNames)));
  }
  function doGetList() {
    return Promise.resolve($.get(PALETTE_SERVLET_URI + 'list' + cacheBuster()));
  }
  function toPaletteObjectNode(obj) {
    return new PaletteNode(obj);
  }
  function toPaletteModuleNode(obj) {
    var moduleName = obj.n,
      encodedNavNodes = obj.v,
      kidNodes = _.map(encodedNavNodes, toPaletteObjectNode),
      node = new TreeNode(moduleName, moduleName, kidNodes);
    node.getIcon = getPaletteIcon;
    return node;
  }

  /**
   * API Status: **Private**
   *
   * Functions for retrieving palette data from the station.
   *
   * This module communicates with the following servlets:
   *
   * - `com.tridium.webeditors.ux.servlets.PaletteServlet`
   *
   * @exports nmodule/webEditors/rc/servlets/palette
   */
  var exports = {};

  //TODO: make this data-only and move TreeNode generation to PaletteNavTree
  /**
   * Retrieve palette data from the station for the requested modules.
   *
   * @param {Array.<String>} moduleNames names of modules to retrieve palette
   * data for
   * @returns {Promise} promise to be resolved with a single
   * {@link module:nmodule/webEditors/rc/wb/tree/TreeNode}, with one child per
   * requested module
   */
  exports.getPalettes = function (moduleNames) {
    if (!Array.isArray(moduleNames)) {
      return Promise.reject(new Error('array required'));
    }
    return doGetPalettes(moduleNames).then(function (data) {
      var nodesForEachPalette = _.map(data, toPaletteModuleNode);
      return new TreeNode('Palette', 'Palette', nodesForEachPalette);
    })["catch"](function () {
      throw new Error(webEditorsLex.get('commands.addPalette.error'));
    });
  };

  /**
   * List palette data for all modules on the station that have them. Resolves
   * an array of objects, each with the following properties:
   *
   * - `d`: the module description
   * - `n`: the module name
   *
   * @returns {Promise} promise to be resolved with an array of palette data
   * objects
   */
  exports.list = function () {
    return doGetList();
  };
  return exports;
});
