function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/config/CompositeBuilder
 */
define(['jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe'], function ($, Promise, _, BaseWidget, fe) {
  'use strict';

  /**
   * Error to indicate failure performing some composite action like read all,
   * save all, etc.
   * @class
   * @extends Error
   * @param {Object} map builder key -> error map
   */
  function CompositeError(map) {
    this.map = map;
    this.message = _.map(map, function (value, key) {
      var str = value instanceof Error ? value.message : value;
      return key + ': ' + str;
    }).join(', ');
  }
  CompositeError.prototype = Object.create(Error.prototype);
  CompositeError.prototype.constructor = CompositeError;
  CompositeError.prototype.name = 'CompositeError';
  CompositeError.prototype.toString = function () {
    return this.message;
  };
  function applyParams(ed, params) {
    return BaseWidget.prototype.applyParams.call(ed, params);
  }

  /**
   * A `CompositeBuilder` is an abstraction for managing the instantiation,
   * initialization, and loading of multiple `Widget`s and managing them as a
   * group.
   *
   * A very common use case will be managing one widget per slot on a Component.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/config/CompositeBuilder
   * @param {Object} [params]
   * @param {*} [params.dataSource] specify an optional data source for this
   * builder. This might be a Component, an Array, or omitted as needed by
   * subclasses, as long as the necessary abstract functions are implemented
   * properly.
   * @param {boolean} [params.removeOnDestroy=true] if set to `false`, DOM
   * elements created in `getDomFor`, in which child editors are initialized,
   * will stick around in the DOM even after the corresponding editors are
   * destroyed. If `true` (the default), destroying a child editor (with
   * `destroyFor`) will also remove its DOM element.
   * @param {boolean} [params.reorderDomForKeys=false] if set to `true` and if `removeOnDestroy` is also false, DOM
   * elements created in `getDomFor` will be reordered to keep the same order as the order that the keys have been provided.
   * If any of the `getDomFor` results do not have the same parent, then the dom elements will not be reordered.
   */
  var CompositeBuilder = function CompositeBuilder(params) {
    params = params || {};
    this.$map = {};
    this.$domMap = {};
    this.$dataSource = params.dataSource || null;
    this.$removeOnDestroy = params.removeOnDestroy !== false;
    this.$reorderDomForKeysEnabled = params.reorderDomForKeys === true;
  };
  CompositeBuilder.$CompositeError = CompositeError;
  CompositeBuilder.toCssClass = function (key) {
    return 'key-' + String(key).replace(/\$/g, '_');
  };

  /**
   * Get the current data source for this builder.
   *
   * @returns {*}
   */
  CompositeBuilder.prototype.getDataSource = function () {
    return this.$dataSource;
  };

  /**
   * Sets the data source for this builder.
   *
   * @param {*} [dataSource]
   * @returns {Promise}
   */
  CompositeBuilder.prototype.setDataSource = function (dataSource) {
    this.$dataSource = dataSource;
    return Promise.resolve();
  };

  /**
   * Each widget in the group should be identifiable by a string key. This
   * function should return an array of all keys that the `CompositeBuilder`
   * knows about, and each key should map to a single `Widget` instance. Or it
   * may return a promise that resolves to the same.
   *
   * @abstract
   * @returns {Array.<String>|Promise.<Array.<String>>} array of known keys, or promise that
   * resolves to same. If not overridden this method will reject.
   */
  CompositeBuilder.prototype.getKeys = function () {
    return Promise.reject(new Error('getKeys not implemented'));
  };

  /**
   * Widgets will be instantiated using the `fe` module. Given a key, it should
   * return an object literal describing what kind of `Widget` should be
   * instantiated for that key. This object literal will be passed to
   * `fe.makeFor`.
   *
   * If the resultant config object has a `dom` property, note that it will
   * be overridden using the results of `getDomFor()`. Use this function to
   * specify things like `type`, `readonly`, etc.
   *
   * If implementing this function, ensure the object literal resolved has
   * either a `value` property or `complex` and `slot` properties, as required
   * by `fe`.
   *
   * By default, returns `undefined`.
   *
   * @param {String} key
   * @returns {Object|Promise|undefined} config object, or promise to be
   * resolved with same. Resolve `undefined` to have `fe` simply build the
   * default editor for that value.
   */
  CompositeBuilder.prototype.getConfigFor = function (key) {};

  /**
   * Get a display name for the requested widget.
   *
   * @param key
   * @returns {Promise|String|null} display name for the widget for the
   * given key (or promise to be resolved with same), or null if key not found
   */
  CompositeBuilder.prototype.getDisplayNameFor = function (key) {
    var ed = this.getEditorFor(key);
    return ed ? ed.toDisplayName() : null;
  };

  /**
   * Each Widget will need to be initialized in a DOM element. Given a key,
   * this should return the DOM element in which the widget for that key
   * should be initialized.
   *
   * @abstract
   * @param {String} key
   * @returns {Promise|jQuery} the dom element for the given key (or
   * promise to be resolved with same)
   * @throws {Error} if not implemented
   */
  CompositeBuilder.prototype.getDomFor = function (key) {
    throw new Error('getDomFor not implemented');
  };

  /**
   * Make sure that the DOM for the given key is present and accounted for
   * before we begin the process of making/initializing the editors. This
   * ensures that the DOM elements are created in order.
   *
   * @private
   * @param {String} key
   * @returns {Promise} promise to be resolved with the preloaded DOM
   */
  CompositeBuilder.prototype.$preloadDomFor = function (key) {
    var that = this,
      domMap = that.$domMap,
      dom = getOwnProperty(domMap, key);
    return dom ? Promise.resolve(dom) : Promise.resolve(that.getDomFor(key)).then(function (dom) {
      return domMap[key] = dom;
    });
  };

  /**
   * This method will reorder the dom elements when the order of the keys in the dom and the order for the `getKeys()` results
   * do not match up. Note that reordering will keep any keyless dom elements after their key element. Since there can
   * be extra dom elements when the removeOnDestroy property is set to false, reordering is not supported in this mode.
   * If any of the dom elements associated with a key have a missing or different parent, then no reorder will happen either.
   *
   * @private
   * @since Niagara 4.15
   */
  CompositeBuilder.prototype.$reorderDomForKeys = function () {
    var _this = this;
    if (!this.$removeOnDestroy || !this.$reorderDomForKeysEnabled) {
      return Promise.resolve();
    }
    return Promise.resolve(this.getKeys()).then(function (keys) {
      var parentJq;
      var parent;
      var domMap = _this.$domMap;
      var reorderedRequired = false;
      var newKids = [];
      var differentParents = false;
      _.each(keys, function (key) {
        var kidJq = getOwnProperty(domMap, key);
        var kid = kidJq[0];
        var kidParent = kid && kid.parentNode;
        if (!parent && kidParent) {
          parent = kidParent;
          parentJq = $(parent);
        } else if (!parent || parent !== kidParent) {
          differentParents = true;
        }
      });
      if (!parent || differentParents) {
        return;
      }
      var currentKey = '';
      var childMap = {};
      var lastKeyIndex = -1;
      parentJq.children().each(function () {
        var kid = $(this);
        var keyFindResult = Object.keys(domMap).find(function (key) {
          return getOwnProperty(domMap, key)[0] === kid[0];
        });
        if (keyFindResult) {
          currentKey = keyFindResult;
          var index = keys.indexOf(currentKey);
          if (lastKeyIndex > index) {
            reorderedRequired = true;
          }
          lastKeyIndex = index;
        }
        childMap[currentKey] = getOwnProperty(childMap, currentKey) || [];
        childMap[currentKey].push(kid[0]);
      });
      if (childMap['']) {
        newKids.push.apply(newKids, _toConsumableArray(childMap['']));
      }
      if (parent && reorderedRequired && !differentParents) {
        var _parent;
        _.each(keys, function (key) {
          newKids.push.apply(newKids, _toConsumableArray(getOwnProperty(childMap, key)));
        });
        (_parent = parent).replaceChildren.apply(_parent, newKids);
      }
    });
  };

  /**
   * Get an icon for the requested widget.
   *
   * @param key
   * @returns {Promise|String|null} icon URI for the widget for the
   * given key (or promise to be resolved with same), or null if key not found
   */
  CompositeBuilder.prototype.getIconFor = function (key) {
    var ed = this.getEditorFor(key);
    return ed ? ed.toIcon() : null;
  };

  /**
   * Each Widget will need to have a value loaded. Given a key, this should
   * return the value that should be loaded into the widget for that key. Note
   * that this value may change over the life over the builder - `getValueFor`
   * should return whatever the most recent value should be.
   *
   * @abstract
   * @param {String} key
   * @returns {Promise|*} the value for the given key (or promise to
   * be resolved with same)
   * @throws {Error} if not implemented
   */
  CompositeBuilder.prototype.getValueFor = function (key) {
    throw new Error('getValueFor not implemented');
  };

  /**
   * Given a key, will return the currently instantiated widget for that key.
   *
   * @param {String} key
   * @returns {module:bajaux/Widget} the instantiated widget for that key. Returns
   * `null` if the given key is unknown/unrecognized, or if no widget has yet
   * been instantiated for that key.
   */
  CompositeBuilder.prototype.getEditorFor = function (key) {
    return getOwnProperty(this.$map, key);
  };

  /**
   * Instantiate the editor for this key. After this completes, `getEditorFor`
   * will return the instantiated editor. If an editor is already instantiated
   * for this key, it will be returned - no new editor will be instantiated.
   *
   * @private
   * @param key
   * @returns {Promise}
   */
  CompositeBuilder.prototype.$makeFor = function (key) {
    var that = this,
      existing = that.getEditorFor(key);
    return Promise.all([that.getConfigFor(key), that.getValueFor(key)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        config = _ref2[0],
        value = _ref2[1];
      if (existing && !existing.isDestroyed()) {
        return applyParams(existing, config).then(_.constant(existing));
      }
      if (!config || !(config.complex && config.slot)) {
        config = _.extend({}, {
          value: value
        }, config);
      }
      return fe.makeFor(config);
    }).then(function (ed) {
      return that.$map[key] = ed;
    });
  };

  /**
   * Instantiate editors for all known keys.
   *
   * @private
   * @returns {Promise}
   */
  CompositeBuilder.prototype.$makeAll = function () {
    var that = this;
    return Promise.resolve(that.getKeys()).then(function (keys) {
      return Promise.all(_.map(keys, function (key) {
        return that.getEditorFor(key) || that.$makeFor(key);
      }));
    });
  };

  /**
   * Initialize the editor for this key, using the result of `getDomFor()`.
   * If the editor is already initialized, it will not be re-initialized.
   *
   * @private
   * @param {String} key
   * @returns {Promise}
   */
  CompositeBuilder.prototype.$initializeFor = function (key) {
    var that = this,
      domMap = that.$domMap;
    return Promise.resolve(that.$makeFor(key)).then(function (ed) {
      if (ed.jq()) {
        return ed;
      }
      return that.$preloadDomFor(key).then(function (dom) {
        domMap[key] = dom;
        dom.data('key', key).addClass(CompositeBuilder.toCssClass(key));
        var existing = dom.data('widget');
        return Promise.resolve(existing && existing.destroy()).then(function () {
          return ed.initialize(dom);
        });
      }).then(function () {
        return ed;
      });
    });
  };

  /**
   * Initialize editors for all known keys.
   *
   * @private
   * @returns {Promise}
   */
  CompositeBuilder.prototype.$initializeAll = function () {
    var that = this;
    return Promise.resolve(that.getKeys()).then(function (keys) {
      return Promise.all(_.map(keys, function (key) {
        return that.$preloadDomFor(key);
      })).then(function () {
        return that.$reorderDomForKeys();
      }).then(function () {
        return Promise.all(_.map(keys, function (key) {
          return that.$initializeFor(key);
        }));
      });
    });
  };

  /**
   * Load the value for the editor for the given key, using the result of
   * `getValueFor`. If the editor has a value loaded already, it will be
   * re-loaded with the newest value.
   *
   * @param {String} key
   * @param {Object} [params] parameters to be passed to the editor's `load`
   * function
   * @returns {Promise}
   */
  CompositeBuilder.prototype.$loadFor = function (key, params) {
    var that = this;
    return Promise.all([that.$initializeFor(key), that.getValueFor(key)]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        ed = _ref4[0],
        value = _ref4[1];
      return ed.load(value, params);
    });
  };

  /**
   * Load values for editors for all known keys.
   *
   * @private
   * @returns {Promise}
   */
  CompositeBuilder.prototype.$loadAll = function () {
    var that = this;
    return Promise.resolve(that.getKeys()).then(function (keys) {
      return Promise.all(_.map(keys, function (key) {
        return that.$loadFor(key);
      }));
    });
  };

  /**
   * Destroy and remove all known editors that do not correspond with existing
   * keys. Call this after the value of `getKeys()` has keys removed.
   *
   * For example, say you had editors for all slots on a component, and then
   * a slot was removed from the component. The editor for that slot would
   * still be known (`getEditorFor()` would return a value), even though it
   * didn't correspond with a known key. `$prune()` will destroy that editor,
   * bringing the list of instantiated editors back in sync with the actual
   * state of the data.
   *
   * @private
   * @returns {Promise}
   */
  CompositeBuilder.prototype.$prune = function () {
    var that = this,
      map = that.$map;
    return Promise.resolve(that.getKeys()).then(function (keys) {
      var unknownKeys = _.compact(_.map(map, function (ed, key) {
        if (ed.isDestroyed() || keys.indexOf(key) < 0) {
          return key;
        }
      }));
      return Promise.all(_.map(unknownKeys, function (key) {
        return that.destroyFor(key);
      }));
    });
  };

  /**
   * Destroy and forget the editor for the given key. After this completes,
   * the referenced editor (if it exists) will have been destroyed, and
   * `getEditorFor` will return `undefined` for that key.
   *
   * Unless `removeOnDestroy` was set to `false`, the corresponding element
   * will also be removed from the DOM.
   *
   * @param {String} key
   * @returns {Promise}
   */
  CompositeBuilder.prototype.destroyFor = function (key) {
    var that = this,
      ed = that.getEditorFor(key),
      map = that.$map,
      domMap = that.$domMap;
    return Promise.resolve(ed && ed.isInitialized() && ed.destroy()).then(function () {
      if (that.$removeOnDestroy) {
        var dom = getOwnProperty(domMap, key);
        if (dom) {
          dom.remove();
        }
      }
      delete map[key];
      delete domMap[key];
    });
  };

  /**
   * Instantiate, initialize, and load widgets for all known keys. In case
   * the keys have changed, destroy all editors that no longer match a known
   * key.
   *
   * `getConfigFor`, `getDomFor`, and `getValueFor` will all be tied together
   * into this workflow.
   *
   * @returns {Promise}
   */
  CompositeBuilder.prototype.buildAll = function () {
    var that = this;
    return that.$prune().then(function () {
      return that.$makeAll();
    }).then(function () {
      return that.$initializeAll();
    }).then(function () {
      return that.$loadAll();
    });
  };

  /**
   * Read the values of all loaded editors. This will fail if `buildAll()` has
   * not completed, or if a key has been added but a corresponding editor has
   * not been built.
   *
   * @returns {Promise} promise to be resolved with an array of values
   * read from all editors, one-to-one corresponding with `getKeys()`, or
   * rejected with a CompositeError with the rejected keys and their rejection
   * reasons
   */
  CompositeBuilder.prototype.readAll = function () {
    var that = this;
    return Promise.resolve(that.getKeys()).then(function (keys) {
      return that.$readForKeys(keys);
    });
  };
  function toSettledResults(promises, keys) {
    return Promise.all(_.map(promises, function (promise) {
      return promise.then(function (result) {
        return {
          result: result
        };
      })["catch"](function (error) {
        return {
          failed: true,
          error: error
        };
      });
    })).then(function (settled) {
      var results = null,
        err;
      _.each(settled, function (_ref5, i) {
        var result = _ref5.result,
          failed = _ref5.failed,
          error = _ref5.error;
        if (failed) {
          (err || (err = {}))[keys[i]] = error;
        } else {
          (results || (results = [])).push(result);
        }
      });
      if (err) {
        throw new CompositeError(err);
      }
      return results || [];
    });
  }

  /**
   * Read all editors specified by the given keys.
   * @private
   * @param {Array.<String>} keys
   * @returns {Promise} promise to be resolved with an array of all results, or
   * rejected with a CompositeError with the rejected keys and their rejection
   * reasons
   */
  CompositeBuilder.prototype.$readForKeys = function (keys) {
    var that = this;
    return toSettledResults(_.map(keys, function (key) {
      return that.getEditorFor(key).read();
    }), keys);
  };

  /**
   * Validate all editors specified by the given keys.
   * @private
   * @param {Array.<String>} keys
   * @returns {Promise} promise to be resolved with an array of all results, or
   * rejected with a CompositeError with the rejected keys and their rejection
   * reasons
   */
  CompositeBuilder.prototype.$validateForKeys = function (keys) {
    var that = this;
    return toSettledResults(_.map(keys, function (key) {
      return that.getEditorFor(key).validate();
    }), keys);
  };
  function getOwnProperty(obj, key) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      return obj[key];
    }
  }
  return CompositeBuilder;
});
