function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'baja!control:PriorityLevel', 'lex!baja,control', 'Promise', 'nmodule/webEditors/rc/fe/baja/util/rangeUtils'], function (baja, types, lexs, Promise, rangeUtils) {
  'use strict';

  var bajaLex = lexs[0],
    controlLex = lexs[1],
    getEnumRangeDisplay = rangeUtils.getEnumRangeDisplay;
  var lexKeys = ['Status.disabled', 'Status.fault', 'Status.down', 'Status.alarm', 'Status.stale', 'Status.overridden', 'Status.null', 'Status.unackedAlarm'];
  var ACTIVE_LEVEL = 'activeLevel';

  /**
   * API Status: **Private**
   * @exports nmodule/webEditors/rc/fe/baja/util/statusUtils
   */
  var exports = {};

  //TODO: baja.lex does not document module param
  //TODO: BStatus gets a lot of its toString from BBitString - do we need to support that?

  function statusBitsToString(bits) {
    var statuses, i;
    if (bits === 0) {
      statuses = [bajaLex.get('Status.ok')];
    } else {
      statuses = [];
      for (i = 0; i < lexKeys.length; i++) {
        if (bits & 1 << i) {
          statuses.push(bajaLex.get(lexKeys[i]));
        }
      }
    }
    return '{' + statuses.join(',') + '}';
  }

  /**
   * `DynamicEnum`s don't have display tags, but `FrozenEnum`s do. This function
   * converts a `DynamicEnum` backed by a `PriorityLevel` into the corresponding
   * display tag, pulling it from the `control` lexicon in the case of
   * `fallback`. Other Simple values just get toStringed.
   *
   * @private
   * @inner
   * @param {baja.Simple} activeLevel
   * @returns {String}
   * @see BPriorityLevel.getDisplayTag()
   */
  function activeLevelToString(activeLevel) {
    return '@ ' + (toPriorityLevelString(activeLevel) || activeLevel);
  }

  //TODO: this needs to be a PriorityLevel type extension (NCCB-24257)
  function toPriorityLevelString(priorityLevel) {
    if (!baja.hasType(priorityLevel, 'baja:DynamicEnum')) {
      return null;
    }
    var frozen = priorityLevel.getRange().getFrozenType();
    if (frozen && frozen.is('control:PriorityLevel')) {
      var frozenEnum = baja.$('control:PriorityLevel').get(priorityLevel.getOrdinal());
      return frozenEnum.getTag() === 'fallback' ? controlLex.get('def') : frozenEnum.getDisplayTag();
    }
  }
  function facetsToString(facets) {
    var keys = facets.getKeys(),
      key,
      value,
      a = [],
      i;
    for (i = 0; i < keys.length; i++) {
      key = keys[i];
      value = facets.get(key);
      if (key === ACTIVE_LEVEL) {
        a.push(activeLevelToString(value));
      } else if (value === true) {
        a.push(key);
      } else {
        a.push(key + '=' + value);
      }
    }
    return a.join(' ');
  }
  function simpleToString(simple, obj) {
    switch (String(simple.getType())) {
      case 'baja:Boolean':
        var text = obj[simple ? 'trueText' : 'falseText'];
        return text ? baja.Format.format(text) : bajaLex.get(String(simple));
      case 'baja:Double':
        return simple.toString(obj);
      case 'baja:DynamicEnum':
        return getEnumRangeDisplay(simple.getOrdinal(), obj.range || simple.getRange());
      case 'baja:String':
        return simple;
      default:
        return String(simple);
    }
  }

  /**
   * Converts a `baja.Status` to a display string in a similar way to `BStatus`.
   *
   * @param {baja.Status|Number} status the status to encode (a bit string in
   * the form of a number will be converted to a `baja.Status`)
   * @returns {Promise} promise to be resolved with the toString-ed
   * status, or rejected if the input was invalid
   */
  exports.statusToString = function statusToString(status) {
    if (typeof status === 'number') {
      status = baja.Status.make(status);
    }
    if (!baja.hasType(status, 'baja:Status')) {
      return Promise.reject(new Error('baja:Status or number required'));
    }
    var str = statusBitsToString(status.getBits()),
      facets = status.getFacets();
    if (facets && facets !== baja.Facets.DEFAULT) {
      str += ' ' + facetsToString(facets);
    }
    return Promise.resolve(str);
  };

  //TODO: remove 90% of this and use baja.Simple#toString(cx)
  /**
   * Resolve a human-readable string value for a `StatusValue`.
   *
   * Supports `trueText` and `falseText` for booleans, `range` for enums,
   * and all properties (`precision` etc.) that are supported by `numberUtils`.
   *
   * @param {baja.Struct} statusValue a `baja:StatusValue`
   * @param {Object} [config] properties to use to format the `value` property
   * @returns {*}
   */
  exports.statusValueToString = function (statusValue, config) {
    if (!baja.hasType(statusValue, 'baja:StatusValue')) {
      return Promise.reject(new Error('baja:StatusValue required'));
    }
    var status = statusValue.get('status'),
      value = statusValue.get('value');
    return Promise.all([status.isNull() ? '-' : simpleToString(value, config || {}), exports.statusToString(status)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        valueString = _ref2[0],
        statusString = _ref2[1];
      return valueString + ' ' + statusString;
    });
  };
  return exports;
});
