function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/util/ChunkSubscriber
 */
define(['baja!', 'log!nmodule.webEditors.rc.fe.baja.util.ChunkSubscriber', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard'], function (baja, log, Promise, _, switchboard) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var difference = _.difference,
    range = _.range,
    uniq = _.uniq;
  var DEFAULT_CHUNK_SIZE = 100;
  var DEFAULT_MAX_CONCURRENT_CHUNKS = 4;

  /**
   * A Subscriber subclass that alleviates pressure on the JACE by breaking subscription network
   * calls into smaller chunks.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/util/ChunkSubscriber
   * @extends baja.Subscriber
   */
  return /*#__PURE__*/function (_baja$Subscriber) {
    /**
     * @param {object} [params]
     * @param {number} [params.chunkSize=100] how many components to subscribe per network call
     * @param {number} [params.maxConcurrentChunks=4] how many network calls can be in flight at
     * the same time
     */
    function ChunkSubscriber() {
      var _this;
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$chunkSize = _ref.chunkSize,
        chunkSize = _ref$chunkSize === void 0 ? DEFAULT_CHUNK_SIZE : _ref$chunkSize,
        _ref$maxConcurrentChu = _ref.maxConcurrentChunks,
        maxConcurrentChunks = _ref$maxConcurrentChu === void 0 ? DEFAULT_MAX_CONCURRENT_CHUNKS : _ref$maxConcurrentChu;
      _classCallCheck(this, ChunkSubscriber);
      _this = _callSuper(this, ChunkSubscriber);
      _this.$chunkSize = chunkSize;
      _this.$maxConcurrentChunks = maxConcurrentChunks;
      _this.$q = [];
      switchboard(_this, {
        $drainQueue: {
          allow: 'oneAtATime',
          onRepeat: 'returnLast'
        }
      });
      return _this;
    }

    /**
     * Subscribes the given components, in chunks.
     *
     * @param {Array.<baja.Component>} comps
     * @returns {Promise}
     */
    _inherits(ChunkSubscriber, _baja$Subscriber);
    return _createClass(ChunkSubscriber, [{
      key: "subscribe",
      value: function subscribe(comps) {
        this.$q = uniq(this.$q.concat(comps));
        return this.$drainQueue();
      }

      /**
       * Subscribes the given components as soon as possible. If they are currently waiting on being
       * subscribed due to a `subscribe()` call, they will move up to be subscribed as part of the
       * next chunk.
       *
       * @param {Array.<baja.Component>} comps
       * @returns {Promise} to be resolved as soon as the given components are subscribed
       */
    }, {
      key: "subscribeAsap",
      value: function subscribeAsap(comps) {
        this.$bumpToFrontOfQueue(comps);
        this.$drainQueue()["catch"](logSevere);
        return Promise.all(comps.map(waitForSubscription));
      }

      /**
       * @private
       * @param {Array.<baja.Component>} comps
       */
    }, {
      key: "$bumpToFrontOfQueue",
      value: function $bumpToFrontOfQueue(comps) {
        this.$q = comps.concat(difference(this.$q, comps));
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$drainQueue",
      value: function $drainQueue() {
        var _this2 = this;
        var _subscribeNextChunk = function subscribeNextChunk() {
          var chunk = _this2.$q.splice(0, _this2.$chunkSize);
          if (chunk.length) {
            return _this2.$subscribeChunk(chunk).then(_subscribeNextChunk);
          }
        };
        return Promise.all(range(0, this.$maxConcurrentChunks).map(_subscribeNextChunk));
      }

      /**
       * @private
       * @param {Array.<baja.Component>} comps
       * @returns {Promise}
       */
    }, {
      key: "$subscribeChunk",
      value: function $subscribeChunk(comps) {
        var batch = new baja.comm.Batch();
        return batch.commit(_superPropGet(ChunkSubscriber, "subscribe", this, 3)([{
          comps: comps,
          batch: batch
        }]));
      }
    }]);
  }(baja.Subscriber);

  /**
   * @param {baja.Component} comp
   * @returns {Promise.<baja.Component>}
   */
  function waitForSubscription(comp) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      // TODO: NCCB-57886
      if (comp.isSubscribed() && comp.$bPropsLoaded) {
        return resolve(comp);
      }
      var _onSubscribed = function onSubscribed() {
        resolve(comp);
        comp.detach('subscribed', _onSubscribed);
      };
      comp.attach('subscribed', _onSubscribed);
    });
  }
});
