function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/ViewQueryEditor
 */
define(['baja!', 'lex!webEditors', 'underscore', 'Promise', 'bajaux/events', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/servlets/views', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/FacetsEditor', 'nmodule/webEditors/rc/wb/options/MruButton', 'nmodule/webEditors/rc/wb/options/MruOptions', 'nmodule/webEditors/rc/wb/profile/profileUtils'], function (baja, lexs, _, Promise, events, spandrel, Command, CommandButton, views, feDialogs, typeUtils, OrderedMapEditor, FacetsEditor, MruButton, MruOptions, profileUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var getTypeDisplayName = typeUtils.getTypeDisplayName;
  var getOrdWithoutViewQuery = profileUtils.getOrdWithoutViewQuery;
  var DEFAULT_AGENT = lex.get('ViewQueryEditor.agentList.default');
  var VIEW_SEPARATOR = '|view:?';
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ViewQueryEditor'
      }
    };
  };
  var MRU_NAME = 'viewQueryFE';
  /**
   * Makes 'viewQueryFE' Options for Mru.
   * @returns {Promise<module:nmodule/webEditors/rc/wb/options/MruOptions>}
   */
  var resolveMruOptions = function resolveMruOptions() {
    return MruOptions.make(MRU_NAME);
  };
  /**
   * Get the views for the target ord to show in agents drop down.
   * @param {baja.Ord} targetOrd
   * @returns {Promise<Object>}
   */
  var getViewsForTarget = function getViewsForTarget(targetOrd) {
    var agents = _defineProperty({}, DEFAULT_AGENT, DEFAULT_AGENT);
    //Makes a servlet call and get the list of views for the target ord.
    return views.viewInfo(baja.Ord.make({
      base: 'station:',
      child: targetOrd
    })).then(function (agentInfo) {
      var agentList = agentInfo.list;
      agentList.forEach(function (agent) {
        agents[agent.displayName] = agent;
      });
      return agents;
    })
    //For unresolvable slots, like action slots, view information cannot be retrieved,
    //in that case return default agents.
    ["catch"](function () {
      return agents;
    });
  };
  /**
   * Converts facets object to a ValueString.
   * @param {baja.Facets} facets
   * @returns {string}
   */
  var facetsToValueString = function facetsToValueString(facets) {
    return facets.toString().replaceAll(',', ';');
  };

  /**
   * A field editor for the agents of an OrdTarget.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/ViewQueryEditor
   * @extends module:bajaux/spandrel
   * @since Niagara 4.15
   */
  return /*#__PURE__*/function (_spandrel) {
    function ViewQueryEditor(params) {
      var _this;
      _classCallCheck(this, ViewQueryEditor);
      _this = _callSuper(this, ViewQueryEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$editParamsCommand = new Command({
        module: 'webEditors',
        lex: 'OrdEditor.ParamsEditorCommand',
        func: function func() {
          return _this.$showViewQueryParametersDialog();
        }
      });
      return _this;
    }

    /**
     * @private
     * @param {String} facetsStr
     * @returns {Promise}
     */
    _inherits(ViewQueryEditor, _spandrel);
    return _createClass(ViewQueryEditor, [{
      key: "$loadFacets",
      value: function $loadFacets(facetsStr) {
        var _this2 = this;
        return baja.Facets.DEFAULT.decodeAsync(facetsStr).then(function (viewQueryParameters) {
          return _this2.state({
            viewQueryParameters: viewQueryParameters
          });
        });
      }

      /**
       * @private
       * @param {String} facetsStr
       * @returns {Promise}
       */
    }, {
      key: "$toDisplayString",
      value: function $toDisplayString(facetsStr) {
        return baja.Facets.DEFAULT.decodeAsync(facetsStr).then(String);
      }
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _arguments = arguments,
          _this3 = this;
        return resolveMruOptions().then(function (mruOptions) {
          dom.on(MODIFY_EVENT, '.-t-ViewQuery-wrapper', function () {
            return false;
          });
          _this3.state({
            mruOptions: mruOptions
          });
          return _superPropGet(ViewQueryEditor, "doInitialize", _this3, 3)(_arguments);
        });
      }
    }, {
      key: "toState",
      value: function toState(ord) {
        if (!ord || ord.equals(baja.Ord.DEFAULT)) {
          return {
            agents: [],
            selectedAgent: DEFAULT_AGENT,
            viewQueryParameters: baja.Facets.DEFAULT
          };
        }
        ord = baja.Ord.make(ord);
        var viewQuery = ord.normalize().parse().get('view');
        var viewQueryParameters = baja.Facets.DEFAULT;
        if (viewQuery) {
          viewQueryParameters = baja.Facets.make(viewQuery.getParameters());
        }
        return Promise.all([getViewsForTarget(ord), this.$getViewIdFromViewQuery(viewQuery)]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            agents = _ref2[0],
            selectedAgent = _ref2[1];
          return {
            agents: agents,
            selectedAgent: selectedAgent,
            viewQueryParameters: viewQueryParameters
          };
        });
      }
    }, {
      key: "fromState",
      value: function fromState(_ref3) {
        var agents = _ref3.agents,
          viewQueryParameters = _ref3.viewQueryParameters,
          selectedAgent = _ref3.selectedAgent;
        var ord = this.value();
        if (ord && ord !== baja.Ord.DEFAULT) {
          ord = getOrdWithoutViewQuery(this.value());

          //get ord with the view id
          if (selectedAgent !== DEFAULT_AGENT) {
            ord = agents[selectedAgent].ord;
          }

          //get the view query parameters from the state and append it to the ord
          if (!viewQueryParameters.equals(baja.Facets.DEFAULT)) {
            var facetsValueString = facetsToValueString(viewQueryParameters);
            if (selectedAgent === DEFAULT_AGENT) {
              ord = "".concat(ord).concat(VIEW_SEPARATOR).concat(facetsValueString);
            } else {
              ord = "".concat(ord, "?").concat(facetsValueString);
            }
          }
          return baja.Ord.make(ord);
        }
        return ord;
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showViewQueryParametersDialog",
      value: function $showViewQueryParametersDialog() {
        var _this4 = this;
        return feDialogs.showFor({
          title: lex.get('ViewQueryEditor.dialogTitle'),
          value: this.state().viewQueryParameters,
          formFactor: 'compact',
          type: FacetsEditor,
          properties: {
            keyName: 'ViewQueryParamsEditor',
            formFactor: 'compact',
            allowAdd: true,
            allowDelete: true,
            allowRename: true,
            showHeader: true,
            allowChangeType: false,
            mru: MRU_NAME,
            hideDefaultKeys: true
          }
        }).then(function (viewQueryParameters) {
          if (viewQueryParameters) {
            viewQueryParameters = baja.Facets.make(viewQueryParameters);
            var _this4$state = _this4.state(),
              mruOptions = _this4$state.mruOptions;
            mruOptions.add(viewQueryParameters.encodeToString());
            return _this4.state({
              mruOptions: mruOptions,
              viewQueryParameters: viewQueryParameters
            });
          }
        });
      }

      /**
       * @private
       * @param viewQuery
       * @returns {String}
       */
    }, {
      key: "$getViewIdFromViewQuery",
      value: function $getViewIdFromViewQuery(viewQuery) {
        var viewId = viewQuery && viewQuery.getViewId();
        if (!viewId) {
          return DEFAULT_AGENT;
        }
        return getTypeDisplayName(viewId);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAgentsWidget",
      value: function $getAgentsWidget() {
        return this.queryWidget('**/selectedAgent');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMruButton",
      value: function $getMruButton() {
        return this.queryWidget('**/mru');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getViewQueryParametersElement",
      value: function $getViewQueryParametersElement() {
        return this.jq().find('.-t-ViewQuery-summary');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getEditParamsCommandButton",
      value: function $getEditParamsCommandButton() {
        return this.queryWidget('**/editParamsCommand');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self,
      mruOptions = state.mruOptions,
      agents = state.agents,
      viewQueryParameters = state.viewQueryParameters,
      selectedAgent = state.selectedAgent;
    var viewQueryParameterString = viewQueryParameters.equals(baja.Facets.DEFAULT) ? lex.get('ViewQueryEditor.viewParameterSummary.placeholder') : facetsToValueString(viewQueryParameters);
    return spandrel.jsx("div", {
      className: "-t-ViewQuery-wrapper"
    }, spandrel.jsx("span", {
      className: "-t-ViewQuery-summary"
    }, viewQueryParameterString), spandrel.jsx(CommandButton, {
      spandrelKey: "editParamsCommand",
      className: "-t-editParamsCommand",
      value: self.$editParamsCommand,
      properties: {
        formFactor: 'mini'
      }
    }), spandrel.jsx(MruButton, {
      value: {
        options: mruOptions,
        select: function select(facets) {
          return self.$loadFacets(facets);
        },
        toDisplayString: function toDisplayString(facetsStr) {
          return self.$toDisplayString(facetsStr);
        }
      },
      spandrelKey: "mru",
      className: "-t-ViewQuery-mru"
    }), spandrel.jsx(OrderedMapEditor, {
      bind: true,
      value: selectedAgent,
      spandrelKey: "selectedAgent",
      className: "-t-Agents",
      properties: {
        map: Object.keys(agents)
      }
    }));
  }, {
    strategy: 'niagara'
  }));
});
