function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/StatusValueEditor
 */
define(['baja!', 'bajaux/spandrel', 'bajaux/mixin/batchSaveMixin', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/statusUtils'], function (baja, spandrel, batchSaveMixin, compUtils, statusUtils) {
  'use strict';

  var bulkCopy = compUtils.bulkCopy;
  var COMMIT_READY = batchSaveMixin.COMMIT_READY;
  var statusValueToString = statusUtils.statusValueToString;
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'webEditors',
      keyName: 'StatusValueEditor',
      properties: {
        rootCssClass: '-t-StatusValueEditor'
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/StatusValueEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   */
  var StatusValueEditor = /*#__PURE__*/function (_spandrel) {
    function StatusValueEditor(params) {
      var _this;
      _classCallCheck(this, StatusValueEditor);
      _this = _callSuper(this, StatusValueEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        return _this.$getValueEditor().validate();
      });
      _this.$isHonoraryBaseEditor = true;
      return _this;
    }
    _inherits(StatusValueEditor, _spandrel);
    return _createClass(StatusValueEditor, [{
      key: "toState",
      value: function toState(statusValue) {
        var status = statusValue.get('status');
        var value = statusValue.get('value');
        // hold onto facets for later rerenders.
        return {
          status: status,
          value: value,
          origFacets: status.getFacets()
        };
      }

      /**
       * @returns {baja.Struct} a copy of the loaded `baja:StatusValue` with currently
       * entered values
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var status = _ref.status,
          value = _ref.value;
        return baja.$(this.value().getType(), {
          status: status,
          value: value
        });
      }

      /**
       * Write the entered values onto the loaded StatusValue.
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave(statusValue) {
        var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          progressCallback = _ref2.progressCallback,
          batch = _ref2.batch;
        var prom = bulkCopy(statusValue, this.value(), ['status', 'value'], batch);
        if (progressCallback) {
          progressCallback(COMMIT_READY);
        }
        return prom;
      }

      /**
       * Return the editor for the actual status value (the one editable by the
       * user).
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/StatusEditor}
       */
    }, {
      key: "$getValueEditor",
      value: function $getValueEditor() {
        return this.queryWidget('statusAndValue/value');
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor} the editor for the `status` slot.
       */
    }, {
      key: "$getStatusEditor",
      value: function $getStatusEditor() {
        return this.queryWidget('statusAndValue/status');
      }

      /**
       * Return the text of the status display value (not editable
       * by the user).
       * @private
       * @returns {string}
       */
    }, {
      key: "$getDisplayText",
      value: function $getDisplayText() {
        return this.jq().children('.-t-StatusValueEditor-display').text();
      }
    }]);
  }(spandrel(function (statusValue, _ref3) {
    var properties = _ref3.properties,
      readonly = _ref3.readonly,
      origFacets = _ref3.origFacets,
      status = _ref3.status,
      value = _ref3.value;
    // NCCB-62204: because StatusEditor and BStatusFE both omit the facets from the status that gets
    // read out, after a rerender, the last-read statusValue will have no facets so the display
    // will not have the expected "@ def" or w/e. create a copy with the originally-loaded facets
    // just for display purposes.
    var copy = baja.$(statusValue.getType(), {
      status: baja.Status.make({
        bits: status.getBits(),
        facets: origFacets
      }),
      value: value
    });
    return [
    // See NCCB-57130: should just be one onUxModify for the span.
    spandrel.jsx("span", {
      spandrelKey: "statusAndValue",
      className: "-t-StatusValueEditor-composite"
    }, spandrel.jsx("any", {
      bind: true,
      spandrelKey: "value",
      value: value,
      properties: "inherit",
      readonly: readonly || status.isNull()
    }), spandrel.jsx("any", {
      bind: true,
      spandrelKey: "status",
      value: status,
      properties: {
        filter: baja.Status.NULL
      }
    })), spandrel.jsx("span", {
      className: "-t-StatusValueEditor-display"
    }, statusValueToString(copy, properties))];
  }, {
    strategy: 'niagara'
  }));
  return StatusValueEditor;
});
