function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/OrdEditor
 */
define(['baja!', 'bajaux/commands/Command', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/util/CommandButton', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/wb/commands/GoToCommand'], function (baja, Command, spandrel, Widget, CommandButton, Promise, _, fe, BaseWidget, OrderedMapEditor, GoToCommand) {
  'use strict';

  var miniFormFactor = Widget.formfactor.mini;
  var once = _.once,
    find = _.find,
    uniq = _.uniq;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-OrdEditor'
      }
    };
  };

  /**
   * @returns {Promise}
   */
  var resolveOrdChoosers = once(function () {
    return baja.rpc("type:webEditors:OrdEditor", "getJavaScriptOrdChoosersMap");
  });

  /**
   * @private
   * @typedef module:nmodule/webEditors/rc/fe/baja/OrdEditor~OrdChooserEntry
   * @property {String} dn displayName
   * @property {String} t type
   */

  /**
   * A field editor for editing a `baja.Ord`.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/OrdEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.13
   **/
  var OrdEditor = /*#__PURE__*/function (_spandrel) {
    function OrdEditor(params) {
      var _this;
      _classCallCheck(this, OrdEditor);
      _this = _callSuper(this, OrdEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$gotoCmd = new GoToCommand(_this);
      _this.$isHonoraryBaseEditor = true;
      return _this;
    }

    /**
     * @param {baja.Ord|string} ord
     * @returns {{ord, scheme: string}}
     */
    _inherits(OrdEditor, _spandrel);
    return _createClass(OrdEditor, [{
      key: "toState",
      value: function toState(ord) {
        var scheme = "slot";
        var queryList;
        try {
          queryList = baja.Ord.make(ord).parse();
          var lastQuery = queryList.get(queryList.size() - 1);
          if (lastQuery) {
            scheme = lastQuery.getSchemeName().toLowerCase();
          }
        } catch (error) {}
        ord = baja.Ord.make(ord);
        return {
          scheme: scheme,
          ord: ord
        };
      }

      /**
       * OrdEditor does not bind the OrdWidget because the BqlQueryBuilder `toState` requires the bql ord to be validated station side.
       * @returns {Promise.<baja.Ord>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return this.$getOrdWidget().read().then(function (ord) {
          return baja.Ord.make(ord);
        });
      }

      /**
       * @since Niagara 4.14
       */
    }, {
      key: "requestFocus",
      value: function requestFocus() {
        var ordWidget = this.$getOrdWidget();
        ordWidget && ordWidget.requestFocus();
      }

      /**
       * @param {String} [scheme]
       * @param {String} [ordChooser]
       * @param {Object} ordChooserMap
       * @returns {module:nmodule/webEditors/rc/fe/baja/OrdEditor~OrdChooserEntry}
       */
    }, {
      key: "$getOrdChooserEntry",
      value: function $getOrdChooserEntry(scheme, ordChooser, ordChooserMap) {
        return find(ordChooserMap, function (entry, key) {
          if (ordChooser && entry.dn === ordChooser) {
            return entry;
          }
          if (!ordChooser && scheme === key) {
            return entry;
          }
        }) || ordChooserMap.slot;
      }

      /**
       * @private
       * @param {object} state
       * @returns {Promise|Object}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var ord = state.ord,
          props = state.props,
          scheme = state.scheme,
          ordChooser = state.ordChooser,
          self = state.self,
          formFactor = state.formFactor;
        if (formFactor === miniFormFactor) {
          return [spandrel.jsx("any", {
            lax: true,
            spandrelKey: "ord",
            value: ord.toString()
          }), GoToCommand.canAdd(props) && spandrel.jsx(CommandButton, {
            value: self.$gotoCmd,
            tagName: "button",
            type: "button",
            spandrelKey: "goto",
            className: "ux-btn-tb -t-GoToCommand"
          })];
        }
        return resolveOrdChoosers().then(function (ordChooserMap) {
          var ordChooserEntry = self.$getOrdChooserEntry(scheme, ordChooser, ordChooserMap);
          ordChooser = ordChooserEntry && ordChooserEntry.dn;
          var ordChoosers = uniq(Object.keys(ordChooserMap).map(function (key) {
            return ordChooserMap[key].dn;
          }), function (entry) {
            return entry;
          });
          var uxFieldEditor = ordChooserEntry && ordChooserEntry.t;
          return Promise.resolve(uxFieldEditor && fe.getDefaultConstructor(uxFieldEditor, {
            formFactors: ['compact']
          })).then(function (OrdPicker) {
            return spandrel.jsx("div", {
              spandrelKey: "layout",
              className: "-t-OrdEditor-root"
            }, spandrel.jsx("div", {
              className: "-t-OrdEditor-header",
              spandrelKey: "header"
            }, spandrel.jsx(OrderedMapEditor, {
              value: ordChooser,
              properties: {
                map: ordChoosers
              },
              className: "-t-ordChooser",
              onUxModify: function onUxModify() {
                return self.rerender().then(function () {
                  return self.$getOrdWidget().setModified(true);
                }).then(function () {
                  return self.requestFocus();
                });
              },
              lax: true,
              bind: true,
              spandrelKey: "ordChooser"
            })), spandrel.jsx(OrdPicker, {
              lax: true,
              spandrelKey: "ord",
              value: ord,
              formFactor: "compact",
              properties: "inherit",
              validate: true
            }));
          });
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStringWidget",
      value: function $getStringWidget() {
        return this.queryWidget('ord');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getGoToCommand",
      value: function $getGoToCommand() {
        return this.queryWidget('goto');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getOrdWidget",
      value: function $getOrdWidget() {
        return this.queryWidget('**/ord');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getOrdChooser",
      value: function $getOrdChooser() {
        return this.queryWidget('layout/header/ordChooser');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return OrdEditor;
});
