function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/MgrStringEditor
 */
define(['baja!', 'lex!webEditors', 'log!nmodule/webEditors/rc/fe/baja/MgrStringEditor', 'jquery', 'underscore', 'bajaux/events', 'bajaux/spandrel', 'bajaux/Widget', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel'], function (baja, lexs, log, $, _, events, spandrel, Widget, Promise, fe, BooleanEditor, StringEditor, userData, mgrUtils, Column, Row, Table, TableModel) {
  'use strict';

  var miniFormFactor = Widget.formfactor.mini;
  var EDITABLE = Column.flags.EDITABLE;
  var READONLY = Column.flags.READONLY;
  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var oldLabel = webEditorsLex.get("MgrStringEditor.oldColLabel");
  var newLabel = webEditorsLex.get("MgrStringEditor.newColLabel");
  var searchFor = webEditorsLex.get("MgrStringEditor.searchFor");
  var replaceWith = webEditorsLex.get("MgrStringEditor.replaceWith");
  var matchCase = webEditorsLex.get("MgrStringEditor.matchCase");
  var matchWord = webEditorsLex.get("MgrStringEditor.matchWord");
  var getProposedValue = mgrUtils.getProposedValue,
    propose = mgrUtils.propose;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-MgrStringEditor'
      },
      rows: []
    };
  };
  var getJson = userData.getJson,
    putJson = userData.putJson;
  var loadSearches = function loadSearches() {
    var searchListObj = {};
    var replaceListObj = {};
    if (baja.isOffline()) {
      return Promise.resolve([]);
    }
    return getJson("batchReplace").then(function (value) {
      var searchArray = [];
      var replaceArray = [];
      if (value) {
        var searchObj = value;
        searchArray = searchObj.search;
        replaceArray = searchObj.replace;
      }
      searchArray.forEach(function (str) {
        searchListObj[str] = str;
      });
      replaceArray.forEach(function (str) {
        replaceListObj[str] = str;
      });
      return [searchListObj, replaceListObj];
    });
  };

  /**
   * @param {Object} searchListObj
   * @param {String} searchVal
   * @param {Object} replaceListObj
   * @param {String} replaceVal
   * @returns {Promise}
   */
  function saveSearches() {
    var searchListObj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var searchVal = arguments.length > 1 ? arguments[1] : undefined;
    var replaceListObj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var replaceVal = arguments.length > 3 ? arguments[3] : undefined;
    var searchObj = {};
    var searchArray = Object.values(searchListObj);
    var replaceArray = Object.values(replaceListObj);
    if (searchVal && !searchArray.includes(searchVal)) {
      searchArray.push(searchVal);
    }
    if (replaceVal && !replaceArray.includes(replaceVal)) {
      replaceArray.push(replaceVal);
    }
    if (replaceArray.length !== 0 || searchArray.length !== 0) {
      searchObj.search = searchArray;
      searchObj.replace = replaceArray;
      return putJson("batchReplace", searchObj);
    }
    return Promise.resolve();
  }

  /**
  * A manager field editor for editing string values with search and replace
  *
  * @class
  * @alias module:nmodule/webEditors/rc/fe/baja/MgrStringEditor
  * @extends module:bajaux/Widget
  * @since Niagara 4.12
  **/
  var MgrStringEditor = /*#__PURE__*/function (_spandrel) {
    function MgrStringEditor(params) {
      var _this;
      _classCallCheck(this, MgrStringEditor);
      _this = _callSuper(this, MgrStringEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);

      //TODO $forcePropose is a temporary solution that tells the PopOutCommand to force a change
      // even if the original value of the primary field and the new value are the same.  The issue
      // for this is NCCB-54633.

      // eslint-disable-next-line no-unused-vars
      _this.$forcePropose = true;
      return _this;
    }
    _inherits(MgrStringEditor, _spandrel);
    return _createClass(MgrStringEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        var props = this.properties().toObject();
        this.$lastReplace = "";
        this.$lastSrch = "";
        this.$hldMatchCase = false;
        this.$hldMatchWord = false;
        this.$strValArray = [];
        this.$loadRows(props);
        this.$buildTableCols();
        dom.on(events.MODIFY_EVENT, '', function () {
          _this2.$applyChanges();
        });
        return _superPropGet(MgrStringEditor, "doInitialize", this, 3)(arguments);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$loadSearches",
      value: function $loadSearches() {
        var _this3 = this;
        this.$searchList = {};
        this.$replaceList = {};
        return loadSearches().then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            searchListObj = _ref2[0],
            replaceListObj = _ref2[1];
          if (searchListObj !== undefined) {
            _this3.$searchList = searchListObj;
          }
          if (replaceListObj !== undefined) {
            _this3.$replaceList = replaceListObj;
          }
        });
      }

      /**
       * @private
       * @param props
       */
    }, {
      key: "$loadRows",
      value: function $loadRows(props) {
        this.$colName = props.colName;
        if (props) {
          var rows = props.rows;
          if (rows !== undefined) {
            for (var i = 0; i < rows.length; i++) {
              var row = rows[i];
              var mgrProposed = getProposedValue(row, 'mgr.batch.proposed.' + this.$colName);
              var mgrCurrent = getProposedValue(row, 'mgr.batch.current.' + this.$colName);
              var sysProposed = getProposedValue(row, this.$colName);

              // In the next two if statements, I am specifically making sure I do not have an
              //  undefined value, if I do, I do not want to use it.
              if (sysProposed !== undefined) {
                mgrCurrent = sysProposed;
                mgrProposed = sysProposed;
              }
              if (mgrProposed === undefined) {
                mgrProposed = mgrCurrent;
              }
              var rowData = {};
              rowData.row = row;
              rowData.currStrValue = mgrCurrent;
              rowData.newStrValue = mgrProposed;
              this.$strValArray[i] = rowData;
            }
          }
        }
      }

      /**
       * @private
       */
    }, {
      key: "$buildTableCols",
      value: function $buildTableCols() {
        var oldValCol = new Column('oldVal', {
          displayName: oldLabel,
          flags: EDITABLE | READONLY
        });
        oldValCol.setSortable(false);
        oldValCol.setHidable(false);
        oldValCol.getValueFor = function (row) {
          return String(row.$subject.currStrValue);
        };
        var newValCol = new Column('newVal', {
          displayName: newLabel,
          flags: EDITABLE | READONLY
        });
        newValCol.setSortable(false);
        newValCol.setHidable(false);
        newValCol.getValueFor = function (row) {
          return String(row.$subject.newStrValue);
        };
        this.$columns = [oldValCol, newValCol];
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
       */
    }, {
      key: "$buildTableModel",
      value: function $buildTableModel() {
        var rows = [];
        for (var i = 0; i < this.$strValArray.length; i++) {
          var row = new Row(this.$strValArray[i]);
          rows.push(row);
        }
        return new TableModel({
          rows: rows,
          columns: this.$columns
        });
      }

      /**
       * @private
       * @param {string} strValue
       * @param {string} formFactor
       * @returns {Promise.<object>}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(strValue, formFactor) {
        var _this4 = this;
        if (formFactor === miniFormFactor) {
          return Promise.resolve([spandrel.jsx("div", {
            "class": "-t-MgrStringEditor-Mini",
            spandrelKey: "miniLayout"
          }, spandrel.jsx("any", {
            lax: true,
            "class": "-t-MgrStringEditor-stringVal",
            spandrelKey: "strVal",
            value: strValue
          }))]);
        } else {
          return this.$loadSearches().then(function () {
            return [spandrel.jsx("div", {
              spandrelKey: "compactLayout"
            }, spandrel.jsx("div", {
              "class": "tableContainer"
            }, spandrel.jsx(Table, {
              value: _this4.$buildTableModel(),
              style: "max-height: 40vh; margin-bottom: 10px;",
              properties: {
                fixedHeaders: true
              }
            })), spandrel.jsx("table", {
              className: "-t-MgrStringEditor-Compact",
              spandrelKey: "paramTable"
            }, spandrel.jsx("tr", {
              spandrelKey: "searchRow"
            }, spandrel.jsx("td", {
              className: "-t-MgrStringEditor-Compact-tableLabel"
            }, searchFor), spandrel.jsx("td", {
              spandrelKey: "searchCell"
            }, spandrel.jsx("any", {
              className: "-t-MgrStringEditor-Compact-stringVal",
              spandrelKey: "srchVal",
              value: _this4.$lastSrch,
              properties: {
                datalist: _this4.$searchList
              }
            }))), spandrel.jsx("tr", {
              spandrelKey: "replaceRow"
            }, spandrel.jsx("td", {
              className: "-t-MgrStringEditor-Compact-tableLabel"
            }, replaceWith), spandrel.jsx("td", {
              spandrelKey: "replaceCell"
            }, spandrel.jsx("any", {
              className: "-t-MgrStringEditor-Compact-stringVal",
              spandrelKey: "replaceVal",
              value: _this4.$lastReplace,
              properties: {
                datalist: _this4.$replaceList
              }
            }))), spandrel.jsx("tr", {
              spandrelKey: "matchCaseRow"
            }, spandrel.jsx("td", {
              spandrelKey: "matchCaseCell"
            }, spandrel.jsx("any", {
              className: "-t-MgrStringEditor-Compact-checkBox",
              value: _this4.$hldMatchCase,
              spandrelKey: "matchCase",
              properties: {
                displayType: "checkbox",
                trueText: matchCase,
                falseText: matchCase
              }
            }))), spandrel.jsx("tr", {
              spandrelKey: "matchWordRow"
            }, spandrel.jsx("td", {
              spandrelKey: "matchWordCell"
            }, spandrel.jsx("any", {
              className: "-t-MgrStringEditor-Compact-checkBox",
              value: _this4.$hldMatchWord,
              spandrelKey: "matchWord",
              properties: {
                displayType: "checkbox",
                trueText: matchWord,
                falseText: matchWord
              }
            })))))];
          });
        }
      }

      /**
       * @private
       * @param {number} row
       * @param {boolean} oldValue
       */
    }, {
      key: "$getRowVals",
      value: function $getRowVals(row, oldValue) {
        var rowData = this.$strValArray[row];
        if (oldValue) {
          return rowData.currStrValue;
        } else {
          return rowData.newStrValue;
        }
      }

      /**
       * @private
       */
    }, {
      key: "$getStrVal",
      value: function $getStrVal() {
        return this.queryWidget('miniLayout/**/strVal');
      }

      /**
       * @private
       */
    }, {
      key: "$getSrchVal",
      value: function $getSrchVal() {
        return this.queryWidget("compactLayout/paramTable/searchRow/searchCell/srchVal");
      }

      /**
       * @private
       */
    }, {
      key: "$getReplaceVal",
      value: function $getReplaceVal() {
        return this.queryWidget("compactLayout/paramTable/replaceRow/replaceCell/replaceVal");
      }

      /**
       * @private
       */
    }, {
      key: "$getMatchCase",
      value: function $getMatchCase() {
        return this.queryWidget("compactLayout/paramTable/matchCaseRow/matchCaseCell/matchCase");
      }

      /**
       * @private
       */
    }, {
      key: "$getMatchWord",
      value: function $getMatchWord() {
        return this.queryWidget("compactLayout/paramTable/matchWordRow/matchWordCell/matchWord");
      }

      /**
      * @private
      */
    }, {
      key: "$applyChanges",
      value: function $applyChanges() {
        var _this5 = this;
        if (this.getFormFactor() !== miniFormFactor) {
          return Promise.all([
          // Since I am using an array to populate the datalist, it was returning the entry of
          //  array for the value instead of the value.  Since any number could be a valid input
          //  I had to get the inputted value from the text element directly
          this.$getSrchVal().read(), this.$getReplaceVal().read(), this.$getMatchCase().read(), this.$getMatchWord().read()]).then(function (_ref3) {
            var _ref4 = _slicedToArray(_ref3, 4),
              srchVal = _ref4[0],
              replaceVal = _ref4[1],
              matchCase = _ref4[2],
              matchWord = _ref4[3];
            if (srchVal) {
              _this5.$hldMatchWord = matchWord;
              _this5.$hldMatchCase = matchCase;
              _this5.$lastSrch = srchVal;
              _this5.$lastReplace = replaceVal;
              var param = "g";

              //This line escapes special values used by RegExp
              // eslint-disable-next-line no-useless-escape
              srchVal = srchVal.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
              if (matchWord) {
                srchVal = "\\b" + srchVal + "\\b";
              }
              if (!matchCase) {
                param = param + "i";
              }
              var srchRegx = new RegExp(srchVal, param);
              for (var i = 0; i < _this5.$strValArray.length; i++) {
                var rowData = _this5.$strValArray[i];
                var oldVal = rowData.currStrValue;
                if (oldVal) {
                  var newVal = oldVal.replace(srchRegx, replaceVal);
                  rowData.newStrValue = newVal;
                  var row = rowData.row;
                  propose(row, 'mgr.batch.proposed.' + _this5.$colName, newVal);
                }
              }
            } else {
              //If no search value is provided then back out all previous changes
              for (var _i = 0; _i < _this5.$strValArray.length; _i++) {
                var _rowData = _this5.$strValArray[_i];
                var _oldVal = _rowData.currStrValue;
                _rowData.newStrValue = _oldVal;
                var _row = _rowData.row;
                propose(_row, 'mgr.batch.proposed.' + _this5.$colName, _oldVal);
              }
            }
            return _this5.rerender();
          });
        }
      }
    }, {
      key: "doRead",
      value: function doRead() {
        if (this.getFormFactor() === miniFormFactor) {
          return this.$getStrVal().read();
        } else {
          return this.$strValArray[0].newStrValue;
        }
      }

      /*
       * Switched from doDestory to doSave once the save of in the PopoutCommand for this was resolved
       *  as part of NCCB-53988
       * @since Niagara 4.13
       */
    }, {
      key: "doSave",
      value: function doSave() {
        var _arguments = arguments,
          _this6 = this;
        if (this.getFormFactor() !== miniFormFactor && !baja.isOffline()) {
          return saveSearches(this.$searchList, this.$lastSrch, this.$replaceList, this.$lastReplace).then(function () {
            return _superPropGet(MgrStringEditor, "doSave", _this6, 3)(_arguments);
          });
        } else {
          return _superPropGet(MgrStringEditor, "doSave", this, 3)(arguments);
        }
      }
    }]);
  }(spandrel(function (strValue, params) {
    return this.$buildEditor(strValue, params.formFactor);
  }, {
    strategy: 'niagara'
  }));
  return MgrStringEditor;
});
