function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/IconOrdEditor
 */

define(["baja!", 'baja!baja:Icon', 'lex!webEditors', 'underscore', 'Promise', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget', 'nmodule/webEditors/rc/servlets/registry'], function (baja, types, lexs, _, Promise, spandrel, ValueWithPopoutWidget, registry) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    WEB_EDITORS_LEX = _lexs[0];
  var EXCLUDED_FILE_TYPES = ['file:IcoFile', 'template:MemoryImageFile'];
  var isFunction = _.isFunction,
    once = _.once;
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'webEditors',
      keyName: 'IconOrdEditor',
      properties: {
        rootCssClass: '-t-IconOrdEditor'
      }
    };
  };
  var getRegisteredIconTypes = once(function () {
    return registry.getTypes({
      targetType: 'file:IImageFile',
      showAbstract: false,
      showInterface: false
    }).then(function (types) {
      return Object.keys(types).map(function (key) {
        return types[key].type;
      }).filter(function (type) {
        return !EXCLUDED_FILE_TYPES.includes(type);
      });
    });
  });

  /**
   * IconOrdEditors for editing icon values by selecting icons
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/IconOrdEditor
   * @extends module:bajaux/spandrel
   * @since Niagara 4.15
   */
  var IconOrdEditor = /*#__PURE__*/function (_spandrel) {
    function IconOrdEditor(params) {
      _classCallCheck(this, IconOrdEditor);
      return _callSuper(this, IconOrdEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * Builds the editor for selecting the icon ord
     * @private
     * @param {Object} state the current state of the editor
     * @param {Array<String>} iconTypes the type specs that can be selected
     * @returns {Object}
     */
    _inherits(IconOrdEditor, _spandrel);
    return _createClass(IconOrdEditor, [{
      key: "$buildEditor",
      value: function $buildEditor(state, iconTypes) {
        var ord = state.ord;
        return [spandrel.jsx(ValueWithPopoutWidget, {
          bind: true,
          spandrelKey: "ord",
          value: ord,
          properties: {
            popoutCssClass: 'ux-btn-tb',
            allowHyperlink: false,
            expansionOrdWhenNull: 'module://icons/x16',
            displayFilter: function displayFilter(parent, child) {
              var childValue = child && child.value();
              if (childValue) {
                return iconTypes.includes(childValue.getNavTypeSpec());
              }
              return true;
            },
            selectFilter: function selectFilter(ord) {
              if (!ord || ord.isNull()) {
                return true;
              }
              return ord.get().then(function (selected) {
                if (selected && isFunction(selected.getMimeType) && selected.getMimeType().startsWith('image/')) {
                  return true;
                }
                throw new Error(WEB_EDITORS_LEX.get('iconEditor.unsupportedType.message'));
              });
            }
          }
        })];
      }

      /**
       * @param {module:baja/obj/Icon} icon the icon value to be loaded
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(icon) {
        if (icon && icon.getType().is('baja:Icon')) {
          return _superPropGet(IconOrdEditor, "doLoad", this, 3)([icon]);
        }
        return Promise.reject(new Error(WEB_EDITORS_LEX.get('iconEditor.unsupportedType.message')));
      }

      /**
       * Puts the ord of the icon value into the state for the editor
       * @param {module:baja/obj/Icon} icon the icon that needs to be edited
       * @returns {Object}
       */
    }, {
      key: "toState",
      value: function toState(icon) {
        var ords = icon.getImageOrds();
        var ord = ords[0] || baja.Ord.DEFAULT;
        return {
          ord: ord
        };
      }

      /**
       * Returns the current state ord value as an icon
       * @param {Object} state
       * @returns {module:baja/obj/Icon}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var _this$state = this.state(),
          ord = _this$state.ord;
        return ord && ord !== baja.Ord.DEFAULT ? new baja.Icon([ord]) : baja.Icon.DEFAULT;
      }

      /**
       * Returns the widget used for selecting an icon
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getOrdWidget",
      value: function $getOrdWidget() {
        return this.queryWidget('ord');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    var getDisplayableTypes = function getDisplayableTypes() {
      return getRegisteredIconTypes().then(function (iconTypes) {
        return ['baja:FileSystem', 'baja:Directory', 'baja:ModuleSpace', 'baja:ModuleNavNode', 'baja:ModuleDirectory'].concat(_toConsumableArray(iconTypes));
      });
    };
    return getDisplayableTypes().then(function (iconTypes) {
      return self.$buildEditor(state, iconTypes);
    });
  }));
  return IconOrdEditor;
});
