function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/FacetsRowEditor
 */
define(['baja!', 'lex!webEditors', 'log!nmodule.webEditors.rc.fe.baja.FacetsRowEditor', 'jquery', 'Promise', 'bajaux/events', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/PopOutEditor', 'nmodule/webEditors/rc/util/Switchboard', 'hbs!nmodule/webEditors/rc/fe/baja/template/FacetsEditor-row'], function (baja, lexs, log, $, Promise, events, BaseWidget, fe, BaseEditor, DisplayOnlyEditor, OrderedMapEditor, PopOutEditor, Switchboard, tplFacetsRowEditor) {
  'use strict';

  var DESTROY_EVENT = events.DESTROY_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT,
    VALUE_READY_EVENT = BaseWidget.VALUE_READY_EVENT,
    ROW_REMOVED_EVENT = 'FacetsRowEditor:rowRemoved',
    logError = log.severe.bind(log),
    webEditorsLex = lexs[0];

  //TODO: move these elsewhere when implementing servlet/whatever
  var DEFAULT_KEYS = function () {
    var map = new baja.OrderedMap();
    map.put('allowNull', 'b');
    map.put('cellEditor', 's');
    map.put('chartLimitMode', 's');
    map.put('chartMax', 'f');
    map.put('chartMin', 'f');
    map.put('falseText', 's');
    map.put('fieldEditor', 's');
    map.put('fieldWidth', 'i');
    map.put('forceSign', 'b');
    map.put('max', 'f');
    map.put('maxOverrideDuration', 'r');
    map.put('min', 'f');
    map.put('multiLine', 'b');
    map.put('ordRelativize', 'b');
    map.put('precision', 'i');
    map.put('radix', 'i');
    map.put('range', 'E');
    map.put('realms', 's');
    map.put('showDate', 'b');
    map.put('showMilliseconds', 'b');
    map.put('showSeconds', 'b');
    map.put('showSeparators', 'b');
    map.put('showTime', 'b');
    map.put('showTimeZone', 'b');
    map.put('showUnits', 'b');
    map.put('targetType', 's');
    map.put('trueText', 's');
    map.put('units', 'u');
    map.put('uxFieldEditor', 's');
    return map;
  }();

  //TODO: uncomment as additional field editors are implemented
  var DEFAULT_TYPES = function () {
    var map = new baja.OrderedMap();
    map.put('baja:AbsTime', 'a');
    map.put('baja:Boolean', 'b');
    map.put('baja:Double', 'd');
    map.put('baja:DynamicEnum', 'e');
    map.put('baja:EnumRange', 'E');
    map.put('baja:Float', 'f');
    map.put('baja:Integer', 'i');
    map.put('baja:Long', 'l');
    map.put('baja:Marker', 'm');
    map.put('baja:Ord', 'o');
    map.put('baja:String', 's');
    map.put('baja:RelTime', 'r');
    map.put('baja:TimeZone', 'z');
    map.put('baja:Unit', 'u');
    return map;
  }();

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  /**
   * Get the default value to load into the editor when selecting a new type.
   *
   * @private
   * @inner
   * @param {String} typeSpec
   * @returns {baja.Value}
   */
  function getDefaultValue(typeSpec) {
    if (typeSpec === 'baja:AbsTime') {
      return baja.AbsTime.now();
    }
    return baja.$(typeSpec);
  }

  ////////////////////////////////////////////////////////////////
  // FacetsRowEditor definition
  ////////////////////////////////////////////////////////////////

  /**
   * An editor for working with a single row in a `FacetsEditor`. No
   * reason to load it anywhere else but inside that editor.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/FacetsRowEditor
   */
  var FacetsRowEditor = function FacetsRowEditor() {
    var that = this;
    BaseEditor.apply(that, arguments);
    new Switchboard(that).allow('$keyChanged').oneAtATime();
    that.on(VALUE_READY_EVENT, function (value) {
      return that.$getValueEditor().emitAndWait(VALUE_READY_EVENT, value);
    });
  };
  FacetsRowEditor.prototype = Object.create(BaseEditor.prototype);
  FacetsRowEditor.prototype.constructor = FacetsRowEditor;

  /**
   * Triggered when the user clicks the delete button to remove this row.
   */
  FacetsRowEditor.ROW_REMOVED_EVENT = ROW_REMOVED_EVENT;

  /**
   * @private
   * @returns {Promise<baja.OrderedMap>}
   */
  FacetsRowEditor.prototype.$getDefaultFacetKeys = function () {
    return this.$canShowDefaultFacets() ? FacetsRowEditor.getDefaultFacetKeys() : Promise.resolve(new baja.OrderedMap());
  };

  /**
   * @private
   * @returns {boolean}
   */
  FacetsRowEditor.prototype.$canShowDefaultFacets = function () {
    return this.properties().getValue('hideDefaultKeys') !== true;
  };

  /**
   * Return true if I can change the type spec in this row.
   *
   * @private
   * @returns {boolean}
   */
  FacetsRowEditor.prototype.$isAllowChangeType = function () {
    return this.properties().getValue('allowChangeType') !== false;
  };

  /**
   * Return true if I can delete this row.
   *
   * @private
   * @returns {boolean}
   */
  FacetsRowEditor.prototype.$isAllowDelete = function () {
    return this.properties().getValue('allowDelete') !== false;
  };

  /**
   * Return true if I can change the key name in this row.
   *
   * @private
   * @returns {boolean}
   */
  FacetsRowEditor.prototype.$isAllowRename = function () {
    return this.properties().getValue('allowRename') !== false;
  };

  /**
   * Get the element containing the popout button.
   *
   * @private
   * @returns {jQuery}
   */
  FacetsRowEditor.prototype.$getPopOutElement = function () {
    return this.jq().children('.expand');
  };

  /**
   * Get the PopOutEditor for editing values like EnumRanges in more detail.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/PopOutEditor}
   */
  FacetsRowEditor.prototype.$getPopOutEditor = function () {
    return this.$getPopOutElement().data('widget');
  };

  /**
   * Get the element containing the key editor.
   *
   * @private
   * @returns {jQuery}
   */
  FacetsRowEditor.prototype.$getKeyElement = function () {
    return this.jq().children('.key');
  };

  /**
   * Get the editor for the facet key.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
   */
  FacetsRowEditor.prototype.$getKeyEditor = function () {
    return this.jq().children('.key').data('widget');
  };

  /**
   * Get the element containing the type editor.
   *
   * @private
   * @returns {jQuery}
   */
  FacetsRowEditor.prototype.$getTypeElement = function () {
    return this.jq().children('.type');
  };

  /**
   * Get the editor for the type spec.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  FacetsRowEditor.prototype.$getTypeEditor = function () {
    return this.$getTypeElement().data('widget');
  };

  /**
   * Get the element containing the value editor.
   *
   * @private
   * @returns {jQuery}
   */
  FacetsRowEditor.prototype.$getValueElement = function () {
    return this.jq().children('.value');
  };

  /**
   * Get the editor for the value.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor}
   */
  FacetsRowEditor.prototype.$getValueEditor = function () {
    return this.$getValueElement().data('widget');
  };

  /**
   * When a new type spec is selected, load the appropriate default value into
   * the value editor and initialize the popout button if appropriate.
   *
   * @private
   * @param {String} typeSpec
   * @returns {Promise} promise to be resolved when the new default value
   * for that type spec has been loaded into the row
   */
  FacetsRowEditor.prototype.$setSelectedTypeSpec = function (typeSpec) {
    var that = this,
      valueDom = that.$getValueElement(),
      popOutDom = that.$getPopOutElement(),
      valueEd = that.$getValueEditor(),
      popOutEd = that.$getPopOutEditor(),
      value = getDefaultValue(typeSpec);
    return Promise.all([valueEd.destroy(), popOutEd.destroy()]).then(function () {
      return fe.buildFor({
        value: value,
        dom: valueDom,
        formFactor: 'mini'
      });
    }).then(function (ed) {
      that.setModified(true);
      return fe.buildFor({
        type: PopOutEditor,
        value: ed,
        dom: popOutDom
      });
    });
  };

  /**
   * @returns {Promise}
   */
  FacetsRowEditor.prototype.$keyChanged = function () {
    var that = this,
      keyEd = that.$getKeyEditor();
    return Promise.all([keyEd.read(), that.$getDefaultFacetKeys()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        key = _ref2[0],
        keys = _ref2[1];
      if (that.$isAllowChangeType()) {
        var dataSymbol = keys.get(key);
        if (dataSymbol) {
          that.$getTypeEditor().setSelectedValue(dataSymbol, true);
          that.$setSelectedTypeSpec(that.$getTypeEditor().getSelectedKey())["catch"](logError);
        }
      }
    });
  };

  //TODO: keys come from facetKeys.properties
  /**
   * Return the list of default keys to use in the dropdown for the `key` field.
   *
   * @returns {Promise} promise to be resolved with a `baja.OrderedMap`
   * representing a mapping of facet key to data symbol
   */
  FacetsRowEditor.getDefaultFacetKeys = function () {
    return Promise.resolve(DEFAULT_KEYS);
  };

  //TODO: types come from DataTypes.getTypes()
  //TODO: can we exclude DynamicEnum from the types list? since you can't edit range i can't think of a valid use case
  /**
   * Return the list of default types to use in the dropdown for the `type`
   * field.
   *
   * @returns {Promise} promise to be resolved with a `baja.OrderedMap`
   * representing a mapping of type spec to data symbol
   */
  FacetsRowEditor.getDefaultFacetTypes = function () {
    return Promise.resolve(DEFAULT_TYPES);
  };

  /**
   * Initializes a table row with cells for key, type, and value editors, and
   * a delete button.
   *
   * @param {JQuery} dom
   */
  FacetsRowEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html($(tplFacetsRowEditor({
      disabled: !that.isEnabled(),
      allowDelete: that.$isAllowDelete(),
      allowChangeType: that.$isAllowChangeType()
    })));
    dom.on('click', 'button.delete', function () {
      that.trigger(ROW_REMOVED_EVENT);
    });
    dom.on([ENABLE_EVENT, DISABLE_EVENT, LOAD_EVENT, DESTROY_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.key, .value', function () {
      that.setModified(true);
      return false;
    });
    dom.on(MODIFY_EVENT, '.key', function () {
      that.$keyChanged()["catch"](logError);
    });
    dom.on(MODIFY_EVENT, '.type', function (e, typeEd) {
      var type = typeEd.getSelectedKey();
      that.$setSelectedTypeSpec(type)["catch"](logError);
      return false;
    });
  };

  /**
   * Loads field editors for key, type, and value.
   *
   * @param {Object} obj object with key/value data
   * @param {String} obj.key the facets key to load
   * @param {baja.Value} obj.value the facets value to load
   * @returns {Promise} promise to be resolved when key, type, and value
   * editors have finished loading
   */
  FacetsRowEditor.prototype.doLoad = function (obj) {
    var that = this,
      dom = that.jq(),
      key = obj && obj.key,
      value = obj && obj.value;
    if (!baja.hasType(key, 'baja:String') || !baja.hasType(value)) {
      throw new Error('key and value properties required');
    }
    return Promise.all([that.$getDefaultFacetKeys(), FacetsRowEditor.getDefaultFacetTypes(), that.getChildWidgets().destroyAll()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        defaultKeys = _ref4[0],
        defaultTypes = _ref4[1];
      return Promise.all([
      //key
      that.buildChildFor({
        value: key,
        dom: dom.children('.key'),
        type: that.$isAllowRename() ? undefined : DisplayOnlyEditor,
        properties: {
          datalist: defaultKeys.getKeys().join(';')
        },
        formFactor: 'mini'
      }).then(function () {
        that.jq().find('.key').attr("data-cell-prefix", webEditorsLex.get('FacetsEditor.key'));
      }),
      //type
      that.$isAllowChangeType() && that.buildChildFor({
        value: defaultTypes,
        dom: dom.children('.type'),
        loadParams: {
          selectedKey: String(value.getType())
        },
        type: OrderedMapEditor,
        formFactor: 'mini'
      }).then(function () {
        that.jq().find('.type').attr("data-cell-prefix", webEditorsLex.get('FacetsEditor.type'));
      }),
      //value
      that.buildChildFor({
        value: value,
        dom: dom.children('.value'),
        properties: {
          uxFieldEditor: that.properties().getValue('uxFieldEditor')
        },
        formFactor: 'mini'
      }).then(function (valueEd) {
        that.jq().find('.value').attr("data-cell-prefix", webEditorsLex.get('FacetsEditor.value'));
        return fe.buildFor({
          type: PopOutEditor,
          value: valueEd,
          dom: dom.children('.expand')
        });
      })]);
    });
  };

  /**
   * Reads key and value editors and returns a new key/value object.
   *
   * @returns {Promise} promise to be resolved with an object with
   * `key` and `value` properties
   */
  FacetsRowEditor.prototype.doRead = function () {
    return Promise.all([this.$getKeyEditor().read(), this.$getValueEditor().read()]).then(function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 2),
        key = _ref6[0],
        value = _ref6[1];
      return {
        key: key,
        value: value
      };
    });
  };

  /**
   * Enables/disables all child editors and the delete button.
   *
   * @param {Boolean} enabled
   * @returns {Promise} promise to be resolved when all child editors
   * have been enabled/disabled
   */
  FacetsRowEditor.prototype.doEnabled = function (enabled) {
    this.jq().find('button').prop('disabled', this.isReadonly() || !enabled);
    return this.getChildWidgets().setAllEnabled(enabled);
  };

  /**
   * Sets all child editors readonly/writable and disables/enables the delete
   * button.
   *
   * @param {Boolean} readonly
   * @returns {Promise} promise to be resolved when all child editors
   * are readonly/writable
   */
  FacetsRowEditor.prototype.doReadonly = function (readonly) {
    this.jq().find('button').prop('disabled', !this.isEnabled() || readonly);
    return this.getChildWidgets().setAllReadonly(readonly);
  };

  /**
   * Destroys all child editors.
   *
   * @returns {Promise} promise to be resolved when all child editors
   * have been destroyed
   */
  FacetsRowEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };
  return FacetsRowEditor;
});
