function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/BooleanPicker
 */

define(['bajaux/spandrel', 'Promise', 'underscore'], function (spandrel, Promise, _) {
  'use strict';

  var contains = _.contains;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-BooleanPicker'
      }
    };
  };

  /**
   * Given an array of values, show a boolean editor for each one to allow the user to pick which
   * ones they want. The values can be of any type.
   *
   * It supports the following Properties:
   *
   * - `choices`: much like an EnumRange, this represents the total array of choices from which the
   *   user can pick. This may be just an array of strings, or Choice objects (see corresponding
   *   typedef).
   * - `displayType`: `checkbox`, `slider`, `auto`, or omitted will allow the user to pick multiple
   *   values from an array of boolean choices; the input value must then be an array of values, and
   *   an array of selected values will be read out. Use `radio` to enforce that the user picks
   *   exactly one; the input value will then be the one selected value, and that one selected value
   *   will be read out.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/BooleanPicker
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.13
   */
  var BooleanPicker = /*#__PURE__*/function (_spandrel) {
    function BooleanPicker(params) {
      _classCallCheck(this, BooleanPicker);
      return _callSuper(this, BooleanPicker, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @returns {Promise.<Array.<*>>} the values that the user has chosen
     */
    _inherits(BooleanPicker, _spandrel);
    return _createClass(BooleanPicker, [{
      key: "doRead",
      value: function doRead() {
        var checkboxes = this.$getBooleanEditors();
        var values = checkboxes.map(function (ed) {
          return ed.properties().getValue('value');
        });
        var isRadio = this.properties().getValue('displayType') === 'radio';
        return Promise.all(checkboxes.map(function (ed) {
          return ed.read();
        })).then(function (booleans) {
          var selectedValues = values.filter(function (v, i) {
            return booleans[i];
          });
          return isRadio ? selectedValues[0] : selectedValues;
        });
      }

      /**
       * @private
       * @returns {Array.<module:nmodule/webEditors/rc/fe/baja/BooleanPicker~Choice>}
       */
    }, {
      key: "$getChoices",
      value: function $getChoices() {
        var choices = this.properties().getValue('choices') || [];
        return choices.map(function (choice) {
          if (typeof choice === 'string') {
            return {
              trueText: choice,
              falseText: choice,
              value: choice
            };
          }
          var display = choice.display,
            falseText = choice.falseText,
            trueText = choice.trueText,
            falseIcon = choice.falseIcon,
            trueIcon = choice.trueIcon,
            value = choice.value,
            hidden = choice.hidden,
            readonly = choice.readonly;
          display = display || String(value);
          return {
            falseText: falseText || display,
            trueText: trueText || display,
            falseIcon: falseIcon,
            trueIcon: trueIcon,
            hidden: hidden,
            readonly: readonly,
            value: value
          };
        });
      }

      /**
       * @private
       * @returns {Array.<module:bajaux/Widget>}
       */
    }, {
      key: "$getBooleanEditors",
      value: function $getBooleanEditors() {
        return this.queryWidgets('*');
      }
    }]);
  }(spandrel(function (inputValue, _ref) {
    var properties = _ref.properties,
      self = _ref.self,
      writable = _ref.writable;
    var choices = self.$getChoices();
    var displayType = properties.displayType;
    var isRadio = displayType === 'radio';
    var name = isRadio ? self.generateId() : '';
    return choices.map(function (_ref2) {
      var trueText = _ref2.trueText,
        falseText = _ref2.falseText,
        trueIcon = _ref2.trueIcon,
        falseIcon = _ref2.falseIcon,
        hidden = _ref2.hidden,
        readonly = _ref2.readonly,
        value = _ref2.value;
      return spandrel.jsx("any", {
        tagName: "span",
        value: isRadio ? inputValue === value : contains(inputValue, value),
        style: {
          display: hidden && 'none'
        },
        properties: {
          displayType: displayType,
          trueText: trueText,
          falseText: falseText,
          trueIcon: trueIcon,
          falseIcon: falseIcon,
          name: name,
          value: value
        },
        readonly: !writable || readonly
      });
    });
  }, {
    strategy: 'niagara'
  }));
  /**
   * Represents one choice in a boolean picker. The values read out can _only_ correspond to these
   * choices, so if a choice is omitted, it will not be included in the read value even if it was
   * loaded in. If you want a choice not to be shown to the user, but still included in the result
   * if it was originally there, use the `hidden` property.
   *
   * @typedef {object} module:nmodule/webEditors/rc/fe/baja/BooleanPicker~Choice
   * @property {string} [display] display string (possibly a Format string) for both true and false.
   * Alternately, set trueText/falseText. If none are provided, the value will be toStringed.
   * @property {string} [trueText]
   * @property {string} [falseText]
   * @property {string} [trueIcon]
   * @property {string} [falseIcon]
   * @property {boolean} [readonly]
   * @property {boolean} [hidden] if true, this choice will not be shown to the user, but will still
   * have a value loaded and read.
   * @property {*} value
   */
  return BooleanPicker;
});
