function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/ValueWithPopoutWidget
 */
define(['bajaux/spandrel', 'bajaux/util/CommandButton', 'Promise', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/commands/PopOutCommand', 'nmodule/webEditors/rc/wb/options/MruButton', 'nmodule/webEditors/rc/wb/options/MruOptions'], function (spandrel, CommandButton, Promise, typeUtils, fe, PropertySheet, PopOutCommand, MruButton, MruOptions) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ValueWithPopoutWidget',
        config: {}
      }
    };
  };
  var isAssignableFrom = typeUtils.isAssignableFrom;

  /**
   * A field editor for providing a regular Editor with an adjacent Popout Widget if it applies.
   * If an appropriate editor cannot be found and the editor is a Complex, a PropertySheet should be provided.
   *
   * It supports the following bajaux properties:
   * - `getConfig`: the construction of the inner field editor can be configured by passing a `getConfig` function
   * as a Widget property. It should return an object of type {@link module:bajaux/lifecycle/WidgetManager~BuildParams}.
   * - `popoutCssClass`: This string will be added to the Css classes for the PopOutCommand.
   * - `mruName`: If this string is present and the value is a BSimple, a `MruButton` will also be provided.
   *
   * @class
   * @alias nmodule/webEditors/rc/fe/ValueWithPopoutWidget
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.14
   */
  var ValueWithPopoutWidget = /*#__PURE__*/function (_spandrel) {
    function ValueWithPopoutWidget(params) {
      var _this;
      _classCallCheck(this, ValueWithPopoutWidget);
      _this = _callSuper(this, ValueWithPopoutWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$popOutCommand = new PopOutCommand();
      return _this;
    }
    _inherits(ValueWithPopoutWidget, _spandrel);
    return _createClass(ValueWithPopoutWidget, [{
      key: "doRead",
      value: function doRead() {
        return this.getInnerValueEditor().read();
      }
    }, {
      key: "doSave",
      value: function doSave(value) {
        var _this2 = this;
        return this.getInnerValueEditor().save().then(function () {
          var mruName = _this2.properties().getValue("mruName");
          if (mruName) {
            return MruOptions.make(mruName).then(function (mruOptions) {
              mruOptions.add(value.encodeToString());
              return mruOptions.save();
            });
          }
        });
      }

      /**
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getInnerValueEditor",
      value: function getInnerValueEditor() {
        return this.queryWidget('wrapper/value');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getPopOutCommandButton",
      value: function $getPopOutCommandButton() {
        return this.queryWidget('wrapper/popOut');
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/options/MruButton|undefined}
       */
    }, {
      key: "$getMruButton",
      value: function $getMruButton() {
        return this.queryWidget('wrapper/mru');
      }
    }]);
  }(spandrel(function (value, _ref) {
    var self = _ref.self,
      properties = _ref.properties,
      formFactor = _ref.formFactor;
    var popoutCssClass = '';
    var _properties$getConfig = properties.getConfig,
      getConfig = _properties$getConfig === void 0 ? function () {
        return {
          formFactor: formFactor,
          properties: properties
        };
      } : _properties$getConfig;
    var config = getConfig();
    var mruName = value.getType().isSimple() && properties.mruName;
    return Promise.all([resolveConstructor(value, config), mruName && MruOptions.make(mruName)]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        Ctor = _ref3[0],
        mruOptions = _ref3[1];
      if (isAssignableFrom(PropertySheet, Ctor)) {
        config.properties = Object.assign({
          readBehavior: 'copy'
        }, properties);
      }
      var select;
      if (mruOptions) {
        select = function select(val) {
          return self.getInnerValueEditor().loadAndModify(value.getType().getInstance().decodeFromString(val));
        };
      }
      var prop = config.properties;
      popoutCssClass = prop ? config.properties.popoutCssClass || '' : '';
      return spandrel.jsx("div", {
        className: "-t-ValueWithPopoutWidget-wrapper",
        spandrelKey: "wrapper"
      }, spandrel.jsx(Ctor, {
        className: "-t-ValueWithPopoutWidget-value",
        spandrelKey: "value",
        value: value,
        onUxLoad: function onUxLoad(e, ed) {
          return self.$popOutCommand.setWatchedEditor(ed);
        },
        formFactor: config.formFactor,
        properties: prop,
        readonly: config.readonly,
        enabled: config.enabled,
        validate: true
      }), spandrel.jsx(CommandButton, {
        spandrelKey: "popOut",
        className: "-t-popOutCommandButton " + popoutCssClass,
        value: self.$popOutCommand
      }), mruName && spandrel.jsx(MruButton, {
        spandrelKey: "mru",
        className: "-t-ValueWithPopoutWidget-mruButton",
        readonly: config.readonly,
        enabled: config.enabled,
        value: {
          options: mruOptions,
          select: select
        }
      }));
    });
  }, {
    strategy: 'niagara'
  }));
  /**
   *
   * @param {baja.Value} value
   * @param {Function} config
   * @returns {Promise}
   */
  function resolveConstructor(value, config) {
    return fe.params(Object.assign({
      value: value
    }, config)).then(function (params) {
      return params.getWidgetConstructor();
    }).then(function (ctor) {
      return ctor || value.getType().isComplex() && PropertySheet;
    });
  }
  return ValueWithPopoutWidget;
});
