function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/ValueWithCheckbox
 */
define(['jquery', 'bajaux/events', 'bajaux/spandrel', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget'], function ($, events, spandrel, Widget, ValueWithPopoutWidget) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ValueWithCheckbox',
        checked: false,
        config: {},
        name: '',
        displayType: 'checkbox',
        label: ''
      }
    };
  };
  function callCheckedForWidget(widget) {
    return widget.getCheckBoxEditor().read().then(function (checkedValue) {
      widget.$checked(checkedValue);
    })["catch"](function () {});
  }

  /**
   * A field editor for providing a regular Editor with an adjacent checkbox.
   *
   * It supports the following bajaux properties:
   * - `checked`: the initial checkbox is checked (defaults to false)
   * - `getConfig`: the construction of the inner field editor can be configured by passing a `getConfig` function
   * as a Widget property. It should return an object of type {@link module:bajaux/lifecycle/WidgetManager~BuildParams}.
   * - `displayType`: defaults to `checked`. If set to `radio`, make sure to set the `name` property and add `-t-ValueWithCheckbox-root`
   * and css classList of an element that is a common ancestor for all the ValueWithCheckbox widgets. This allows the other checkboxes
   * to receive the proper event for deselection.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/ValueWithCheckbox
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.15
   */
  var ValueWithCheckbox = /*#__PURE__*/function (_spandrel) {
    function ValueWithCheckbox(params) {
      _classCallCheck(this, ValueWithCheckbox);
      return _callSuper(this, ValueWithCheckbox, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @param {boolean} checkedValue
     */
    _inherits(ValueWithCheckbox, _spandrel);
    return _createClass(ValueWithCheckbox, [{
      key: "$checked",
      value: function $checked(checkedValue) {
        this.properties().setValue('checked', checkedValue);
      }
    }, {
      key: "doRead",
      value: function doRead() {
        return this.getInnerValueEditor().read();
      }
    }, {
      key: "doSave",
      value: function doSave() {
        return this.getInnerValueEditor().save();
      }

      /**
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getCheckBoxEditor",
      value: function getCheckBoxEditor() {
        return this.queryWidget('wrapper/checkbox');
      }

      /**
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "getInnerValueEditor",
      value: function getInnerValueEditor() {
        return this.queryWidget('wrapper/value');
      }
    }]);
  }(spandrel(function (value, _ref) {
    var self = _ref.self,
      properties = _ref.properties,
      formFactor = _ref.formFactor,
      readonly = _ref.readonly,
      enabled = _ref.enabled;
    var checked = properties.checked,
      label = properties.label,
      displayType = properties.displayType,
      name = properties.name;
    checked = !!checked;
    var innerProperties = Object.assign({}, properties);
    if (!innerProperties.getConfig) {
      innerProperties.getConfig = function () {
        return {
          formFactor: formFactor,
          properties: properties
        };
      };
    }
    return spandrel.jsx("div", {
      className: "-t-ValueWithCheckbox-wrapper",
      spandrelKey: "wrapper"
    }, spandrel.jsx("any", {
      bind: true,
      lax: true,
      className: "-t-ValueWithCheckbox-checkbox",
      spandrelKey: "checkbox",
      value: checked,
      properties: {
        displayType: displayType,
        name: name,
        trueText: label,
        falseText: label
      },
      on: _defineProperty({}, MODIFY_EVENT, function () {
        if (displayType === 'radio' && name) {
          //the other radios buttons will be deselected, but won't get a MODIFY_EVENT. This makes they do.
          var radiosButtonPeers = self.jq().closest('.-t-ValueWithCheckbox-root').find(".-t-ValueWithCheckbox");
          radiosButtonPeers.each(function () {
            var valueWithCheckBox = Widget["in"]($(this));
            if (valueWithCheckBox.properties().getValue('name') === name) {
              callCheckedForWidget(valueWithCheckBox);
            }
          });
        } else {
          callCheckedForWidget(self);
        }
        return false;
      })
    }), spandrel.jsx(ValueWithPopoutWidget, {
      validate: true,
      bind: true,
      lax: true,
      properties: innerProperties,
      value: value,
      spandrelKey: "value",
      readonly: !checked || readonly,
      enabled: checked && enabled,
      bindKey: "value"
    }));
  }, {
    strategy: 'niagara'
  }));
  return ValueWithCheckbox;
});
