function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */
/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/RadioButtonGroup
 *
 */

define(['bajaux/spandrel'], function (spandrel) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ux-RadioButtonGroup'
      }
    };
  };

  /**
   * RadioButtonGroup takes a list of String options and turns them as a radio
   * button group.
   * Example
   * const radioGroup = new RadioButtonGroup({
   *    properties: {
   *      options: [ {
   *        displayName: 'a',
   *        value: '1'
   *      }, {
   *        displayName: 'b',
   *        value: '2'
   *      } ]
   *    }
   * })
   *
   * // If a specific option needs to be checked by default just call
   * // load with that value, say,
   * return radioGroup.load('2') // will check the second option in the above example.
   *
   * The first option will be automatically checked if no default is explicitly set.
   *
   * Note: value ONLY supports Strings
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/RadioButtonGroup
   */
  return /*#__PURE__*/function (_spandrel) {
    function RadioButtonGroup(params) {
      var _this;
      _classCallCheck(this, RadioButtonGroup);
      _this = _callSuper(this, RadioButtonGroup, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$uniqueId = _this.generateId(); // only generate once during construction
      return _this;
    }
    _inherits(RadioButtonGroup, _spandrel);
    return _createClass(RadioButtonGroup, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.on('click', 'input[type=radio]', function (e) {
          _this2.state({
            selectedValue: e.target.value
          });
          _this2.setModified(true);
        });
      }
    }, {
      key: "toState",
      value: function toState(value) {
        var properties = this.properties(),
          options = properties.getValue('options') || [],
          selectedOption = options.filter(function (option) {
            return option.value === value;
          });
        if (selectedOption.length === 0 && options.length > 0) {
          return {
            selectedValue: options[0].value
          };
        }
        return {
          selectedValue: value
        };
      }
    }, {
      key: "fromState",
      value: function fromState(obj) {
        return obj.selectedValue;
      }

      /**
       * @private
       * @param {object} option
       * @param {number} index
       * @param {string} selectedValue
       * @param {string} groupName
       * @returns {object}
       */
    }, {
      key: "$buildFor",
      value: function $buildFor(option, index, selectedValue, groupName) {
        var value = option.value,
          displayName = option.displayName;
        var key = 'option' + index;
        var id = this.generateId(),
          writable = this.state().writable;
        return spandrel.jsx("div", {
          "class": "container",
          spandrelKey: key
        }, spandrel.jsx("input", {
          type: "radio",
          name: groupName,
          value: value,
          checked: selectedValue === value,
          id: id,
          disabled: !writable
        }), spandrel.jsx("label", {
          "for": id
        }, displayName));
      }
    }]);
  }(spandrel(function (value, _ref) {
    var self = _ref.self,
      properties = _ref.properties;
    var _ref2 = properties || {},
      _ref2$options = _ref2.options,
      options = _ref2$options === void 0 ? [] : _ref2$options,
      _self$state = self.state(),
      selectedValue = _self$state.selectedValue;
    var uniqueName = self.$uniqueId || self.generateId();
    return options.map(function (kid, i) {
      return self.$buildFor(kid, i, selectedValue, uniqueName);
    });
  }));
});
