/*
 * Copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/* jshint latedef: nofunc, jquery: true */
/* globals save: false, hx: true */

/**
 * JavaScript support for TriggerScheduler.
 * @private
 * @deprecated since Niagara 4.4. Will be removed in a future release.
 */
var triggerSchedule = new TriggerSchedule();
function TriggerSchedule() {
  'use strict';

  this.readonly = false;

  this.init = function (scope) {
    var $ = jQuery,
        originalScope = scope;
    scope = scope ? hx.escapeSelector(scope + '.'): '';

    // Flag for 12 hour vs 24 hour
    this.twelveHour = $('#' + scope + 'triggerSchedule-HxScheduler-startTime\\.time\\.twelveHour').length !== 0;

     // Start these fields disabled.  Field Editors don't do this
    if (this.twelveHour) {
      $('#' + scope + 'triggerSchedule-HxScheduler-rangeEnd\\.time\\.twelveHour').prop({'disabled':true});
    } else {
      $('#' + scope + 'triggerSchedule-HxScheduler-rangeEnd\\.time\\.hour').prop({'disabled':true});
    }
    $('#' + scope + 'triggerSchedule-HxScheduler-rangeEnd\\.time\\.min').prop({'disabled':true});
    $('#' + scope + 'triggerSchedule-HxScheduler-rangeEnd\\.time\\.ampm').prop({'disabled':true});

    // Set some properties on the time input field to overcome deficiencies in the BhxRelTimeFE widget
    $('#' + scope + 'triggerSchedule-HxScheduler-rangeInterval\\.bigHour').prop({
      'size': 2,
      'value': '01',
      'maxlength': 2,
      'disabled': true
    });
    $('#' + scope + 'triggerSchedule-HxScheduler-rangeInterval\\.min').prop({
      'size': 2,
      'value': '00',
      'maxlength': 2,
      'disabled': true
    });
    triggerSchedule.saveTimes(triggerSchedule.getTimes(originalScope), originalScope);
  };

  this.modified = function () {
    if (save !== null && this.readonly === false) {
      save.modified();
    }
  };

  this.onSelectTimes = function (elem, event, scope) {
    var $ = jQuery;
    scope = scope ? hx.escapeSelector(scope + '.'): '';
    $('#' + scope + 'triggerSchedule-HxScheduler-removeButton').prop('disabled', false);
  };

  this.onAddTime = function (elem, event, scope) {
    var $ = jQuery;
    var originalScope = scope;
    scope = scope ? hx.escapeSelector(scope + '.'): '';

    // Get the starting time for the range
    var startHour;
    var startMin;
    var startAmpm;

    if (triggerSchedule.twelveHour) {
      startHour = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-startTime\\.time\\.twelveHour option:selected').text());
      startAmpm = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-startTime\\.time\\.ampm option:selected').text());
    } else {
      startHour = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-startTime\\.time\\.hour option:selected').text());
    }
    startMin = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-startTime\\.time\\.min option:selected').text());

    var startTime = new Time(startHour, startMin, startAmpm);

    var times = [];
    if (!($('#' + scope + 'triggerSchedule-HxScheduler-rangeCheckbox').is(':checked'))) {
      // Range button is not checked
      times.push(startTime.toString());
    } else {
      // Get the ending time for the range
      var endHour;
      var endMin;
      var endAmpm;

      if (triggerSchedule.twelveHour) {
        endHour = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-rangeEnd\\.time\\.twelveHour option:selected').text());
        endAmpm = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-rangeEnd\\.time\\.ampm option:selected').text());
      } else {
        endHour = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-rangeEnd\\.time\\.hour option:selected').text());
      }
      endMin = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-rangeEnd\\.time\\.min option:selected').text());

      var endTime = new Time(endHour, endMin, endAmpm);

      // Get the range interval hour and minute
      var intervalHour = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-rangeInterval\\.bigHour').val());
      var intervalMin = $.trim($('#' + scope + 'triggerSchedule-HxScheduler-rangeInterval\\.min').val());
      if (!parseInt(intervalHour) && !parseInt(intervalMin)) {
        return; //prevent infinite while loop when user chooses 0 hour and 0 min.
      }

      var interval = new Time(intervalHour, intervalMin);

      var currentTime = new Time(startTime);
      do {
        try {
          times.push(new Time(currentTime).toString());
          currentTime = currentTime.add(interval);
        } catch (e) {
          break;
        }
      } while (currentTime <= endTime && times.length <= 1500); // most minutes in a day
    }

    var existingTimes = triggerSchedule.getTimes(originalScope);

    Array.prototype.push.apply(times, existingTimes);

    times.sort(function (o1, o2) {
      var time1 = new Time(o1);
      var time2 = new Time(o2);
      return time1.valueOf() - time2.valueOf();
    });

    // Get rid of duplicates
    times = times.filter(function (o, i, a) {
      return a.indexOf(o) === i;
    });

    $('#' + scope + 'triggerSchedule-HxScheduler-timeSelect').children().remove();
    $.each(times, function (index, value) {
      $('#' + scope + 'triggerSchedule-HxScheduler-timeSelect').append('<option>' + value + '</option>');
    });

    triggerSchedule.saveTimes(times, originalScope);
    triggerSchedule.modified();
  };

  // Get the times from the <Select> in an array
  this.getTimes = function (scope) {
    var $ = jQuery;
    scope = scope ? hx.escapeSelector(scope + '.'): '';

    var options = $('#' + scope + 'triggerSchedule-HxScheduler-timeSelect').children();
    var times = options.map(function (i, o) {
      return $.trim($(o).text());
    });
    return $.makeArray(times);
  };

  // Save times from an array to the text field
  this.saveTimes = function (arr, scope) {
    var $ = jQuery;
    scope = scope ? hx.escapeSelector(scope + '.'): '';
    $('#' + scope + 'triggerSchedule-HxScheduler-timesText').val(arr.toString());
  };

  this.onRemoveTime = function (elem, event, scope) {
    var $ = jQuery,
        originalScope = scope;
    scope = scope ? hx.escapeSelector(scope + '.'): '';

    $('#' + scope + 'triggerSchedule-HxScheduler-timeSelect :selected').remove();
    triggerSchedule.saveTimes(triggerSchedule.getTimes(originalScope), originalScope);
    triggerSchedule.modified();
  };

  this.onClick = function (elem, event, scope) {
    var $ = jQuery;
    scope = scope ? hx.escapeSelector(scope + '.'): '';
    $('#' + scope + 'triggerSchedule-HxScheduler-rangeCheckbox').trigger('click');
  };

  this.onCheckbox = function (elem, event, scope) {
    var $ = jQuery;
    scope = scope ? hx.escapeSelector(scope + '.'): '';

    var $notButton = $('table.triggerSchedule-HxScheduler-rangeInfo select,  table.triggerSchedule-HxScheduler-rangeInfo input');
    if ($('#' + scope + 'triggerSchedule-HxScheduler-rangeCheckbox').is(':checked')) {
      $notButton.prop('disabled', false);
      $('table.triggerSchedule-HxScheduler-rangeInfo td.triggerSchedule-HxScheduler-fieldName').removeClass('triggerSchedule-HxScheduler-disabled');
      $('table.triggerSchedule-HxScheduler-rangeInfo').css('visibility', 'visible');
    } else {
      $notButton.prop('disabled', true);
      $('table.triggerSchedule-HxScheduler-rangeInfo td.triggerSchedule-HxScheduler-fieldName').addClass('triggerSchedule-HxScheduler-disabled');
      $('table.triggerSchedule-HxScheduler-rangeInfo').css('visibility', 'hidden');
    }
  };
}

function Time(hours, minutes, ampm) {
  'use strict';
  // If ampm is ommitted, assume 24 hour time

  if (arguments.length === 1 && !(hours instanceof Time)) {
    // Assume we were passed a single string
    // of the form hh:mm AM|PM or HH:mm
    this._date = new Date('1970/01/01 ' + hours);
  } else if (hours instanceof Time) {
    this._date = new Date(hours._date.getTime());
  } else {
    if (!hours) {
      hours = 0;
    }
    if (!minutes) {
      minutes = 0;
    }
    if (ampm !== 'AM' && ampm !== 'PM') {
      ampm = null;
    }

    this._date = new Date('1970/01/01 ' + hours + ':' + minutes + (ampm ? ' ' + ampm : ''));
  }
}

Time.prototype.add = function (d) {
  'use strict';
  if (d instanceof Time) {
    var myDate = this._date;
    var dayOfMonth = myDate.getDate();
    myDate.setTime(myDate.getTime() + d._date.getHours() * 60* 60 * 1000 + d._date.getMinutes() * 60 * 1000);
    if (dayOfMonth !== myDate.getDate()) {
      throw "Overflow error: " + this.toString();
    }
  } else {
    throw "Invalid object";
  }
  return this;
};

Time.prototype.toString = function () {
  'use strict';
  var myDate = this._date;
  var ampm = 'AM';
  var hours = myDate.getHours();
  var minutes = myDate.getMinutes();
  if (triggerSchedule.twelveHour) {
    if (hours === 0) {
      // Midnight is 12:00 AM
      hours = 12;
    } else if (hours === 12) {
      // Noon is 12:00 PM
      ampm = 'PM';
    } else if (hours > 12) {
      hours -= 12;
      ampm = 'PM';
    }
  }
  return hours + ":" + (minutes >= 10 ? minutes : '0' + minutes) + (triggerSchedule.twelveHour ? ' ' + ampm : '');
};

Time.prototype.valueOf = function () {
  'use strict';
  return this._date.valueOf();
};

Time.prototype.equals = function (otherTime) {
  'use strict';
  return otherTime instanceof Time && this._date.getTime() === otherTime._date.getTime();
};
