function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/ndriver/rc/NPointManager
 */
define(['baja!', 'baja!ndriver:NPointFolder', 'Promise', 'underscore', 'nmodule/ndriver/rc/Automanager', 'nmodule/ndriver/rc/util/util', 'nmodule/ndriver/rc/util/rpcUtil', 'nmodule/ndriver/rc/util/modelUtil', 'nmodule/driver/rc/wb/mgr/PointMgr', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/driver/rc/wb/mgr/PointMgrModel'], function (baja, types, Promise, _, addAutomanagerSupport, util, rpcUtil, modelUtil, PointMgr, MgrTypeInfo, PointMgrModel) {
  'use strict';

  var DEFAULT_SUBSCRIPTION_DEPTH = 3;

  /**
   * A default bajaux Point Manager View for NDriver
   *
   * @class
   * @extends module:nmodule/driver/rc/wb/mgr/PointMgr
   * @alias module:nmodule/ndriver/rc/NPointManager
   */
  var NPointManager = function NPointManager(params) {
    var that = this;
    PointMgr.call(that, _.extend({
      // moduleName & keyName have to be specified here, otherwise
      // the DriverMgr constructor throws an error.
      // We'll attempt to set them to module specific values later (in makeModel())

      //[params.moduleName] the module name used for lexicon entries for this view.
      moduleName: 'ndriver',
      // [params.keyName] the key name used for lexicon entries for this view.
      keyName: 'NPointManager',
      // folderType is set to 'dummy' value (albeit valid), because the mixin doesn't
      // initialise properly if you don't. Again we'll change it in makeModel()

      // [params.folderType] optional parameter indicating the folder type used for the manager view. This will be used by the NewFolder command.
      folderType: baja.lt('ndriver:NPointFolder'),
      //[params.subscriptionDepth] the depth to subscribe the component tree.
      subscriptionDepth: DEFAULT_SUBSCRIPTION_DEPTH
    }, params));
    addAutomanagerSupport(that);
  };
  NPointManager.prototype = Object.create(PointMgr.prototype);
  NPointManager.prototype.constructor = NPointManager;

  /**
   * Setup information required by this manager, usually acquired by means of an rpc call to populate
   * values from the ndriver/Automanager interfaces
   *
   * @param {baja.Component} component - the value being loaded into the manager.
   * @return {Object} key/value pairs of manager info
   */
  NPointManager.prototype.setUpManagerInfo = function (component) {
    var that = this,
      pointManagerType = util.getNPointDeviceExt(component).getType(),
      pointManagerTypeSpec = pointManagerType.getTypeSpec();
    return rpcUtil.getPointManagerInfo(pointManagerTypeSpec).then(function (pointManagerInfo) {
      that.$deviceTypeSpec = rpcUtil.getDeviceTypeSpecFromResult(pointManagerInfo);
      that.$folderType = rpcUtil.getPointFolderTypeSpecFromResult(pointManagerInfo);
      that.$proxyExtTypeSpec = rpcUtil.getProxyExtTypeSpecFromResult(pointManagerInfo);
      that.$moduleName = pointManagerType.getModuleName();
      return pointManagerInfo;
    });
  };

  /**
   * An array of type specs that this manager implementation needs
   *
   * @abstract
   * @return {Array.<String>} An array of typeSpecs strings
   */
  NPointManager.prototype.getManagerTypes = function () {
    return [this.getDeviceTypeSpec(), this.getFolderType(), this.getProxyExtTypeSpec()];
  };

  /**
   * Make the MgrModel for this Point Manager.
   *
   * @param {baja.Component} component - the NPointDeviceExt or NPointFolder that the Point Manager will display.
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/model/MgrModel>}
   */
  NPointManager.prototype.makeModel = function (component) {
    var that = this;
    return Promise.all([PointMgrModel.getDefaultNewTypes(), modelUtil.makeColumns(that, component)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        newTypes = _ref2[0],
        columns = _ref2[1];
      return new PointMgrModel({
        component: component,
        newTypes: newTypes,
        folderType: baja.lt(that.getFolderType()),
        proxyExtType: that.getProxyExtTypeSpec(),
        columns: columns
      });
    }).then(function (model) {
      var superNewInstance = model.newInstance;

      /**
       * Override the model's newInstance function.
       *
       * @param {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} typeInfo
       * @param {Object} [params]
       * @param {baja.Complex} [params.discovery] a discovery item
       * @returns {Promise.<baja.Component>} resolves to a new component instance.
       */
      model.newInstance = function (typeInfo, params) {
        return that.getNewInstance(typeInfo, params, superNewInstance, this /* the model */);
      };
      return model;
    });
  };

  /**
   * return the proxy ext type spce used by this manager
   *
   * @return {String}
   */
  NPointManager.prototype.getProxyExtTypeSpec = function () {
    return this.$proxyExtTypeSpec;
  };

  /**
   * return the component that has discovery interface implementations for this manager
   *
   * @return {baja.Component}
   */
  NPointManager.prototype.getDiscoveryComponent = function () {
    return util.getNPointDeviceExt(this.value());
  };
  return NPointManager;
});
