/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['lex!bacnet', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel'], function (lexs, IconColumn, PropertyColumn, TreeTableModel) {
  'use strict';

  var bacnetLex = lexs[0];
  function lex(key) {
    return bacnetLex.get(key);
  }

  //
  // Column for the row's icon - choose the icon based on the ASN type of the BACnet property.
  //
  var DiscoveryIconColumn = function DiscoveryIconColumn() {
    IconColumn.apply(this, arguments);
  };
  DiscoveryIconColumn.prototype = Object.create(IconColumn.prototype);
  DiscoveryIconColumn.prototype.constructor = DiscoveryIconColumn;
  DiscoveryIconColumn.prototype.getValueFor = function (row) {
    return row.getTreeNode().$icon;
  };

  //
  // Simple property column for reading a property value from
  // the BDiscoveryPoint vector.
  //

  var COLUMNS = [new DiscoveryIconColumn(), new PropertyColumn('objectName', {
    displayName: lex('learn.objectName')
  }), new PropertyColumn('objectId', {
    displayName: lex('learn.objectId')
  }), new PropertyColumn('propertyIdentifier', {
    displayName: lex('pointManager.property')
  }), new PropertyColumn('index', {
    displayName: lex('pointManager.index')
  }), new PropertyColumn('value', {
    displayName: lex('pointManager.value')
  }), new PropertyColumn('description', {
    displayName: lex('pointManager.description')
  })];

  /**
   * API Status: **Private**
   * @exports nmodule/bacnet/rc/wb/mgr/model/BacnetPointLearnModel
   */
  var exports = {};

  /**
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
   */
  exports.make = function () {
    return TreeTableModel.make({
      columns: COLUMNS
    });
  };
  return exports;
});
