function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/WritableSlotsEditor
 */
define(['bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'lex!bacnet', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BooleanPicker'], function (spandrel, Command, CommandButton, lexs, Promise, feDialogs, BooleanPicker) {
  'use strict';

  var numbers1to16 = _toConsumableArray(Array(17).keys()).slice(1);
  var choices = getChoices();
  var _lexs = _slicedToArray(lexs, 1),
    bacnetLex = _lexs[0];
  var lexNotWritable = bacnetLex.get({
    key: "server.notWritable",
    "default": "server.notWritable"
  });
  function getChoices() {
    return numbers1to16.map(function (key) {
      return {
        value: key
      };
    });
  }
  function stringToOrdinals(value) {
    if (value === lexNotWritable) {
      return [];
    }
    var selectedOrdinals = [];
    var inValues = value.split(',').map(function (inValue) {
      return inValue.substring(2);
    });
    choices.forEach(function (key) {
      var keyAsString = String(key.value);
      if (inValues.includes(keyAsString)) {
        selectedOrdinals.push(key.value);
      }
    });
    return selectedOrdinals;
  }
  function ordinalsToString(array) {
    return array.map(function (entry) {
      return "in" + entry;
    }).join(',');
  }

  /**
   * WritableSlotsEditor is a Widget for editing the BACnet writability of a `bacnet:IBacnetExportObject`.
   *
   * @class
   * @alias module:nmodule/bacnet/rc/fe/WritableSlotsEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @since Niagara 4.14
   */
  var WritableSlotsEditor = /*#__PURE__*/function (_spandrel) {
    function WritableSlotsEditor(params) {
      var _this;
      _classCallCheck(this, WritableSlotsEditor);
      _this = _callSuper(this, WritableSlotsEditor, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: '-t-WritableSlotsEditor'
          }
        }
      }]);
      _this.$clearCmd = new Command({
        module: 'bacnet',
        lex: 'writableFE.clearAll',
        func: function func() {
          _this.state({
            booleans: []
          }).then(function () {
            _this.setModified(true);
          })["catch"](feDialogs.error);
        }
      });
      _this.$selectAllCmd = new Command({
        module: 'bacnet',
        lex: 'writableFE.selectAll',
        func: function func() {
          _this.state({
            booleans: numbers1to16
          }).then(function () {
            _this.setModified(true);
          })["catch"](feDialogs.error);
        }
      });
      return _this;
    }
    _inherits(WritableSlotsEditor, _spandrel);
    return _createClass(WritableSlotsEditor, [{
      key: "toState",
      value: function toState(value) {
        var booleans = stringToOrdinals(value);
        return {
          innerValue: value,
          booleans: booleans
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var booleans = _ref.booleans;
        return ordinalsToString(booleans);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getInnerValueEditor",
      value: function $getInnerValueEditor() {
        return this.queryWidget('innerValue');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getBooleanPicker",
      value: function $getBooleanPicker() {
        return this.queryWidget('booleans');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getClearCommand",
      value: function $getClearCommand() {
        return this.queryWidget('clear');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSelectAllCommand",
      value: function $getSelectAllCommand() {
        return this.queryWidget('selectAll');
      }
    }]);
  }(spandrel(function (value, _ref2) {
    var self = _ref2.self,
      booleans = _ref2.booleans,
      innerValue = _ref2.innerValue,
      writable = _ref2.writable;
    if (!writable) {
      return [spandrel.jsx("any", {
        bind: true,
        spandrelKey: "innerValue",
        value: innerValue
      })];
    }
    return [spandrel.jsx(BooleanPicker, {
      bind: true,
      tagName: "span",
      spandrelKey: "booleans",
      value: booleans,
      properties: {
        choices: choices
      }
    }), spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      spandrelKey: "clear",
      className: "ux-btn-tb",
      value: self.$clearCmd
    }), spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      spandrelKey: "selectAll",
      value: self.$selectAllCmd
    })];
  }, {
    strategy: 'niagara'
  }));
  return WritableSlotsEditor;
});
