function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/fe/BacnetObjectIdEditor
 */
define(['baja!', 'jquery', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'underscore', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/bacnet/rc/baja/datatypes/BacnetObjectIdentifier', 'bajaux/events', 'bajaux/Widget', 'baja!bacnet:BacnetObjectType'], function (baja, $, BaseEditor, _, Promise, fe, BacnetObjectIdentifier, events, Widget) {
  'use strict';

  var DESTROY_EVENT = events.DESTROY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT;

  /**
   * Editor for handling `bacnet:BacnetObjectIdentifier` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/bacnet/rc/fe/BacnetObjectIdEditor
   */
  var BacnetObjectIdEditor = function BacnetObjectIdEditor() {
    BaseEditor.apply(this, arguments);
  };
  BacnetObjectIdEditor.prototype = Object.create(BaseEditor.prototype);
  BacnetObjectIdEditor.prototype.constructor = BacnetObjectIdEditor;

  /**
   * Initialize the bacnet object id editor
   * @param {JQuery} dom
   */
  BacnetObjectIdEditor.prototype.doInitialize = function (dom) {
    var that = this;
    //Disable events from bubbling up
    dom.on([DESTROY_EVENT, INITIALIZE_EVENT, LOAD_EVENT, ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    return Promise.all([fe.buildFor({
      dom: $('<span class="js-objType" />').appendTo(dom),
      value: baja.DynamicEnum.make({
        range: baja.$('bacnet:BacnetObjectType').getRange()
      }),
      formFactor: 'mini'
    }), fe.buildFor({
      dom: $('<span class="js-instance" />').appendTo(dom),
      value: baja.Integer.DEFAULT,
      formFactor: 'mini'
    })]);
  };

  /**
   * @param {baja.Simple}  boValue `bacnet:BacnetObjectIdentifier` value to load
   */
  BacnetObjectIdEditor.prototype.doLoad = function (boValue) {
    var that = this,
      objType;
    var range = this.properties().getValue('range');
    if (range) {
      objType = baja.DynamicEnum.make({
        ordinal: boValue.getObjectType(),
        range: range
      });
    } else {
      objType = baja.DynamicEnum.make({
        ordinal: boValue.getObjectType(),
        range: baja.$('bacnet:BacnetObjectType').getRange()
      });
    }
    return Promise.all([that.$getSelect().load(objType), that.$getInstanceInput().load(boValue.getInstanceNumber())]);
  };
  /**
   * Read the set values in UI
   * @return {baja.Simple} The read `bacnet:BacnetObjectIdentifier` value
   */
  BacnetObjectIdEditor.prototype.doRead = function () {
    return Promise.all([this.$getSelect().read(), this.$getInstanceInput().read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        objType = _ref2[0],
        objInst = _ref2[1];
      return baja.$("bacnet:BacnetObjectIdentifier", objType.getOrdinal(), objInst);
    });
  };

  /**
   * Make the widgets read only
   *
   * @param {Boolean} readonly
   */
  BacnetObjectIdEditor.prototype.doReadonly = function (readonly) {
    return Promise.all([this.$getSelect().setReadonly(readonly), this.$getInstanceInput().setReadonly(readonly)]);
  };

  /**
   * Make the widgets enabled/disabled
   *
   * @param {Boolean} enabled
   */
  BacnetObjectIdEditor.prototype.doEnabled = function (enabled) {
    return Promise.all([this.$getSelect().setEnabled(enabled), this.$getInstanceInput().setEnabled(enabled)]);
  };

  /**
   * Destroy all the child editors
   * @returns {*}
   */
  BacnetObjectIdEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };

  /**
   * Get the select element.
   *
   * @private
   * @returns {module:bajaux/Widget}
   */
  BacnetObjectIdEditor.prototype.$getSelect = function () {
    return Widget["in"](this.jq().children('.js-objType'));
  };

  /**
   * Get the instance element.
   *
   * @private
   * @returns {module:bajaux/Widget}
   */
  BacnetObjectIdEditor.prototype.$getInstanceInput = function () {
    return Widget["in"](this.jq().children('.js-instance'));
  };
  return BacnetObjectIdEditor;
});
