/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnet/rc/baja/point/BacnetProxyExt
 */
define(['nmodule/driver/rc/baja/ProxyExt', 'nmodule/webEditors/rc/fe/baja/util/compUtils'], function (ProxyExt, compUtils) {
  'use strict';

  var closest = compUtils.closest;

  /**
   * BajaScript representation of an `bacnet:BacnetProxyExt` value.
   *
   * @class
   * @extends {module:nmodule/driver/rc/baja/ProxyExt}
   * @alias {module:nmodule/bacnet/rc/baja/point/BacnetProxyExt}
   */
  var BacnetProxyExt = function BacnetProxyExt() {
    ProxyExt.apply(this, arguments);
  };
  BacnetProxyExt.prototype = Object.create(ProxyExt.prototype);
  BacnetProxyExt.prototype.constructor = BacnetProxyExt;

  /**
   * If mounted, find the `enumerationList` slot of the closest containing
   * `BacnetDevice`. Return its `objectTypeFacets` or `propertyIdFacets` for the
   * `objectId` or `propertyId` slots, respectively.
   *
   * Otherwise, return slot facets as normal.
   *
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */
  BacnetProxyExt.prototype.getFacets = function (slot) {
    if (this.isMounted()) {
      var device = closest(this, 'bacnet:BacnetDevice');
      if (device) {
        var enumList = device.get('enumerationList');
        switch (String(slot)) {
          case 'objectId':
            return enumList.get('objectTypeFacets');
          case 'propertyId':
            return enumList.get('propertyIdFacets');
        }
      }
    }
    return ProxyExt.prototype.getFacets.apply(this, arguments);
  };
  return BacnetProxyExt;
});
