function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraStationManagerModel
 */

define(['baja!', 'baja!fox:FoxClientConnection,fox:FoxServerConnection,niagaraDriver:NiagaraStation,niagaraDriver:NiagaraEdgeLiteStation', 'lex!niagaraDriver', 'Promise', 'nmodule/driver/rc/wb/mgr/DeviceMgrModel', 'nmodule/driver/rc/wb/mgr/columns/DeviceExtsMgrColumn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/mgrAgents', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/DisplayNameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, Promise, DeviceMgrModel, DeviceExtsMgrColumn, MgrTypeInfo, mgrAgents, MgrColumn, DisplayNameMgrColumn, NameMgrColumn, PathMgrColumn, PropertyMgrColumn, PropertyPathMgrColumn, IconMgrColumn, TypeMgrColumn, Column) {
  'use strict';

  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN,
    READONLY = _Column$flags.READONLY;
  var _lexs = _slicedToArray(lexs, 1),
    niagaraDriverLex = _lexs[0];
  var CLIENT_CONNECTION_TEXT = niagaraDriverLex.get('stationManager.clientConn');
  var SERVER_CONNECTION_TEXT = niagaraDriverLex.get('stationManager.serverConn');
  var STATION_TYPE = baja.lt('niagaraDriver:NiagaraStation');
  var FOX_CONNECTION_TYPE = baja.lt('fox:FoxClientConnection');
  function makeColumns() {
    return [new IconMgrColumn(), new PathMgrColumn({
      flags: UNSEEN | READONLY
    }), new NameMgrColumn({
      flags: EDITABLE
    }), new TypeMgrColumn({
      flags: EDITABLE | UNSEEN
    }), new DeviceExtsMgrColumn('deviceExts', {
      component: baja.$('niagaraDriver:NiagaraStation')
    }), new PropertyMgrColumn('address', {
      flags: EDITABLE,
      type: STATION_TYPE
    }), new PropertyPathMgrColumn('clientConnection/port', {
      flags: EDITABLE | UNSEEN,
      type: FOX_CONNECTION_TYPE
    }), new PropertyPathMgrColumn('clientConnection/useFoxs', {
      flags: EDITABLE | UNSEEN,
      type: FOX_CONNECTION_TYPE
    }), new PropertyPathMgrColumn('clientConnection/foxOverWebsocket', {
      flags: EDITABLE | UNSEEN,
      type: FOX_CONNECTION_TYPE
    }), new PropertyPathMgrColumn('clientConnection/foxOverWebsocketPort', {
      flags: EDITABLE | UNSEEN,
      type: FOX_CONNECTION_TYPE
    }), new PropertyMgrColumn('hostModel', {
      type: STATION_TYPE
    }), new PropertyMgrColumn('hostModelVersion', {
      flags: UNSEEN,
      type: STATION_TYPE
    }), new PropertyMgrColumn('version', {
      type: STATION_TYPE
    }), new PropertyPathMgrColumn('clientConnection/credentialStore', {
      flags: UNSEEN | EDITABLE,
      type: FOX_CONNECTION_TYPE
    }), new PropertyMgrColumn('status', {
      type: STATION_TYPE
    }), new PropertyMgrColumn('enabled', {
      flags: EDITABLE | UNSEEN,
      type: STATION_TYPE
    }), new PropertyMgrColumn('health', {
      type: STATION_TYPE
    }), new PropertyMgrColumn('faultCause', {
      flags: UNSEEN,
      type: STATION_TYPE
    }), new PropertyPathMgrColumn('clientConnection/state', {
      flags: UNSEEN,
      type: FOX_CONNECTION_TYPE,
      displayName: CLIENT_CONNECTION_TEXT
    }), new ServerConnectionStationStatusColumn(), new PropertyMgrColumn('virtualsEnabled', {
      flags: EDITABLE,
      type: STATION_TYPE
    })];
  }
  function edgeLiteToBottom(a, b) {
    var aEqualsNiagaraStation = a.getType().toString() === "niagaraDriver:NiagaraStation";
    var bEqualsNiagaraStation = b.getType().toString() === "niagaraDriver:NiagaraStation";
    var isAEdgeLite = baja.hasType(a, 'niagaraDriver:NiagaraEdgeLiteStation');
    var isBEdgeLite = baja.hasType(b, 'niagaraDriver:NiagaraEdgeLiteStation');
    if (!aEqualsNiagaraStation && !isAEdgeLite) {
      return 2;
    }
    if (!bEqualsNiagaraStation && !isBEdgeLite) {
      return -2;
    }
    if (isAEdgeLite) {
      return 1;
    }
    if (isBEdgeLite) {
      return -1;
    }
    return 0;
  }
  function resolveNewTypes() {
    return MgrTypeInfo.make({
      from: 'niagaraDriver:NiagaraStation',
      concreteTypes: true
    }).then(function (newTypes) {
      return newTypes.filter(function (t) {
        return !baja.hasType(t, 'niagaraDriver:IExternallyManagedNiagaraStation');
      }).sort(edgeLiteToBottom);
    });
  }
  var FOX_SERVER_CONN_TEXT = baja.$('fox:FoxServerConnection').get('state').toString();

  /**
   * MgrColumn for the server state
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var ServerConnectionStationStatusColumn = /*#__PURE__*/function (_MgrColumn) {
    function ServerConnectionStationStatusColumn() {
      _classCallCheck(this, ServerConnectionStationStatusColumn);
      return _callSuper(this, ServerConnectionStationStatusColumn, ['serverState', {
        type: FOX_CONNECTION_TYPE,
        displayName: SERVER_CONNECTION_TEXT
      }]);
    }

    /**
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(ServerConnectionStationStatusColumn, _MgrColumn);
    return _createClass(ServerConnectionStationStatusColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        return row.getSubject().getServerConnection().then(function (serverConnection) {
          var text = serverConnection ? serverConnection.get('state') : FOX_SERVER_CONN_TEXT;
          dom.text(text);
          row.data('serverConnectionName', serverConnection ? serverConnection.getName() : ''); //cache this for subscription purposes
        });
      }
    }]);
  }(MgrColumn);
  /**
   * Represents the model backing the Niagara Station Ux Manager view
   *
   * @class
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgrModel
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraStationManagerModel
   */
  var NiagaraStationManagerModel = /*#__PURE__*/function (_DeviceMgrModel) {
    function NiagaraStationManagerModel() {
      _classCallCheck(this, NiagaraStationManagerModel);
      return _callSuper(this, NiagaraStationManagerModel, arguments);
    }
    _inherits(NiagaraStationManagerModel, _DeviceMgrModel);
    return _createClass(NiagaraStationManagerModel, [{
      key: "newInstance",
      value:
      /**
       * @param {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} typeInfo
       * @returns {Promise.<baja.Component>} to be resolved to a new `NiagaraStation`
       * instance with secure settings applied by default
       */
      function newInstance(typeInfo) {
        return typeInfo.newInstance().then(function (station) {
          var clientConnection = station.get('clientConnection');
          return Promise.all([clientConnection.set({
            slot: 'port',
            value: 4911
          }), clientConnection.set({
            slot: 'useFoxs',
            value: true
          })]).then(function () {
            return station;
          });
        });
      }
    }], [{
      key: "make",
      value: function make(component) {
        return Promise.all([makeColumns(), resolveNewTypes(), mgrAgents.getMixInColumns('niagaraDriver:NiagaraStation')]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 3),
            columns = _ref2[0],
            newTypes = _ref2[1],
            mixinCols = _ref2[2];
          return new NiagaraStationManagerModel({
            component: component,
            columns: columns.concat(mixinCols),
            newTypes: newTypes,
            folderType: 'niagaraDriver:NiagaraStationFolder'
          });
        });
      }
    }]);
  }(DeviceMgrModel);
  return NiagaraStationManagerModel;
});
