function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/wb/mgr/NiagaraScheduleImportUxManager
 * @since Niagara 4.14
 */
define(['baja!', 'baja!niagaraDriver:NiagaraScheduleImportExt,schedule:CompositeSchedule', 'log!nmodule.niagaraDriver.rc.wb.mgr.NiagaraScheduleImportUxManager', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/schedule/scheduleMgrUtils', 'nmodule/driver/rc/wb/mgr/schedule/ScheduleImportManager', 'nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraScheduleImportModel', 'nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraScheduleLearnModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/commands/MatchCommand', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, types, log, Promise, _, scheduleMgrUtils, ScheduleImportManager, NiagaraScheduleImportModel, NiagaraScheduleLearnModel, compUtils, MgrLearn, MgrTypeInfo, MatchCommand, TreeNode) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var getExt = scheduleMgrUtils.getExt;
  /**
   * @class
   * @alias module:nmodule/niagaraDriver/rc/wb/mgr/NiagaraScheduleImportUxManager
   * @extends module:nmodule/driver/rc/wb/mgr/schedule/ScheduleImportManager
   */
  return /*#__PURE__*/function (_ScheduleImportManage) {
    function NiagaraScheduleImportUxManager(params) {
      var _this;
      _classCallCheck(this, NiagaraScheduleImportUxManager);
      _this = _callSuper(this, NiagaraScheduleImportUxManager, [Object.assign({
        moduleName: 'niagaraDriver',
        keyName: 'NiagaraScheduleImportUxManager',
        subscriptionDepth: 4
      }, params)]);
      MgrLearn(_this);
      return _this;
    }

    /**
     * Initial DOM setup
     *
     * @param {JQuery} dom the DOM element into which to load this View
     * @return {Promise}
     */
    _inherits(NiagaraScheduleImportUxManager, _ScheduleImportManage);
    return _createClass(NiagaraScheduleImportUxManager, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        this.on('jobcomplete', function (job) {
          _this2.$doDiscoveryJobComplete(job)["catch"](logSevere);
        });
        return _superPropGet(NiagaraScheduleImportUxManager, "doInitialize", this, 3)(arguments);
      }

      /**
       * @param {baja.Component} scheduleContainer
       * @returns {Promise.<module:nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraScheduleImportModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel(scheduleContainer) {
        return NiagaraScheduleImportModel.make(scheduleContainer);
      }

      /**
       * @returns {Promise.<module:nmodule/niagaraDriver/rc/wb/mgr/model/NiagaraScheduleLearnModel>}
       */
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return NiagaraScheduleLearnModel.make();
      }

      /**
       * Returns the scheduleDeviceDriver ext for the current loaded component.
       * @returns {baja.Component}
       */
    }, {
      key: "getDeviceExt",
      value: function getDeviceExt() {
        return compUtils.closest(this.value(), baja.lt('niagaraDriver:NiagaraScheduleDeviceExt'));
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this3 = this;
        var deviceExt = this.getDeviceExt();
        return deviceExt.submitDiscoveryJob().then(function (ord) {
          ord = baja.Ord.make({
            base: baja.Ord.make('station:'),
            child: ord.relativizeToSession()
          });
          return _this3.setJob({
            jobOrOrd: ord,
            depth: 2
          });
        });
      }

      /**
       *
       * @returns {object}
       */
    }, {
      key: "saveStateForOrd",
      value: function saveStateForOrd() {
        var obj = {};
        if (this.$discoveredSchedules) {
          this.$discoveredSchedules.forEach(function (schedule) {
            var scheduleName = schedule.getName();
            var comp = baja.$('baja:Component', _defineProperty({}, scheduleName, schedule.newCopy()));
            obj[scheduleName] = baja.bson.encodeValue(comp);
          });
        }
        return obj;
      }

      /**
       * @param {Object} obj - an object with data retrieved from the browser
       * storage.
       * @returns {Promise}
       */
    }, {
      key: "restoreStateForOrd",
      value: function restoreStateForOrd(obj) {
        var _this4 = this;
        if (obj) {
          return Promise.all(Object.entries(obj).map(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              comp = _ref2[1];
            return baja.bson.decodeAsync(comp).then(function (c) {
              return c.get(key);
            });
          })).then(function (decodedSchedules) {
            _this4.$discoveredSchedules = decodedSchedules;
            return _this4.$updateLearnTableModel();
          });
        }
        return Promise.resolve();
      }

      /**
       * Returns the types for discovery
       * @param {baja.Value} subject the subject that we are matching
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>|Promise}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(subject) {
        return Promise.resolve(MgrTypeInfo.make(subject.getTypeStr()));
      }

      /**
       * Returns an object with the proposed subject for the manager AddCommand & MatchCommand
       * @param {baja.Component} discovery
       * @param {baja.Component} subject when a match is done, it is the database point that we are matching to
       * @returns {Promise.<Object>}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, subject) {
        var supervisorId = discovery.getSupervisorId();
        return Promise.resolve({
          name: discovery.getName(),
          values: {
            "supervisorId": supervisorId
          }
        });
      }

      /**
       * Returns true if the supervisorId matches.
       *
       * @param {baja.Complex} discovery
       * @param {baja.Component} comp
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(discovery, comp) {
        return discovery.getSupervisorId() === getExt(comp).getSupervisorId();
      }

      /**
       * @private
       * @param {baja.Component} job
       * @returns {Promise}
       */
    }, {
      key: "$doDiscoveryJobComplete",
      value: function $doDiscoveryJobComplete(job) {
        this.$discoveredSchedules = job.getSlots().is('niagaraDriver:NiagaraScheduleLearnResult').toValueArray();
        return this.$updateLearnTableModel();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateLearnTableModel",
      value: function $updateLearnTableModel() {
        var learnModel = this.getLearnModel();
        var discoveries = this.$discoveredSchedules;
        var nodes = discoveries ? discoveries.map(makeDiscoveryTableNode) : [];
        return learnModel.clearRows().then(function () {
          return learnModel.insertRows(nodes, 0);
        });
      }

      /**
       * @param {*} learnSelection the subject selected in the learn table
       * @param {baja.Component} mainSelection the subject from the main table that the learnSelection
       * subject is being matched to
       * @returns {boolean}
       */
    }, {
      key: "isMatchable",
      value: function isMatchable(learnSelection, mainSelection) {
        return mainSelection.getType().is(learnSelection.getTypeStr());
      }
    }]);
  }(ScheduleImportManager);

  /**
   * Make a tree node for an item in the discovery table.
   *
   * @param  {Object} discovery - a discovered object.
   * @returns {module:nmodule/webEditors/rc/wb/tree/TreeNode}
   */
  function makeDiscoveryTableNode(discovery) {
    var name = discovery.getName(),
      node = new TreeNode(name, name);
    node.getIcon = _.constant(discovery.getIcon());
    node.mayHaveKids = _.constant(false);
    node.value = _.constant(discovery);
    return node;
  }
});
