function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/niagaraDriver/rc/fe/RemoteStationEditor
 */
define(['baja!', 'baja!niagaraDriver:NiagaraStation', 'lex!alarm', 'Promise', 'underscore', 'dialogs', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils'], function (baja, types, lexs, Promise, _, dialogs, spandrel, OrderedMapEditor, spaceUtils) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
      return {
        properties: {
          rootCssClass: '-t-RemoteStationEditor'
        }
      };
    },
    resolveService = spaceUtils.resolveService,
    alarmLex = lexs[0],
    SELECT_STATION_MSG = alarmLex.get('stationRecipient.selectStation'),
    PROGRESS_BAR_DELAY = 500;
  var _retrieveStationNames = function retrieveStationNames(stationNames, parent) {
    return parent.loadSlots().then(function () {
      var promises = [];
      parent.getSlots().properties().each(function (prop) {
        if (prop.getType().is('niagaraDriver:NiagaraStation')) {
          stationNames.push(prop.getName());
        } else if (prop.getType().is('baja:Folder')) {
          promises.push(_retrieveStationNames(stationNames, parent.get(prop)));
        }
      });
      return Promise.all(promises);
    });
  };

  /**
   * Editor to represent stations as a dynamic text box or a dropdown.
   *
   * It accepts the following Properties:
   *
   * - `allowCustomEntry`: (boolean) If set to true, a dropdown of the existing values will be displayed.
   * If the current value is not a station then the current value will also be displayed so the user knows
   * that the current value is improperly configured.
   *
   * @class
   * @alias module:nmodule/niagaraDriver/rc/fe/RemoteStationEditor
   * @extends {module:bajaux/spandrel}
   */
  var RemoteStationEditor = /*#__PURE__*/function (_spandrel) {
    function RemoteStationEditor(params) {
      _classCallCheck(this, RemoteStationEditor);
      return _callSuper(this, RemoteStationEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(RemoteStationEditor, _spandrel);
    return _createClass(RemoteStationEditor, [{
      key: "toState",
      value: function toState(stationName) {
        var _this = this;
        return this.$getRemoteStationNames().then(function (stationNames) {
          var allowCustomEntry = _this.properties().getValue('allowCustomEntry');
          _this.$stationNames = allowCustomEntry !== false ? stationNames.join(';') : stationNames;
          return {
            stationName: stationName
          };
        });
      }
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var stationName = _ref.stationName;
        return stationName === SELECT_STATION_MSG ? '' : stationName;
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStationNameEditor",
      value: function $getStationNameEditor() {
        return this.queryWidget('**/stationName');
      }

      /**
       * Resolve all the station names contained directly underneath the station's
       * `NiagaraNetwork`, or as members of child folders.
       *
       * @private
       * @returns {Promise.<Array.<String>>} promise to be resolved with an array of station names
       */
    }, {
      key: "$getRemoteStationNames",
      value: function $getRemoteStationNames() {
        var stationNames = [];
        return this.$getNiagaraNetwork().then(function (network) {
          return _retrieveStationNames(stationNames, network);
        })["catch"](function () {/*if the network could not be found, just resolve empty array*/}).then(function () {
          stationNames.sort(function (a, b) {
            return a.toLowerCase().localeCompare(b.toLowerCase());
          });
          return stationNames;
        });
      }

      /**
       * @private
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$getOrdBase",
      value: function $getOrdBase() {
        return Promise.resolve(this.properties().getValue('ordBase') || this.getComplex && typeof this.getComplex === "function" && this.getComplex());
      }

      /**
       * @private
       * @returns {Promise<baja.Component>}
       */
    }, {
      key: "$getNiagaraNetwork",
      value: function $getNiagaraNetwork() {
        return this.$getOrdBase().then(function (base) {
          var promise = resolveService('niagaraDriver:NiagaraNetwork', {
            base: base
          });
          dialogs.showLoading(PROGRESS_BAR_DELAY, promise);
          return promise;
        });
      }

      /**
       * @param {baja.Component} [ordBase]
       * @returns {Promise.<Array.<String>>} promise to be resolved with an array of station names.
       */
    }], [{
      key: "resolveRemoteStationNames",
      value: function resolveRemoteStationNames(ordBase) {
        return new RemoteStationEditor({
          properties: ordBase
        }).$getRemoteStationNames();
      }
    }]);
  }(spandrel(function (comp, _ref2) {
    var self = _ref2.self,
      stationName = _ref2.stationName,
      properties = _ref2.properties;
    var allowCustomEntry = properties.allowCustomEntry;
    var stationNames = self.$stationNames;
    if (allowCustomEntry !== false) {
      return spandrel.jsx("any", {
        bind: true,
        spandrelKey: "stationName",
        value: stationName,
        properties: {
          datalist: stationNames,
          placeholder: SELECT_STATION_MSG
        }
      });
    }
    if (!stationNames.contains(stationName)) {
      stationNames = [stationName].concat(_toConsumableArray(stationNames));
    }
    return spandrel.jsx(OrderedMapEditor, {
      bind: true,
      spandrelKey: "stationName",
      value: stationName,
      properties: {
        map: stationNames
      }
    });
  }, {
    strategy: 'niagara'
  }));
  return RemoteStationEditor;
});
