function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _wrapNativeSuper(t) { var r = "function" == typeof Map ? new Map() : void 0; return _wrapNativeSuper = function _wrapNativeSuper(t) { if (null === t || !_isNativeFunction(t)) return t; if ("function" != typeof t) throw new TypeError("Super expression must either be null or a function"); if (void 0 !== r) { if (r.has(t)) return r.get(t); r.set(t, Wrapper); } function Wrapper() { return _construct(t, arguments, _getPrototypeOf(this).constructor); } return Wrapper.prototype = Object.create(t.prototype, { constructor: { value: Wrapper, enumerable: !1, writable: !0, configurable: !0 } }), _setPrototypeOf(Wrapper, t); }, _wrapNativeSuper(t); }
function _construct(t, e, r) { if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments); var o = [null]; o.push.apply(o, e); var p = new (t.bind.apply(t, o))(); return r && _setPrototypeOf(p, r.prototype), p; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _isNativeFunction(t) { try { return -1 !== Function.toString.call(t).indexOf("[native code]"); } catch (n) { return "function" == typeof t; } }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/dashboard/rc/ux/DashboardPane
 */
define(['baja!', 'lex!dashboard', 'log!nmodule.dashboard.rc.ux.DashboardPane', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/container/util', 'jquery', 'Promise', 'underscore', 'nmodule/bajaui/rc/ux/BaseDashboardPane', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/bajaui/rc/ux/WebWidget', 'nmodule/dashboard/rc/dashboard', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'css!nmodule/dashboard/rc/dashboard'], function (baja, lexs, log, spandrel, Widget, util, $, Promise, _, BaseDashboardPane, NullWidget, WebWidget, dashboard, typeUtils, profileUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    dashboardLex = _lexs[0];
  var logSevere = log.severe.bind(log);
  var applyWebPropertyToWidget = util.applyWebPropertyToWidget;
  var isEmpty = _.isEmpty,
    isObject = _.isObject;
  var isAssignableFrom = typeUtils.isAssignableFrom;
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'dashboard',
      keyName: 'DashboardPane',
      properties: {
        rootCssClass: 'ux-DashboardPane',
        id: baja.Format.make('%ord%;%viewId%;%widgetOrd%;%jsOrd%')
      }
    };
  };
  var getOrdWithoutViewQuery = profileUtils.getOrdWithoutViewQuery,
    resolveCurrentViewId = profileUtils.resolveCurrentViewId;

  /**
   * 
   * @private
   * @class
   * @alias module:nmodule/dashboard/rc/ux/DashboardPane~DashboardPaneError
   * @extends Error 
   */
  var DashboardPaneError = /*#__PURE__*/function (_Error) {
    function DashboardPaneError() {
      _classCallCheck(this, DashboardPaneError);
      return _callSuper(this, DashboardPaneError, arguments);
    }
    _inherits(DashboardPaneError, _Error);
    return _createClass(DashboardPaneError);
  }(/*#__PURE__*/_wrapNativeSuper(Error));
  /**
   * `bajaux` implementation of `DashboardPane`.
   *
   * @class
   * @alias module:nmodule/dashboard/rc/ux/DashboardPane
   * @extends module:nmodule/bajaui/rc/ux/BaseDashboardPane
   */
  return /*#__PURE__*/function (_spandrel) {
    function DashboardPane(params) {
      _classCallCheck(this, DashboardPane);
      return _callSuper(this, DashboardPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @returns {module:bajaux/model/UxModel~UxModelParams} the default UxModel structure for a brand new DashboardPane
     * @since Niagara 4.15
     */
    _inherits(DashboardPane, _spandrel);
    return _createClass(DashboardPane, [{
      key: "$uxModelDefaults",
      value: function $uxModelDefaults() {
        return {
          kids: [{
            name: 'content',
            type: NullWidget,
            metadata: {
              typeSpec: 'bajaui:Widget'
            }
          }]
        };
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/WebWidget}
       */
    }, {
      key: "$getWebWidget",
      value: function $getWebWidget() {
        return this.queryWidget('0');
      }

      /**
       * Try to fetch any saved dashboard data and update the spandrel config
       *
       * @private
       * @param {module:bajaux/model/UxModel} model
       * @return {Promise}
       */
    }, {
      key: "$getConfig",
      value: function $getConfig(model) {
        var _this = this;
        var webWidgetModel = model.getKids()[0];
        // When DashBoardPane's content is undefined, or it's type is a NullWidget, reject with an error.
        if (!webWidgetModel || webWidgetModel.getType() === NullWidget) {
          return Promise.reject(new DashboardPaneError(dashboardLex.get('dashboardPane.addToContent')));
        }
        return resolveId(model).then(function (dashboardId) {
          return _this.$getDashboardData(dashboardId).then(function (dashboardData) {
            var hasDashboardData = !isEmpty(dashboardData);
            var config = webWidgetModel.toSpandrel('<div></div>');
            Object.assign(config, {
              hooks: {
                preInitialize: function preInitialize(widget) {
                  return applyDashboardProperties(widget, dashboardData);
                },
                postLoad: function postLoad(widget) {
                  var content = widget.$getContentWidget();
                  if (content) {
                    dashboard.initialize(content.jq(), dashboardId, hasDashboardData);
                    // postLoad of the WebWidget will not be called if there is no binding
                    // which means the toolbar will not get loaded for a dashboard pane
                    // The code below ensures toolbar is always added for the DashboardPane
                    if (content.properties().getValue('hideCommandBar')) {
                      return;
                    }
                    return widget.$getToolbar().load(content.getCommandGroup());
                  }
                }
              }
            });
            return [config];
          });
        });
      }

      /**
       * Retrieves dashboard data from the station. This resolves to an object that will be applied to
       * the content widget's properties. Prior to Niagara 4.14, the data would be saved to the station
       * as a name->value map. Values saved to the DashboardService after Niagara 4.14 will be actual
       * property definition objects with `value` and `typeSpec` attributes. Both of these cases must
       * be supported for backwards compatibility.
       *
       * @private
       * @param {String} id
       * @return {Promise.<Object.<string, module:bajaux/Properties~PropertyDefinition|*>>}
       */
    }, {
      key: "$getDashboardData",
      value: function $getDashboardData(id) {
        return this.$getDashboardService().then(function (service) {
          if (service.getEnabled()) {
            return service.invoke({
              slot: 'readDashboard',
              value: id
            });
          }
          // When DashboardService is available but not enabled, throw Error.
          throw new Error();
        }).then(function (data) {
          return JSON.parse(data || '{}');
        })["catch"](function () {
          throw new DashboardPaneError(dashboardLex.get('dashboardPane.errorStarting'));
        });
      }

      /**
       * Return a promise that resolves to the Station Dashboard Service.
       *
       * @private
       * @since Niagara 4.15
       * @returns {Promise} A promise that resolves to the Dashboard Service.
       */
    }, {
      key: "$getDashboardService",
      value: function $getDashboardService() {
        return baja.Ord.make("service:dashboard:DashboardService").get({
          lease: true
        });
      }

      /**
       * Child of DashboardPane must be a NullWidget or a WebWidget, but not a BWidget.
       *
       * @private
       * @since Niagara 4.15
       * @param {module:bajaux/model/UxModel} uxModel
       * @returns {boolean}
       */
    }, {
      key: "isChildLegal",
      value: function isChildLegal(uxModel) {
        return !isAssignableFrom(Widget, uxModel.getType()) || isAssignableFrom(NullWidget, uxModel.getType()) || isAssignableFrom(WebWidget, uxModel.getType());
      }
    }]);
  }(spandrel(function (model) {
    return this.$getConfig(model)["catch"](function (err) {
      if (err instanceof DashboardPaneError) {
        return [spandrel.jsx("div", {
          className: "ux-DashboardPane-messageWrapper"
        }, spandrel.jsx("label", null, err.message))];
      } else {
        logSevere(err);
      }
    });
  }, {
    "extends": BaseDashboardPane
  }));

  /**
   * @param {module:bajaux/Widget} widget
   * @param {Object.<string, module:bajaux/Properties~PropertyDefinition|*>} dashboardData the
   * dashboard data retrieved from the station - may be in name->value old style, or
   * name->{value, typeSpec} new style
   * @returns {Promise} to be resolved after the dashboard data is applied to the widget's
   * Properties
   */
  function applyDashboardProperties(widget, dashboardData) {
    var propertiesToAdd = [{
      // Always add the hidden 'dashboard' property
      hidden: true,
      name: 'dashboard',
      value: true,
      readonly: true,
      "transient": true,
      typeSpec: 'baja:Boolean'
    }];
    Object.keys(dashboardData).forEach(function (name) {
      var prop = dashboardData[name];
      if (!(isObject(prop) && 'value' in prop)) {
        prop = {
          value: prop
        };
      }
      propertiesToAdd.push(Object.assign({
        name: name
      }, prop));
    });
    return Promise.all(propertiesToAdd.map(function (prop) {
      return applyWebPropertyToWidget(prop, widget);
    }));
  }

  /**
   * This function resolves to a unique identifier used to read/save any configuration data
   * saved on the station.
   * Although it is a configurable property of the DashboardPane (id property), the
   * only format accepted is baja.Format.make('%ord%;%viewId%;%widgetOrd%;%jsOrd%')
   * 
   * @private
   * @inner
   * @param {module:bajaux/model/UxModel} model 
   * @returns {Promise.<String>}
   */
  function resolveId(model) {
    var webWidgetModel = model.getKids()[0];
    var _model$getProperties = model.getProperties(),
      id = _model$getProperties.id;
    var _webWidgetModel$getPr = webWidgetModel.getProperties(),
      js = _webWidgetModel$getPr.js,
      $widgetOrd = _webWidgetModel$getPr.$widgetOrd;
    var _ord = getOrdWithoutViewQuery();
    return resolveCurrentViewId().then(function (_viewId) {
      //swap the viewId if its for a BPxFile within the HxProfile.
      if (_viewId === "hx:HxPxView") {
        _viewId = "workbench:WbPxView";
      }
      return id.format({
        object: {
          ord: function ord() {
            return baja.SlotPath.escape(_ord.relativizeToSession().toString());
          },
          viewId: function viewId() {
            return baja.SlotPath.escape(_viewId);
          },
          widgetOrd: function widgetOrd() {
            return baja.SlotPath.escape($widgetOrd.toString());
          },
          jsOrd: function jsOrd() {
            return baja.SlotPath.escape(js.toString());
          }
        }
      });
    });
  }
});
